/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.strategy.GroupPropSearchStrategy;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.util.ModelUtil;

public class RecoverDataGroupUtil {
    static void checkListingGroup(ListingElement listing, ModuleParserHandler tmpHandler) {
        int targetGroupCount;
        ElementRefValue refValue = (ElementRefValue)listing.getLocalProperty(tmpHandler.module, "dataBindingRef");
        assert (refValue != null);
        tmpHandler.addUnresolveListingElement(listing);
        if (!refValue.isResolved()) {
            return;
        }
        DesignElement targetElement = refValue.getElement();
        if (!ModelUtil.isCompatibleDataBindingElements(listing, targetElement)) {
            return;
        }
        int elementGroupCount = listing.getGroups().size();
        if (elementGroupCount != (targetGroupCount = ((ListingElement)targetElement).getGroups().size())) {
            RecoverDataGroupUtil.recoverListingElement(listing, (ListingElement)targetElement, tmpHandler);
            tmpHandler.getErrorHandler().semanticWarning((Exception)((Object)new SemanticError((DesignElement)listing, new String[]{listing.getIdentifier(), targetElement.getIdentifier()}, "Error.SemanticError.INCONSISTENT_DATA_GROUP", 1)));
        }
    }

    private static void recoverListingElement(ListingElement listing, ListingElement targetElement, ModuleParserHandler tmpHandler) {
        RecoverDataGroupUtil.recoverReferredReportItem(listing, targetElement, tmpHandler);
        List<DesignElement> listingGroups = listing.getGroups();
        List<DesignElement> targetGroups = targetElement.getGroups();
        int size = Math.min(listingGroups.size(), targetGroups.size());
        int i = 0;
        while (i < size) {
            RecoverDataGroupUtil.recoverReferredReportItem((GroupElement)listingGroups.get(i), (GroupElement)targetGroups.get(i), tmpHandler);
            ++i;
        }
        listing.setProperty("dataBindingRef", null);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static void recoverReferredReportItem(DesignElement source, DesignElement targetElement, ModuleParserHandler tmpHandler) {
        Iterator<String> propNames = null;
        if (targetElement instanceof ListingElement) {
            propNames = ReportItemPropSearchStrategy.getDataBindingProperties(targetElement).iterator();
        } else {
            if (!(targetElement instanceof GroupElement)) {
                assert (false);
                return;
            }
            propNames = GroupPropSearchStrategy.getDataBindingPropties().iterator();
        }
        while (propNames.hasNext()) {
            String propName = propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)targetElement.getDefn().getProperty(propName);
            source.setProperty(propName, targetElement.getStrategy().getPropertyExceptRomDefault(tmpHandler.module, targetElement, propDefn));
        }
    }
}

