/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.TextDataElement;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.ui.swt.ColorPalette;
import org.eclipse.birt.chart.ui.swt.IQueryExpressionManager;
import org.eclipse.birt.chart.ui.swt.interfaces.IExpressionButton;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDefinitionTextManager {
    private static DataDefinitionTextManager instance;
    private HashMap<Control, IQueryExpressionManager> textCollection = null;
    private final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();

    private DataDefinitionTextManager() {
        this.textCollection = new HashMap(10);
    }

    public static synchronized DataDefinitionTextManager getInstance() {
        if (instance == null) {
            instance = new DataDefinitionTextManager();
        }
        return instance;
    }

    public void addDataDefinitionText(Control text, IQueryExpressionManager queryManager) {
        this.textCollection.put(text, queryManager);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (e.widget instanceof Control) {
                    DataDefinitionTextManager.this.removeDataDefinitionText((Control)e.widget);
                }
            }
        });
    }

    public void removeDataDefinitionText(Control text) {
        this.textCollection.remove(text);
    }

    public void removeAll() {
        this.textCollection.clear();
    }

    private Collection<String> getAllUsedBindingNames() {
        HashSet<String> set = new HashSet<String>();
        for (IQueryExpressionManager iqem : this.textCollection.values()) {
            String name;
            IExpressionButton eb = iqem.getExpressionButton();
            if (eb == null || (name = this.exprCodec.getBindingName(eb.getExpression())) == null) continue;
            set.add(name);
        }
        return set;
    }

    public void refreshAll() {
        this.checkAll();
        HashSet<String> usedColorKeys = new HashSet<String>();
        ColorPalette colorPalette = ColorPalette.getInstance();
        for (Map.Entry<Control, IQueryExpressionManager> entry : this.textCollection.entrySet()) {
            Control text = entry.getKey();
            IQueryExpressionManager iqem = entry.getValue();
            String expr = iqem.getQuery().getDefinition();
            iqem.updateText(expr);
            if (iqem.getExpressionButton().isCube()) continue;
            String name = this.exprCodec.getBindingName(iqem.getExpressionButton().getExpression());
            if (name != null) {
                colorPalette.putColor(name);
                usedColorKeys.add(name);
                text.setBackground(colorPalette.getColor(name));
                continue;
            }
            text.setBackground(null);
        }
        ColorPalette.getInstance().updateKeys(this.getAllUsedBindingNames());
    }

    private void checkAll() {
        ArrayList<Control> listToRemove = new ArrayList<Control>(this.textCollection.size());
        for (Control text : this.textCollection.keySet()) {
            if (!text.isDisposed()) continue;
            listToRemove.add(text);
        }
        int i = 0;
        while (i < listToRemove.size()) {
            this.textCollection.remove(listToRemove.get(i));
            ++i;
        }
    }

    public int getNumberOfSameDataDefinition(String expression) {
        this.checkAll();
        int number = 0;
        for (Control text : this.textCollection.keySet()) {
            if (!ChartUIUtil.getText(text).equals(expression)) continue;
            ++number;
        }
        return number;
    }

    public Control findText(Query query) {
        for (Map.Entry<Control, IQueryExpressionManager> entry : this.textCollection.entrySet()) {
            if (entry.getValue().getQuery() != query) continue;
            return entry.getKey();
        }
        return null;
    }

    public void updateQuery(Query query, String expression) {
        Control control = this.findText(query);
        if (control != null) {
            IQueryExpressionManager queryManager = this.textCollection.get(control);
            queryManager.updateQuery(expression);
        }
    }

    public void updateQuery(Control control) {
        if (this.textCollection.containsKey(control)) {
            IQueryExpressionManager queryManager = this.textCollection.get(control);
            queryManager.updateQuery(ChartUIUtil.getText(control));
            this.adjustScaleData(queryManager.getQuery());
            if (control.isDisposed()) {
                control = this.findText(queryManager.getQuery());
            }
            if (control != null) {
                this.updateControlBackground(control, queryManager.getQuery().getDefinition());
            }
        }
    }

    private void updateControlBackground(Control control, String expression) {
        String bindingName = this.exprCodec.getBindingName(expression);
        ColorPalette.getInstance().putColor(bindingName);
        control.setBackground(ColorPalette.getInstance().getColor(bindingName));
    }

    private void adjustScaleData(Query query) {
        Query object = query;
        while (!(object instanceof Axis)) {
            if (object != null) {
                object = object.eContainer();
                continue;
            }
            return;
        }
        Axis axis = (Axis)object;
        AxisType axisType = axis.getType();
        DataElement minElement = axis.getScale().getMin();
        DataElement maxElement = axis.getScale().getMax();
        if (axisType == AxisType.DATE_TIME_LITERAL) {
            if (!(minElement instanceof DateTimeDataElement)) {
                axis.getScale().setMin(null);
            }
            if (!(maxElement instanceof DateTimeDataElement)) {
                axis.getScale().setMax(null);
            }
        } else if (axisType == AxisType.TEXT_LITERAL) {
            if (!(minElement instanceof TextDataElement)) {
                axis.getScale().setMin(null);
            }
            if (!(maxElement instanceof TextDataElement)) {
                axis.getScale().setMax(null);
            }
        } else if (axisType == AxisType.LINEAR_LITERAL || axisType == AxisType.LOGARITHMIC_LITERAL) {
            if (!(minElement instanceof NumberDataElement)) {
                axis.getScale().setMin(null);
            }
            if (!(maxElement instanceof NumberDataElement)) {
                axis.getScale().setMax(null);
            }
        }
    }

    public boolean isValidExpression(Control control, String expression) {
        if (this.textCollection.containsKey(control)) {
            IQueryExpressionManager queryManager = this.textCollection.get(control);
            return queryManager.isValidExpression(expression);
        }
        return false;
    }

    public boolean isAcceptableExpression(Query query, String expr, boolean isShareBinding) {
        if (!isShareBinding) {
            return true;
        }
        Control control = this.findText(query);
        if (control != null) {
            return this.isValidExpression(control, expr);
        }
        return false;
    }

    public void updateTooltip() {
        for (IQueryExpressionManager queryExprM : this.textCollection.values()) {
            queryExprM.setTooltipForInputControl();
        }
    }

    public IExpressionButton findExpressionButton(Query query) {
        for (Map.Entry<Control, IQueryExpressionManager> entry : this.textCollection.entrySet()) {
            if (entry.getValue().getQuery() != query) continue;
            return entry.getValue().getExpressionButton();
        }
        return null;
    }
}

