/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExprEditComposite
extends Composite
implements Listener {
    public static final int TEXT_MODIFIED = 49;
    private IChartWizardContext fContext;
    private Text text;
    private Button btnExprDlg;
    private final String sTitle;
    private EObject eObj;
    private EAttribute eAttr;

    public ExprEditComposite(Composite parent, String sTitle, IChartWizardContext fContext) {
        super(parent, 0);
        this.sTitle = sTitle;
        this.fContext = fContext;
        this.placeComponents();
        this.initListeners();
    }

    public void bindModel(EObject eObj, EAttribute eAttr) {
        this.eObj = eObj;
        this.eAttr = eAttr;
        this.load();
    }

    private void load() {
        if (this.eObj != null && this.eAttr != null) {
            this.text.setText((String)this.eObj.eGet((EStructuralFeature)this.eAttr));
        }
    }

    private void save() {
        if (this.eObj != null && this.eAttr != null) {
            this.eObj.eSet((EStructuralFeature)this.eAttr, (Object)this.text.getText());
        }
    }

    private void placeComponents() {
        GridData gd = new GridData(1808);
        this.setLayoutData(gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.setLayout((Layout)gl);
        this.text = new Text((Composite)this, 2048);
        gd = new GridData(1808);
        this.text.setLayoutData((Object)gd);
        this.btnExprDlg = new Button((Composite)this, 8);
        gd = new GridData();
        ChartUIUtil.setChartImageButtonSizeByPlatform(gd);
        this.btnExprDlg.setLayoutData((Object)gd);
        this.btnExprDlg.setImage(UIHelper.getImage("icons/obj16/expressionbuilder.gif"));
        this.btnExprDlg.setToolTipText(Messages.getString("ExprEditComposite.InvokeExpressionBuilder"));
        this.btnExprDlg.setEnabled(this.fContext.getUIServiceProvider().isInvokingSupported());
        this.btnExprDlg.setVisible(this.fContext.getUIServiceProvider().isEclipseModeSupported());
    }

    private void initListeners() {
        this.text.addListener(24, (Listener)this);
        this.text.addListener(16, (Listener)this);
        this.text.addListener(2, (Listener)this);
        this.btnExprDlg.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.text) {
            if (event.type == 24) {
                this.save();
            } else if (event.type == 16) {
                this.fireEvent();
            } else if (event.type == 2 && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                this.fireEvent();
            }
        } else if (event.widget == this.btnExprDlg) {
            try {
                String sExpr = this.fContext.getUIServiceProvider().invoke(1, this.text.getText(), this.fContext.getExtendedItem(), this.sTitle);
                this.text.setText(sExpr);
                this.fireEvent();
            }
            catch (ChartException e) {
                WizardBase.displayException((Throwable)e);
            }
        }
    }

    private void fireEvent() {
        Event eventNew = new Event();
        eventNew.widget = this;
        eventNew.type = 49;
        this.notifyListeners(49, eventNew);
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String sText) {
        this.text.setText(sText);
    }
}

