/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class ControlListItem
extends Composite {
    static String DARK_COLOR_KEY = "org.eclipse.mylyn.commons.ui.ControlListItem.DARK_COLOR";
    IndexListener indexListener;
    private int currentIndex;
    private boolean selected;
    private final MouseAdapter mouseListener;
    private boolean isShowing = true;
    private final MouseTrackAdapter mouseTrackListener;
    private boolean hot;

    static {
        int shift = "carbon".equals(SWT.getPlatform()) ? -25 : -10;
        Color lightColor = PlatformUI.getWorkbench().getDisplay().getSystemColor(25);
        RGB darkRGB = new RGB(Math.max(0, lightColor.getRed() + shift), Math.max(0, lightColor.getGreen() + shift), Math.max(0, lightColor.getBlue() + shift));
        JFaceResources.getColorRegistry().put(DARK_COLOR_KEY, darkRGB);
    }

    public ControlListItem(Composite parent, int style, Object element) {
        super(parent, style | 0x80000);
        Control[] children;
        this.setData(element);
        this.setLayoutData(new GridData(4, 0, true, false));
        this.mouseListener = this.doCreateMouseListener();
        this.mouseTrackListener = this.doCreateMouseTrackListener();
        this.createContent();
        this.registerChild((Control)this);
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.registerChild(child);
            ++n2;
        }
        this.setHot(false);
        this.refresh();
    }

    private MouseTrackAdapter doCreateMouseTrackListener() {
        return new MouseTrackAdapter(){
            private int enterCount;

            public void mouseEnter(MouseEvent e) {
                ++this.enterCount;
                this.updateHotState();
            }

            public void mouseExit(MouseEvent e) {
                --this.enterCount;
                ControlListItem.this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!ControlListItem.this.isDisposed()) {
                            this.updateHotState();
                        }
                    }
                });
            }

            private void updateHotState() {
                if (this.enterCount == 0) {
                    if (ControlListItem.this.isHot()) {
                        ControlListItem.this.setHot(false);
                    }
                } else if (!ControlListItem.this.isHot()) {
                    ControlListItem.this.setHot(true);
                }
            }
        };
    }

    private MouseAdapter doCreateMouseListener() {
        return new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ControlListItem.this.indexListener != null) {
                    if (e.count == 2) {
                        ControlListItem.this.indexListener.open();
                    } else {
                        ControlListItem.this.indexListener.select();
                    }
                }
            }
        };
    }

    protected abstract void createContent();

    public boolean isHot() {
        return this.hot;
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    protected void registerChild(Control child) {
        child.addMouseListener((MouseListener)this.mouseListener);
        child.addMouseTrackListener((MouseTrackListener)this.mouseTrackListener);
    }

    protected abstract void refresh();

    public void updateColors(int index) {
        this.currentIndex = index;
        if (this.selected) {
            this.setBackground(this.getDisplay().getSystemColor(26));
            this.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            if (index % 2 == 0) {
                this.setBackground(JFaceResources.getColorRegistry().get(DARK_COLOR_KEY));
            } else {
                this.setBackground(this.getDisplay().getSystemColor(25));
            }
            this.setForeground(this.getDisplay().getSystemColor(24));
        }
    }

    public void setForeground(Color color) {
        Control[] children;
        super.setForeground(color);
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setForeground(color);
            ++n2;
        }
    }

    public void setBackground(Color color) {
        Control[] children;
        super.setBackground(color);
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setBackground(color);
            ++n2;
        }
    }

    public void setSelected(boolean select) {
        this.selected = select;
        this.updateColors(this.currentIndex);
    }

    void setIndexListener(IndexListener indexListener) {
        this.indexListener = indexListener;
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setDisplayed(int top, int bottom) {
        int itemTop = this.getLocation().y;
        int itemBottom = itemTop + this.getBounds().height;
        this.setDisplayed(itemTop <= bottom && itemBottom > top);
    }

    private void setDisplayed(boolean displayed) {
        boolean refresh = !this.isShowing && displayed;
        this.isShowing = displayed;
        if (refresh) {
            this.refresh();
        }
    }

    static interface IndexListener {
        public void selectPrevious();

        public void selectNext();

        public void select();

        public void open();
    }
}

