/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;

public class ASTNodeFactory {
    private static final String STATEMENT_HEADER = "class __X__ { void __x__() { ";
    private static final String STATEMENT_FOOTER = "}}";
    private static final String TYPE_HEADER = "class __X__ { abstract ";
    private static final String TYPE_FOOTER = " __f__(); }}";
    private static final String TYPEPARAM_HEADER = "class __X__ { abstract <";
    private static final String TYPEPARAM_FOOTER = "> void __f__(); }}";

    private ASTNodeFactory() {
    }

    public static ASTNode newStatement(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(STATEMENT_HEADER);
        buffer.append(content);
        buffer.append(STATEMENT_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)NodeFinder.perform((ASTNode)root, STATEMENT_HEADER.length(), content.length()));
        result.accept((ASTVisitor)new PositionClearer());
        return result;
    }

    public static Name newName(AST ast, String qualifiedName) {
        return ast.newName(qualifiedName);
    }

    public static TypeParameter newTypeParameter(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(TYPEPARAM_HEADER);
        buffer.append(content);
        buffer.append(TYPEPARAM_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        List list = root.types();
        TypeDeclaration typeDecl = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDecl = typeDecl.getMethods()[0];
        TypeParameter tp = (TypeParameter)methodDecl.typeParameters().get(0);
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)tp);
        result.accept((ASTVisitor)new PositionClearer());
        return (TypeParameter)result;
    }

    public static Type newType(AST ast, String content) {
        StringBuffer buffer = new StringBuffer(TYPE_HEADER);
        buffer.append(content);
        buffer.append(TYPE_FOOTER);
        ASTParser p = ASTParser.newParser((int)ast.apiLevel());
        p.setSource(buffer.toString().toCharArray());
        CompilationUnit root = (CompilationUnit)p.createAST(null);
        List list = root.types();
        TypeDeclaration typeDecl = (TypeDeclaration)list.get(0);
        MethodDeclaration methodDecl = typeDecl.getMethods()[0];
        Type type = methodDecl.getReturnType2();
        ASTNode result = ASTNode.copySubtree((AST)ast, (ASTNode)type);
        result.accept((ASTVisitor)new PositionClearer());
        return (Type)result;
    }

    public static Type newType(AST ast, VariableDeclaration declaration) {
        Type type = ASTNodes.getType(declaration);
        int extraDim = declaration.getExtraDimensions();
        type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
        int i = 0;
        while (i < extraDim) {
            type = ast.newArrayType(type);
            ++i;
        }
        return type;
    }

    public static Expression newDefaultExpression(AST ast, Type type, int extraDimensions) {
        if (extraDimensions == 0 && type.isPrimitiveType()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.BOOLEAN) {
                return ast.newBooleanLiteral(false);
            }
            if (primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    public static Expression newDefaultExpression(AST ast, ITypeBinding type) {
        if (type.isPrimitive()) {
            String name = type.getName();
            if ("boolean".equals(name)) {
                return ast.newBooleanLiteral(false);
            }
            if ("void".equals(name)) {
                return null;
            }
            return ast.newNumberLiteral("0");
        }
        return ast.newNullLiteral();
    }

    public static List newModifiers(AST ast, int modifiers) {
        return ast.newModifiers(modifiers);
    }

    public static List newModifiers(AST ast, List modifierNodes) {
        ArrayList<Modifier> res = new ArrayList<Modifier>(modifierNodes.size());
        int i = 0;
        while (i < modifierNodes.size()) {
            Object curr = modifierNodes.get(i);
            if (curr instanceof Modifier) {
                res.add(ast.newModifier(((Modifier)curr).getKeyword()));
            }
            ++i;
        }
        return res;
    }

    public static Expression newInfixExpression(AST ast, InfixExpression.Operator operator, ArrayList operands) {
        if (operands.size() == 1) {
            return (Expression)operands.get(0);
        }
        InfixExpression result = ast.newInfixExpression();
        result.setOperator(operator);
        result.setLeftOperand((Expression)operands.get(0));
        result.setRightOperand((Expression)operands.get(1));
        result.extendedOperands().addAll(operands.subList(2, operands.size()));
        return result;
    }

    private static class PositionClearer
    extends GenericVisitor {
        public PositionClearer() {
            super(true);
        }

        protected boolean visitNode(ASTNode node) {
            node.setSourceRange(-1, 0);
            return true;
        }
    }
}

