/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.ImportOrganizeInputDialog;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ImportOrganizeConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_IMPORTORDER = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.importorder");
    private static final OptionsConfigurationBlock.Key PREF_ONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.ondemandthreshold");
    private static final OptionsConfigurationBlock.Key PREF_IGNORELOWERCASE = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.ignorelowercasenames");
    private static final OptionsConfigurationBlock.Key PREF_STATICONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.jdt.ui.staticondemandthreshold");
    private static final String DIALOGSETTING_LASTLOADPATH = "org.eclipse.jdt.ui.importorder.loadpath";
    private static final String DIALOGSETTING_LASTSAVEPATH = "org.eclipse.jdt.ui.importorder.savepath";
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_STATIC = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_UP = 5;
    private static final int IDX_DOWN = 6;
    private ListDialogField fOrderListField;
    private StringDialogField fThresholdField;
    private StringDialogField fStaticThresholdField;
    private SelectionButtonDialogField fIgnoreLowerCaseTypesField;
    private SelectionButtonDialogField fExportButton;
    private SelectionButtonDialogField fImportButton;
    private PixelConverter fPixelConverter;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_IMPORTORDER, PREF_ONDEMANDTHRESHOLD, PREF_STATICONDEMANDTHRESHOLD, PREF_IGNORELOWERCASE};
    }

    public ImportOrganizeConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, ImportOrganizeConfigurationBlock.getAllKeys(), container);
        String[] stringArray = new String[7];
        stringArray[0] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_add_button;
        stringArray[1] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_add_static_button;
        stringArray[2] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_edit_button;
        stringArray[3] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_remove_button;
        stringArray[5] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_up_button;
        stringArray[6] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_down_button;
        String[] buttonLabels = stringArray;
        ImportOrganizeAdapter adapter = new ImportOrganizeAdapter();
        this.fOrderListField = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ImportOrganizeLabelProvider());
        this.fOrderListField.setDialogFieldListener(adapter);
        this.fOrderListField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_label);
        this.fOrderListField.setUpButtonIndex(5);
        this.fOrderListField.setDownButtonIndex(6);
        this.fOrderListField.setRemoveButtonIndex(3);
        this.fOrderListField.enableButton(2, false);
        this.fImportButton = new SelectionButtonDialogField(8);
        this.fImportButton.setDialogFieldListener(adapter);
        this.fImportButton.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_load_button);
        this.fExportButton = new SelectionButtonDialogField(8);
        this.fExportButton.setDialogFieldListener(adapter);
        this.fExportButton.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_save_button);
        this.fThresholdField = new StringDialogField();
        this.fThresholdField.setDialogFieldListener(adapter);
        this.fThresholdField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_threshold_label);
        this.fStaticThresholdField = new StringDialogField();
        this.fStaticThresholdField.setDialogFieldListener(adapter);
        this.fStaticThresholdField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_staticthreshold_label);
        this.fIgnoreLowerCaseTypesField = new SelectionButtonDialogField(32);
        this.fIgnoreLowerCaseTypesField.setDialogFieldListener(adapter);
        this.fIgnoreLowerCaseTypesField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_ignoreLowerCase_label);
        this.updateControls();
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        this.fPixelConverter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fOrderListField.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fOrderListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fOrderListField.getLabelControl(null), this.fPixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fOrderListField.getListControl(null));
        Composite importExportComp = new Composite(composite, 0);
        importExportComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        importExportComp.setLayout((Layout)layout);
        this.fImportButton.doFillIntoGrid(importExportComp, 1);
        this.fExportButton.doFillIntoGrid(importExportComp, 1);
        this.fThresholdField.doFillIntoGrid(composite, 2);
        ((GridData)this.fThresholdField.getTextControl(null).getLayoutData()).grabExcessHorizontalSpace = false;
        this.fStaticThresholdField.doFillIntoGrid(composite, 2);
        this.fIgnoreLowerCaseTypesField.doFillIntoGrid(composite, 2);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private boolean doThresholdChanged(String thresholdString) {
        StatusInfo status = new StatusInfo();
        try {
            int threshold = Integer.parseInt(thresholdString);
            if (threshold < 0) {
                status.setError(PreferencesMessages.ImportOrganizeConfigurationBlock_error_invalidthreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            status.setError(PreferencesMessages.ImportOrganizeConfigurationBlock_error_invalidthreshold);
        }
        this.updateStatus(status);
        return status.isOK();
    }

    private void doButtonPressed(int index) {
        if (index == 0 || index == 1) {
            List existing = this.fOrderListField.getElements();
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing, index == 1);
            if (dialog.open() == 0) {
                List selectedElements = this.fOrderListField.getSelectedElements();
                if (selectedElements.size() == 1) {
                    int insertionIndex = this.fOrderListField.getIndexOfElement(selectedElements.get(0)) + 1;
                    this.fOrderListField.addElement(dialog.getResult(), insertionIndex);
                } else {
                    this.fOrderListField.addElement(dialog.getResult());
                }
            }
        } else if (index == 2) {
            List selected = this.fOrderListField.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            ImportOrderEntry editedEntry = (ImportOrderEntry)selected.get(0);
            List existing = this.fOrderListField.getElements();
            existing.remove(editedEntry);
            ImportOrganizeInputDialog dialog = new ImportOrganizeInputDialog(this.getShell(), existing, editedEntry.isStatic);
            dialog.setInitialSelection(editedEntry);
            if (dialog.open() == 0) {
                this.fOrderListField.replaceElement(editedEntry, dialog.getResult());
            }
        }
    }

    private List loadFromProperties(Properties properties) {
        ArrayList<ImportOrderEntry> res = new ArrayList<ImportOrderEntry>();
        int nEntries = properties.size();
        int i = 0;
        while (i < nEntries) {
            ImportOrderEntry entry;
            String curr = properties.getProperty(String.valueOf(i));
            if (curr != null) {
                entry = ImportOrderEntry.fromSerialized(curr);
                if (entry.name.length() != 0 && JavaConventions.validatePackageName((String)entry.name, (String)"1.3", (String)"1.5").matches(4)) {
                    return null;
                }
            } else {
                return res;
            }
            res.add(entry);
            ++i;
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private List loadImportOrder() {
        dialogSettings = JavaPlugin.getDefault().getDialogSettings();
        dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(PreferencesMessages.ImportOrganizeConfigurationBlock_loadDialog_title);
        dialog.setFilterExtensions(new String[]{"*.importorder", "*.*"});
        lastPath = dialogSettings.get("org.eclipse.jdt.ui.importorder.loadpath");
        if (lastPath != null) {
            dialog.setFilterPath(lastPath);
        }
        if ((fileName = dialog.open()) != null) {
            block19: {
                block17: {
                    block18: {
                        dialogSettings.put("org.eclipse.jdt.ui.importorder.loadpath", dialog.getFilterPath());
                        properties = new Properties();
                        fis = null;
                        fis = new FileInputStream(fileName);
                        properties.load(fis);
                        res = this.loadFromProperties(properties);
                        if (res == null) break block17;
                        var9_9 = res;
                        if (fis == null) break block18;
                        try {
                            fis.close();
                        }
                        catch (IOException v0) {}
                    }
                    return var9_9;
                    catch (IOException e) {
                        try {
                            JavaPlugin.log(e);
                            ** if (fis == null) goto lbl-1000
                        }
                        catch (Throwable var8_10) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException v2) {}
                            }
                            throw var8_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                fis.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block19;
                        }
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException v3) {}
                }
            }
            title = PreferencesMessages.ImportOrganizeConfigurationBlock_loadDialog_error_title;
            message = PreferencesMessages.ImportOrganizeConfigurationBlock_loadDialog_error_message;
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        }
        return null;
    }

    private void saveImportOrder(List elements) {
        block17: {
            String fileName;
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setText(PreferencesMessages.ImportOrganizeConfigurationBlock_saveDialog_title);
            dialog.setFilterExtensions(new String[]{"*.importorder", "*.*"});
            dialog.setFileName("example.importorder");
            String lastPath = dialogSettings.get(DIALOGSETTING_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((fileName = dialog.open()) != null) {
                dialogSettings.put(DIALOGSETTING_LASTSAVEPATH, dialog.getFilterPath());
                Properties properties = new Properties();
                int i = 0;
                while (i < elements.size()) {
                    ImportOrderEntry entry = (ImportOrderEntry)elements.get(i);
                    properties.setProperty(String.valueOf(i), entry.serialize());
                    ++i;
                }
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(fileName);
                        properties.store(fos, "Organize Import Order");
                    }
                    catch (IOException e) {
                        JavaPlugin.log(e);
                        String title = PreferencesMessages.ImportOrganizeConfigurationBlock_saveDialog_error_title;
                        String message = PreferencesMessages.ImportOrganizeConfigurationBlock_saveDialog_error_message;
                        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void updateStatus(IStatus status) {
        this.fContext.statusChanged(status);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
    }

    protected void updateControls() {
        ImportOrderEntry[] importOrder = this.getImportOrderPreference();
        int threshold = this.getImportNumberThreshold(PREF_ONDEMANDTHRESHOLD);
        int staticThreshold = this.getImportNumberThreshold(PREF_STATICONDEMANDTHRESHOLD);
        boolean ignoreLowerCase = Boolean.valueOf(this.getValue(PREF_IGNORELOWERCASE));
        this.fOrderListField.removeAllElements();
        int i = 0;
        while (i < importOrder.length) {
            this.fOrderListField.addElement(importOrder[i]);
            ++i;
        }
        this.fThresholdField.setText(String.valueOf(threshold));
        this.fStaticThresholdField.setText(String.valueOf(staticThreshold));
        this.fIgnoreLowerCaseTypesField.setSelection(ignoreLowerCase);
    }

    protected final void doDialogFieldChanged(DialogField field) {
        if (field == this.fOrderListField) {
            this.setValue(PREF_IMPORTORDER, ImportOrganizeConfigurationBlock.packOrderList(this.fOrderListField.getElements()));
        } else if (field == this.fThresholdField) {
            if (this.doThresholdChanged(this.fThresholdField.getText())) {
                this.setValue(PREF_ONDEMANDTHRESHOLD, this.fThresholdField.getText());
            }
        } else if (field == this.fStaticThresholdField) {
            if (this.doThresholdChanged(this.fStaticThresholdField.getText())) {
                this.setValue(PREF_STATICONDEMANDTHRESHOLD, this.fStaticThresholdField.getText());
            }
        } else if (field == this.fIgnoreLowerCaseTypesField) {
            this.setValue(PREF_IGNORELOWERCASE, this.fIgnoreLowerCaseTypesField.isSelected());
        } else if (field == this.fImportButton) {
            List order = this.loadImportOrder();
            if (order != null) {
                this.fOrderListField.setElements(order);
            }
        } else if (field == this.fExportButton) {
            this.saveImportOrder(this.fOrderListField.getElements());
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    private static ImportOrderEntry[] unpackOrderList(String str) {
        int end;
        ArrayList<ImportOrderEntry> res = new ArrayList<ImportOrderEntry>();
        int start = 0;
        do {
            if ((end = str.indexOf(59, start)) == -1) {
                end = str.length();
            }
            res.add(ImportOrderEntry.fromSerialized(str.substring(start, end)));
        } while ((start = end + 1) < str.length());
        return res.toArray(new ImportOrderEntry[res.size()]);
    }

    private static String packOrderList(List orderList) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < orderList.size()) {
            ImportOrderEntry entry = (ImportOrderEntry)orderList.get(i);
            buf.append(entry.serialize());
            buf.append(';');
            ++i;
        }
        return buf.toString();
    }

    private ImportOrderEntry[] getImportOrderPreference() {
        String str = this.getValue(PREF_IMPORTORDER);
        if (str != null) {
            return ImportOrganizeConfigurationBlock.unpackOrderList(str);
        }
        return new ImportOrderEntry[0];
    }

    private int getImportNumberThreshold(OptionsConfigurationBlock.Key key) {
        String thresholdStr = this.getValue(key);
        try {
            int threshold = Integer.parseInt(thresholdStr);
            if (threshold < 0) {
                threshold = Integer.MAX_VALUE;
            }
            return threshold;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static class ImportOrderEntry {
        public final String name;
        public final boolean isStatic;

        public ImportOrderEntry(String name, boolean isStatic) {
            this.name = name;
            this.isStatic = isStatic;
        }

        public String serialize() {
            return this.isStatic ? String.valueOf('#') + this.name : this.name;
        }

        public static ImportOrderEntry fromSerialized(String str) {
            if (str.length() > 0 && str.charAt(0) == '#') {
                return new ImportOrderEntry(str.substring(1), true);
            }
            return new ImportOrderEntry(str, false);
        }
    }

    private class ImportOrganizeAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ImportOrganizeAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            List selected = field.getSelectedElements();
            return selected.size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            ImportOrganizeConfigurationBlock.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            ImportOrganizeConfigurationBlock.this.fOrderListField.enableButton(2, this.canEdit(field));
        }

        public void dialogFieldChanged(DialogField field) {
            ImportOrganizeConfigurationBlock.this.doDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                ImportOrganizeConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }

    private static class ImportOrganizeLabelProvider
    extends LabelProvider {
        private final Image PCK_ICON = JavaPluginImages.get("org.eclipse.jdt.ui.package_obj.gif");
        private final Image STATIC_CLASS_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 8, JavaElementImageProvider.SMALL_SIZE);

        public Image getImage(Object element) {
            return ((ImportOrderEntry)element).isStatic ? this.STATIC_CLASS_ICON : this.PCK_ICON;
        }

        public String getText(Object element) {
            ImportOrderEntry entry = (ImportOrderEntry)element;
            String name = entry.name;
            if (name.length() > 0) {
                return BasicElementLabels.getJavaElementName(name);
            }
            if (entry.isStatic) {
                return PreferencesMessages.ImportOrganizeConfigurationBlock_other_static;
            }
            return PreferencesMessages.ImportOrganizeConfigurationBlock_other_normal;
        }
    }
}

