/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.actions.OpenExternalBrowserAction;
import org.eclipse.jdt.internal.ui.actions.SimpleSelectionProvider;
import org.eclipse.jdt.internal.ui.infoviews.JavadocView;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public class JavadocHover
extends AbstractJavaEditorTextHover {
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TYPE_PARAMETER_FLAGS = LABEL_FLAGS | 0x400000L;
    private static String fgStyleSheet;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    private static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener(JavaElementLinks.createLocationListener(new JavaElementLinks.ILinkHandler(){

            public void handleJavadocViewLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.setVisible(false);
                control.dispose();
                try {
                    JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                    view.setInput(linkTarget);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
            }

            public void handleInlineJavadocLink(IJavaElement linkTarget) {
                JavadocBrowserInformationControlInput hoverInfo = JavadocHover.getHoverInfo(new IJavaElement[]{linkTarget}, null, (JavadocBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            public void handleDeclarationLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                try {
                    JavaUI.openInEditor(linkTarget);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }

            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.open(url, display, "");
                return true;
            }

            public void handleTextSet() {
            }
        }));
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        JavadocBrowserInformationControlInput info = (JavadocBrowserInformationControlInput)((Object)this.getHoverInfo2(textViewer, hoverRegion));
        return info != null ? info.getHtml() : null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.internalGetHoverInfo(textViewer, hoverRegion);
    }

    private JavadocBrowserInformationControlInput internalGetHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String constantValue;
        IJavaElement[] elements = this.getJavaElementsAt(textViewer, hoverRegion);
        if (elements == null || elements.length == 0) {
            return null;
        }
        if (elements.length == 1 && elements[0].getElementType() == 8) {
            constantValue = this.getConstantValue((IField)elements[0], hoverRegion);
            if (constantValue != null) {
                constantValue = HTMLPrinter.convertToHTMLContent((String)constantValue);
            }
        } else {
            constantValue = null;
        }
        return JavadocHover.getHoverInfo(elements, constantValue, null);
    }

    private static JavadocBrowserInformationControlInput getHoverInfo(IJavaElement[] elements, String constantValue, JavadocBrowserInformationControlInput previousInput) {
        int nResults = elements.length;
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        String base = null;
        IJavaElement element = null;
        int leadingImageWidth = 0;
        if (nResults > 1) {
            int i = 0;
            while (i < elements.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = elements[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)JavadocHover.getInfoText(curr, constantValue, false));
                    hasContents = true;
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            element = elements[0];
            if (element instanceof IMember) {
                StringReader reader;
                IMember member = (IMember)element;
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)JavadocHover.getInfoText((IJavaElement)member, constantValue, true));
                try {
                    String content = JavadocContentAccess2.getHTMLContent(member, true);
                    StringReader stringReader = reader = content == null ? null : new StringReader(content);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachments);
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedJavadoc);
                        } else if (!hasAttachedSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noAttachedSource);
                        } else if (!hasSource) {
                            reader = new StringReader(JavaHoverMessages.JavadocHover_noInformation);
                        }
                    } else {
                        base = JavaDocLocations.getBaseURL(member);
                    }
                }
                catch (JavaModelException ex) {
                    reader = new StringReader(JavaHoverMessages.JavadocHover_error_gettingJavadoc);
                    JavaPlugin.log(ex);
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
                hasContents = true;
            } else if (element.getElementType() == 14 || element.getElementType() == 15) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)JavadocHover.getInfoText(element, constantValue, true));
                hasContents = true;
            }
            leadingImageWidth = 20;
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)JavadocHover.getStyleSheet());
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new JavadocBrowserInformationControlInput(previousInput, element, buffer.toString(), leadingImageWidth);
        }
        return null;
    }

    private static String getInfoText(IJavaElement element, String constantValue, boolean allowImage) {
        URL imageUrl;
        long flags;
        switch (element.getElementType()) {
            case 14: {
                flags = LOCAL_VARIABLE_FLAGS;
                break;
            }
            case 15: {
                flags = TYPE_PARAMETER_FLAGS;
                break;
            }
            default: {
                flags = LABEL_FLAGS;
            }
        }
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel(element, flags));
        if (element.getElementType() == 8 && constantValue != null) {
            IJavaProject javaProject = element.getJavaProject();
            if ("insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", true))) {
                label.append(' ');
            }
            label.append('=');
            if ("insert".equals(javaProject.getOption("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", true))) {
                label.append(' ');
            }
            label.append(constantValue);
        }
        String imageName = null;
        if (allowImage && (imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(element)) != null) {
            imageName = imageUrl.toExternalForm();
        }
        StringBuffer buf = new StringBuffer();
        JavadocHover.addImageAndLabel(buf, imageName, 16, 16, 2, 2, label.toString(), 20, 2);
        return buf.toString();
    }

    private static boolean isStaticFinal(IField field) {
        try {
            return JdtFlags.isFinal((IMember)field) && JdtFlags.isStatic((IMember)field);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private String getConstantValue(IField field, IRegion hoverRegion) {
        IVariableBinding variableBinding;
        IBinding binding;
        if (!JavadocHover.isStaticFinal(field)) {
            return null;
        }
        ITypeRoot typeRoot = this.getEditorInputJavaElement();
        if (typeRoot == null) {
            return null;
        }
        Object constantValue = null;
        CompilationUnit unit = SharedASTProvider.getAST(typeRoot, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        if (unit == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)unit, hoverRegion.getOffset(), hoverRegion.getLength());
        if (node != null && node.getNodeType() == 42 && (binding = ((SimpleName)node).resolveBinding()) != null && binding.getKind() == 3 && field.equals((variableBinding = (IVariableBinding)binding).getJavaElement())) {
            constantValue = variableBinding.getConstantValue();
        }
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            StringBuffer result = new StringBuffer();
            result.append('\"');
            String stringConstant = (String)constantValue;
            if (stringConstant.length() > 80) {
                result.append(stringConstant.substring(0, 80));
                result.append("...");
            } else {
                result.append(stringConstant);
            }
            result.append('\"');
            return result.toString();
        }
        if (constantValue instanceof Character) {
            String constantResult = String.valueOf('\'') + constantValue.toString() + '\'';
            char charValue = ((Character)constantValue).charValue();
            String hexString = Integer.toHexString(charValue);
            StringBuffer hexResult = new StringBuffer("\\u");
            int i = hexString.length();
            while (i < 4) {
                hexResult.append('0');
                ++i;
            }
            hexResult.append(hexString);
            return JavadocHover.formatWithHexValue(constantResult, hexResult.toString());
        }
        if (constantValue instanceof Byte) {
            int byteValue = ((Byte)constantValue).intValue() & 0xFF;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(byteValue));
        }
        if (constantValue instanceof Short) {
            int shortValue = (Short)constantValue & 0xFFFF;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(shortValue));
        }
        if (constantValue instanceof Integer) {
            int intValue = (Integer)constantValue;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(intValue));
        }
        if (constantValue instanceof Long) {
            long longValue = (Long)constantValue;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Long.toHexString(longValue));
        }
        return constantValue.toString();
    }

    private static String formatWithHexValue(Object constantValue, String hexValue) {
        return Messages.format(JavaHoverMessages.JavadocHover_constantValue_hexValue, new String[]{constantValue.toString(), hexValue});
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = JavadocHover.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocHoverStyleSheet.css");
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException ex) {
                try {
                    JavaPlugin.log(ex);
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                return "";
            }
        }
        return null;
    }

    public static void addImageAndLabel(StringBuffer buf, String imageName, int imageWidth, int imageHeight, int imageLeft, int imageTop, String label, int labelLeft, int labelTop) {
        if (imageName != null) {
            StringBuffer imageStyle = new StringBuffer("position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("top: ").append(imageTop).append("px; ");
            imageStyle.append("left: ").append(imageLeft).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            buf.append("<span style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageName).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img style='").append(imageStyle).append("' src='").append(imageName).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append("<div style='word-wrap:break-word;");
        if (imageName != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("margin-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        buf.append(label);
        buf.append("</div>");
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(Messages.format(JavaHoverMessages.JavadocHover_back_toElement_toolTip, BasicElementLabels.getJavaElementName(previous.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(JavaHoverMessages.JavadocHover_back);
                this.setEnabled(false);
            }
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(Messages.format(JavaHoverMessages.JavadocHover_forward_toElement_toolTip, BasicElementLabels.getJavaElementName(current.getNext().getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(JavaHoverMessages.JavadocHover_forward_toolTip);
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;
        private final boolean fAdditionalInfoAffordance;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this(informationPresenterControlCreator, false);
        }

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, boolean additionalInfoAffordance) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
            this.fAdditionalInfoAffordance = additionalInfoAffordance;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString;
            String string = tooltipAffordanceString = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                BrowserInformationControl iControl = new BrowserInformationControl(this, parent, font, tooltipAffordanceString){
                    final /* synthetic */ HoverControlCreator this$1;
                    {
                        this.this$1 = hoverControlCreator;
                    }

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.access$0(this.this$1);
                    }
                };
                JavadocHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }

        static /* synthetic */ IInformationControlCreator access$0(HoverControlCreator hoverControlCreator) {
            return hoverControlCreator.fInformationPresenterControlCreator;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_openDeclaration);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "goto_input.gif");
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavaUI.openInEditor(infoInput.getElement());
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.jdt.ui.javadocfont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tbm);
                BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                ShowInJavadocViewAction showInJavadocViewAction = new ShowInJavadocViewAction(iControl);
                tbm.add((IAction)showInJavadocViewAction);
                OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                SimpleSelectionProvider selectionProvider = new SimpleSelectionProvider();
                OpenExternalBrowserAction openExternalJavadocAction = new OpenExternalBrowserAction(parent.getDisplay(), selectionProvider);
                selectionProvider.addSelectionChangedListener(openExternalJavadocAction);
                selectionProvider.setSelection((ISelection)new StructuredSelection());
                tbm.add((IAction)openExternalJavadocAction);
                IInputChangedListener inputChangeListener = new IInputChangedListener(this, backAction, forwardAction, selectionProvider, showInJavadocViewAction, openDeclarationAction){
                    final /* synthetic */ PresenterControlCreator this$1;
                    private final /* synthetic */ BackAction val$backAction;
                    private final /* synthetic */ ForwardAction val$forwardAction;
                    private final /* synthetic */ SimpleSelectionProvider val$selectionProvider;
                    private final /* synthetic */ ShowInJavadocViewAction val$showInJavadocViewAction;
                    private final /* synthetic */ OpenDeclarationAction val$openDeclarationAction;
                    {
                        this.this$1 = presenterControlCreator;
                        this.val$backAction = backAction;
                        this.val$forwardAction = forwardAction;
                        this.val$selectionProvider = simpleSelectionProvider;
                        this.val$showInJavadocViewAction = showInJavadocViewAction;
                        this.val$openDeclarationAction = openDeclarationAction;
                    }

                    public void inputChanged(Object newInput) {
                        this.val$backAction.update();
                        this.val$forwardAction.update();
                        if (newInput == null) {
                            this.val$selectionProvider.setSelection((ISelection)new StructuredSelection());
                        } else if (newInput instanceof BrowserInformationControlInput) {
                            BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                            Object inputElement = input.getInputElement();
                            this.val$selectionProvider.setSelection((ISelection)new StructuredSelection(inputElement));
                            boolean isJavaElementInput = inputElement instanceof IJavaElement;
                            this.val$showInJavadocViewAction.setEnabled(isJavaElementInput);
                            this.val$openDeclarationAction.setEnabled(isJavaElementInput);
                        }
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                JavadocHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }

    private static final class ShowInJavadocViewAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ShowInJavadocViewAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_showInJavadoc);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAVADOCTAG);
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                view.setInput((BrowserInput)infoInput);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
        }
    }
}

