/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.jarpackager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.swt.widgets.Shell;

public class JarWriter3 {
    private Set fDirectories = new HashSet();
    private JarOutputStream fJarOutputStream;
    private JarPackageData fJarPackage;

    public JarWriter3(JarPackageData jarPackage, Shell parent) throws CoreException {
        Assert.isNotNull((Object)jarPackage, (String)"The JAR specification is null");
        this.fJarPackage = jarPackage;
        Assert.isTrue((boolean)this.fJarPackage.isValid(), (String)"The JAR package specification is invalid");
        if (!this.canCreateJar(parent)) {
            throw new OperationCanceledException();
        }
        try {
            if (this.fJarPackage.usesManifest() && this.fJarPackage.areGeneratedFilesExported()) {
                Manifest manifest = this.fJarPackage.getManifestProvider().create(this.fJarPackage);
                this.fJarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toFile())), manifest);
            } else {
                this.fJarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.fJarPackage.getAbsoluteJarLocation().toFile())));
            }
            String comment = jarPackage.getComment();
            if (comment != null) {
                this.fJarOutputStream.setComment(comment);
            }
            if (this.fJarPackage.isRefactoringAware()) {
                Assert.isTrue((boolean)this.fJarPackage.areDirectoryEntriesIncluded());
                Path metaPath = new Path(JarPackagerUtil.getMetaEntry());
                this.addDirectories((IPath)metaPath);
                this.addHistory(this.fJarPackage, (IPath)new Path(JarPackagerUtil.getRefactoringsEntry()), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException exception) {
            throw JarPackagerUtil.createCoreException(exception.getLocalizedMessage(), exception);
        }
    }

    protected void addDirectories(IPath destinationPath) throws IOException {
        this.addDirectories(destinationPath.toString());
    }

    protected void addDirectories(String destPath) throws IOException {
        String path = destPath.replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> directories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            if (!this.fDirectories.add(path = path.substring(0, lastSlash + 1))) break;
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(System.currentTimeMillis());
            directories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = directories.size() - 1;
        while (i >= 0) {
            this.fJarOutputStream.putNextEntry((JarEntry)directories.get(i));
            --i;
        }
    }

    protected void addDirectories(IResource resource, IPath destinationPath) throws IOException, CoreException {
        IContainer parent = null;
        String path = destinationPath.toString().replace(File.separatorChar, '/');
        int lastSlash = path.lastIndexOf(47);
        ArrayList<JarEntry> directories = new ArrayList<JarEntry>(2);
        while (lastSlash != -1) {
            IFileInfo info;
            if (!this.fDirectories.add(path = path.substring(0, lastSlash + 1))) break;
            parent = resource.getParent();
            long timeStamp = System.currentTimeMillis();
            URI location = parent.getLocationURI();
            if (location != null && (info = EFS.getStore((URI)location).fetchInfo()).exists()) {
                timeStamp = info.getLastModified();
            }
            JarEntry newEntry = new JarEntry(path);
            newEntry.setMethod(0);
            newEntry.setSize(0L);
            newEntry.setCrc(0L);
            newEntry.setTime(timeStamp);
            directories.add(newEntry);
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        int i = directories.size() - 1;
        while (i >= 0) {
            this.fJarOutputStream.putNextEntry((JarEntry)directories.get(i));
            --i;
        }
    }

    protected void addFile(IFile resource, IPath path) throws IOException, CoreException {
        IFileInfo info;
        JarEntry newEntry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        byte[] readBuffer = new byte[4096];
        if (this.fJarPackage.isCompressed()) {
            newEntry.setMethod(8);
        } else {
            newEntry.setMethod(0);
            JarPackagerUtil.calculateCrcAndSize(newEntry, resource.getContents(false), readBuffer);
        }
        long lastModified = System.currentTimeMillis();
        URI locationURI = resource.getLocationURI();
        if (locationURI != null && (info = EFS.getStore((URI)locationURI).fetchInfo()).exists()) {
            lastModified = info.getLastModified();
        }
        newEntry.setTime(lastModified);
        InputStream contentStream = resource.getContents(false);
        this.addEntry(newEntry, contentStream);
    }

    protected void addEntry(JarEntry entry, InputStream content) throws IOException {
        byte[] readBuffer = new byte[4096];
        try {
            int count;
            this.fJarOutputStream.putNextEntry(entry);
            while ((count = content.read(readBuffer, 0, readBuffer.length)) != -1) {
                this.fJarOutputStream.write(readBuffer, 0, count);
            }
        }
        finally {
            if (content != null) {
                content.close();
            }
        }
    }

    private void addHistory(JarPackageData data, IPath path, IProgressMonitor monitor) throws IOException, CoreException {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)monitor);
        RefactoringDescriptorProxy[] proxies = data.getRefactoringDescriptors();
        Arrays.sort(proxies, new Comparator(){

            public final int compare(Object first, Object second) {
                RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                long delta = predecessor.getTimeStamp() - successor.getTimeStamp();
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        File file = null;
        BufferedOutputStream output = null;
        try {
            file = File.createTempFile("history", null);
            output = new BufferedOutputStream(new FileOutputStream(file));
            try {
                RefactoringCore.getHistoryService().writeRefactoringDescriptors(proxies, (OutputStream)output, 0, false, monitor);
                try {
                    ((OutputStream)output).close();
                    output = null;
                }
                catch (IOException iOException) {}
                this.writeMetaData(data, file, path);
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    protected boolean canCreateJar(Shell parent) {
        File file = this.fJarPackage.getAbsoluteJarLocation().toFile();
        if (file.exists()) {
            if (!file.canWrite()) {
                return false;
            }
            if (this.fJarPackage.allowOverwrite()) {
                return true;
            }
            return parent != null && JarPackagerUtil.askForOverwritePermission(parent, this.fJarPackage.getAbsoluteJarLocation(), true);
        }
        String path = file.getAbsolutePath();
        int separatorIndex = path.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        File directory = new File(path.substring(0, separatorIndex));
        if (!directory.exists()) {
            if (JarPackagerUtil.askToCreateDirectory(parent, directory)) {
                return directory.mkdirs();
            }
            return false;
        }
        return true;
    }

    public void close() throws CoreException {
        if (this.fJarOutputStream != null) {
            try {
                this.fJarOutputStream.close();
                this.registerInWorkspaceIfNeeded();
            }
            catch (IOException ex) {
                throw JarPackagerUtil.createCoreException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    private void registerInWorkspaceIfNeeded() {
        IPath jarPath = this.fJarPackage.getAbsoluteJarLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(jarPath)) {
                try {
                    jarPath = jarPath.removeFirstSegments(projectLocation.segmentCount());
                    jarPath = jarPath.removeLastSegments(1);
                    IResource containingFolder = project.findMember(jarPath);
                    if (containingFolder != null && containingFolder.isAccessible()) {
                        containingFolder.refreshLocal(1, null);
                    }
                }
                catch (CoreException ex) {
                    JavaPlugin.log(ex);
                }
            }
            ++i;
        }
    }

    public void write(IFile resource, IPath destinationPath) throws CoreException {
        try {
            if (this.fJarPackage.areDirectoryEntriesIncluded()) {
                this.addDirectories((IResource)resource, destinationPath);
            }
            this.addFile(resource, destinationPath);
        }
        catch (IOException ex) {
            String message = null;
            message = ex.getLocalizedMessage() != null ? Messages.format(JarPackagerMessages.JarWriter_writeProblemWithMessage, new Object[]{BasicElementLabels.getPathLabel(resource.getFullPath(), false), ex.getLocalizedMessage()}) : Messages.format(JarPackagerMessages.JarWriter_writeProblem, BasicElementLabels.getPathLabel(resource.getFullPath(), false));
            throw JarPackagerUtil.createCoreException(message, ex);
        }
    }

    private void writeMetaData(JarPackageData data, File file, IPath path) throws FileNotFoundException, IOException {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)path);
        JarEntry entry = new JarEntry(path.toString().replace(File.separatorChar, '/'));
        byte[] buffer = new byte[4096];
        if (data.isCompressed()) {
            entry.setMethod(8);
        } else {
            entry.setMethod(0);
            JarPackagerUtil.calculateCrcAndSize(entry, new BufferedInputStream(new FileInputStream(file)), buffer);
        }
        entry.setTime(System.currentTimeMillis());
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        try {
            int count;
            this.fJarOutputStream.putNextEntry(entry);
            while ((count = ((InputStream)stream).read(buffer, 0, buffer.length)) != -1) {
                this.fJarOutputStream.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
    }
}

