/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.IDEFileReportProvider;
import org.eclipse.birt.report.designer.internal.ui.ide.adapters.LibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.BIRTGotoMarker;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.designer.ui.editors.MultiPageReportEditor;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

public class IDEMultiPageReportEditor
extends MultiPageReportEditor {
    private static final String ProblemMarkID = "org.eclipse.birt.report.designer.ui.ide.birtproblemmarker";
    protected static final Logger logger = Logger.getLogger(IDEMultiPageReportEditor.class.getName());
    public static final String ELEMENT_ID = "ElementId";
    private static final String DLG_SAVE_BUTTON_CLOSE = Messages.getString((String)"ReportEditor.Button.Close");
    private static final String DLG_SAVE_BUTTON_SAVE = Messages.getString((String)"ReportEditor.Button.Save");
    private static final String DLG_SAVE_CONFIRM_DELETE = Messages.getString((String)"ReportEditor.Dlg.Confirm");
    private static final String DLG_SAVE_TITLE = Messages.getString((String)"ReportEditor.Dlg.Save");
    private boolean isWorkspaceResource = false;
    private ResourceTracker resourceListener = new ResourceTracker();

    protected void setInput(IEditorInput input) {
        if (this.isWorkspaceResource) {
            this.getFile(this.getEditorInput()).getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        this.isWorkspaceResource = input instanceof IFileEditorInput;
        super.setInput(input);
        if (this.isWorkspaceResource) {
            this.getFile(this.getEditorInput()).getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
    }

    private IFile getFile(IEditorInput editorInput) {
        if (this.isWorkspaceResource) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part != this) {
            return;
        }
        if (this.isWorkspaceResource && !((IFileEditorInput)this.getEditorInput()).getFile().exists()) {
            String[] buttons;
            String message;
            String title;
            Shell shell = this.getSite().getShell();
            MessageDialog dialog = new MessageDialog(shell, title = DLG_SAVE_TITLE, null, message = DLG_SAVE_CONFIRM_DELETE, 3, buttons = new String[]{DLG_SAVE_BUTTON_SAVE, DLG_SAVE_BUTTON_CLOSE}, 0);
            if (dialog.open() == 0) {
                this.doSaveAs();
                this.partActivated(part);
            } else {
                this.closeEditor(false);
            }
        }
    }

    protected void addPages() {
        super.addPages();
        if (this.isWorkspaceResource) {
            try {
                this.refreshMarkers(this.getEditorInput());
            }
            catch (CoreException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void refreshMarkers(IEditorInput input) throws CoreException {
        IFile file = this.getFile(input);
        if (file != null) {
            file.deleteMarkers(ProblemMarkID, true, 2);
            ModuleHandle reportDesignHandle = this.getModel();
            if (reportDesignHandle == null) {
                return;
            }
            reportDesignHandle.checkReport();
            List list = reportDesignHandle.getErrorList();
            int errorListSize = list.size();
            list.addAll(reportDesignHandle.getWarningList());
            int i = 0;
            int m = list.size();
            while (i < m) {
                ErrorDetail errorDetail = (ErrorDetail)list.get(i);
                IMarker marker = file.createMarker(ProblemMarkID);
                HashMap<String, Object> attrib = new HashMap<String, Object>();
                if (i < errorListSize) {
                    attrib.put("severity", 2);
                } else {
                    attrib.put("severity", 1);
                }
                attrib.put("message", errorDetail.getMessage());
                attrib.put("lineNumber", errorDetail.getLineNo());
                attrib.put("location", errorDetail.getTagName());
                if (errorDetail.getElement() != null && errorDetail.getElement().getID() != 0L) {
                    attrib.put(ELEMENT_ID, (int)errorDetail.getElement().getID());
                }
                marker.setAttributes(attrib);
                ++i;
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        try {
            this.refreshMarkers(this.getEditorInput());
        }
        catch (CoreException coreException) {}
    }

    public void doSaveAs() {
        super.doSaveAs();
        try {
            this.refreshMarkers(this.getEditorInput());
        }
        catch (CoreException coreException) {}
    }

    public void dispose() {
        try {
            this.clearMarkers();
        }
        catch (CoreException coreException) {}
        if (this.isWorkspaceResource) {
            this.getFile(this.getEditorInput()).getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        }
        super.dispose();
        this.reportProvider = null;
    }

    protected void clearMarkers() throws CoreException {
        IFile resource = this.getFile(this.getEditorInput());
        if (resource != null && resource.exists()) {
            resource.deleteMarkers(ProblemMarkID, true, 1);
        }
    }

    public Object getAdapter(Class type) {
        if (type == ILibraryProvider.class) {
            return new LibraryProvider();
        }
        if (type == IReportProvider.class) {
            return this.getProvider();
        }
        if (type == IGotoMarker.class) {
            return new BIRTGotoMarker(this);
        }
        return super.getAdapter(type);
    }

    protected IReportProvider getProvider() {
        if (this.reportProvider == null) {
            this.reportProvider = new IDEFileReportProvider();
        }
        return this.reportProvider;
    }

    protected boolean prePageChanges(Object oldPage, Object newPage) {
        boolean isNewPageValid = true;
        boolean isOldDirty = true;
        if (oldPage instanceof IReportEditorPage) {
            isOldDirty = ((IReportEditorPage)oldPage).isDirty();
        }
        isNewPageValid = super.prePageChanges(oldPage, newPage);
        boolean isOldDirtyNow = true;
        if (oldPage instanceof IReportEditorPage) {
            isOldDirtyNow = ((IReportEditorPage)oldPage).isDirty();
        }
        if (oldPage instanceof IReportEditorPage && isOldDirty && !isOldDirtyNow) {
            try {
                this.refreshMarkers(this.getEditorInput());
            }
            catch (CoreException coreException) {}
        }
        return isNewPageValid;
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {}
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)IDEMultiPageReportEditor.this.getFile(IDEMultiPageReportEditor.this.getEditorInput()))) {
                return true;
            }
            if (delta.getKind() == 2) {
                Display display = IDEMultiPageReportEditor.this.getSite().getShell().getDisplay();
                if ((0x2000 & delta.getFlags()) == 0) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!IDEMultiPageReportEditor.this.isDirty()) {
                                IDEMultiPageReportEditor.this.closeEditor(false);
                            } else {
                                String title = DLG_SAVE_TITLE;
                                String message = DLG_SAVE_CONFIRM_DELETE;
                                String[] buttons = new String[]{DLG_SAVE_BUTTON_SAVE, DLG_SAVE_BUTTON_CLOSE};
                                MessageDialog dialog = new MessageDialog(IDEMultiPageReportEditor.this.getSite().getShell(), title, null, message, 3, buttons, 0);
                                if (dialog.open() == 0) {
                                    IDEMultiPageReportEditor.this.doSaveAs();
                                } else {
                                    IDEMultiPageReportEditor.this.closeEditor(false);
                                }
                            }
                        }
                    });
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    display.asyncExec(new Runnable(){

                        public void run() {
                            FileEditorInput input = new FileEditorInput(newFile);
                            ResourceTracker.this.setAllInput(input);
                        }
                    });
                }
            } else {
                delta.getKind();
            }
            return false;
        }

        private void setAllInput(FileEditorInput input) {
            if (IDEMultiPageReportEditor.this.pages == null) {
                return;
            }
            IDEMultiPageReportEditor.this.setInput((IEditorInput)input);
            if (IDEMultiPageReportEditor.this.getEditorInput() != null) {
                IDEMultiPageReportEditor.this.setPartName(IDEMultiPageReportEditor.this.getEditorInput().getName());
                IDEMultiPageReportEditor.this.firePropertyChange(260);
                IDEMultiPageReportEditor.this.firePropertyChange(260);
                IDEMultiPageReportEditor.this.getProvider().getReportModuleHandle((Object)IDEMultiPageReportEditor.this.getEditorInput()).setFileName(IDEMultiPageReportEditor.this.getProvider().getInputPath(IDEMultiPageReportEditor.this.getEditorInput()).toOSString());
            }
            for (Object page : IDEMultiPageReportEditor.this.pages) {
                if (!(page instanceof IReportEditorPage)) continue;
                ((IReportEditorPage)page).setInput((IEditorInput)input);
            }
            IDEMultiPageReportEditor.this.updateRelatedViews();
        }
    }
}

