/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer.action;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.lib.explorer.resource.ReportResourceEntry;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.Action;

public class ApplyThemeAction
extends Action {
    private static final String ACTION_TEXT = Messages.getString((String)"ApplyThemeAction.Text");
    private Object element;

    public ApplyThemeAction() {
        super(ACTION_TEXT);
    }

    public void setSelectedTheme(Object element) {
        this.element = element instanceof ReportResourceEntry ? ((ReportResourceEntry)element).getReportElement() : element;
    }

    public boolean isEnabled() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (moduleHandle == null || !(moduleHandle instanceof ReportDesignHandle)) {
            return false;
        }
        if (this.element == null || !(this.element instanceof ThemeHandle)) {
            return false;
        }
        if (!(((ThemeHandle)this.element).getRoot() instanceof LibraryHandle)) {
            return false;
        }
        ThemeHandle themeInReport = UIUtil.themeInModuleHandle((ThemeHandle)((ThemeHandle)this.element), (ModuleHandle)moduleHandle);
        ReportDesignHandle report = (ReportDesignHandle)moduleHandle;
        return themeInReport == null || report.getTheme() != themeInReport;
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(ACTION_TEXT);
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        LibraryHandle library = (LibraryHandle)((ThemeHandle)this.element).getRoot();
        try {
            if (UIUtil.includeLibrary((ModuleHandle)moduleHandle, (LibraryHandle)library)) {
                UIUtil.applyTheme((ThemeHandle)((ThemeHandle)this.element), (ModuleHandle)moduleHandle, (LibraryHandle)library);
                stack.commit();
            } else {
                stack.rollback();
            }
        }
        catch (DesignFileException designFileException) {
            stack.rollback();
        }
        catch (SemanticException semanticException) {
            stack.rollback();
        }
    }
}

