/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfcore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.utils.PreviewUtil;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class LoadBundleTagConverter
extends HiddenTagConverter {
    private static Logger _log = PDPlugin.getLogger(LoadBundleTagConverter.class);

    public LoadBundleTagConverter(Element host, ILabelProvider labelProvider) {
        super(host, labelProvider);
    }

    public void convertRefresh(Object context) {
        IDOMModel model;
        Element hostEle = this.getHostElement();
        String varString = hostEle.getAttribute("var");
        String baseName = hostEle.getAttribute("basename");
        if (baseName == null || varString == null) {
            return;
        }
        baseName = String.valueOf(baseName.replace('.', '/')) + "." + "properties";
        IProject project = null;
        if (hostEle instanceof IDOMNode && (model = ((IDOMNode)hostEle).getModel()) != null) {
            project = StructuredModelUtil.getProjectFor((IStructuredModel)model);
        }
        if (project == null) {
            return;
        }
        String prop = new StringBuffer("webroot").append("/").append("WEB-INF").append("/").append("classes").append("/").append(baseName).toString();
        IResource res = project.findMember(prop);
        if (res == null && (res = project.findMember(prop = "src/" + baseName)) == null) {
            return;
        }
        InputStream ins = null;
        try {
            PropertyResourceBundle bundle;
            File f = new File(res.getLocation().toString());
            ins = new FileInputStream(f);
            if (ins != null && (bundle = new PropertyResourceBundle(ins = new BufferedInputStream(ins))) != null) {
                if (PreviewUtil.getBUNDLE_MAP() == null) {
                    PreviewUtil.setBUNDLE_MAP(new HashMap());
                } else {
                    PreviewUtil.getBUNDLE_MAP().clear();
                }
                PreviewUtil.getBUNDLE_MAP().put(varString, bundle);
                PreviewUtil.setBUNDLE((PropertyResourceBundle)bundle);
                PreviewUtil.setVAR((String)varString);
            }
        }
        catch (MalformedURLException e) {
            _log.error("LoadBundleTagConverter.convertRefresh.MalformedURLException", (Throwable)e);
            ResourceUtils.ensureClosed(ins);
            return;
        }
        catch (IOException e) {
            try {
                _log.error("LoadBundleTagConverter.convertRefresh.IOException", (Throwable)e);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ResourceUtils.ensureClosed(ins);
            }
        }
        ResourceUtils.ensureClosed((InputStream)ins);
    }
}

