/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemFigureProvider;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.widgets.Display;

public class ChartReportItemUIImpl
extends ReportItemFigureProvider {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");
    private static Map<DesignElementHandle, Listener> listenerMap = new HashMap<DesignElementHandle, Listener>();

    public final IFigure createFigure(final ExtendedItemHandle eih) {
        try {
            eih.loadExtendedElement();
        }
        catch (ExtendedElementException eeex) {
            logger.log((Exception)((Object)eeex));
        }
        try {
            DesignElementHandle hostChart;
            ChartReportItemImpl iri = (ChartReportItemImpl)eih.getReportItem();
            DesignerRepresentation dr = new DesignerRepresentation(iri);
            iri.setDesignerRepresentation((Object)dr);
            if (iri.isCopied() && ChartCubeUtil.isPlotChart((DesignElementHandle)eih)) {
                ExtendedItemHandle axisChart;
                AggregationCellHandle containerCell;
                AggregationCellHandle grandTotalCell;
                Object content;
                ChartWithAxes cwa = (ChartWithAxes)iri.getProperty("chart.instance");
                Axis yAxis = (Axis)((Axis)cwa.getAxes().get(0)).getAssociatedAxes().get(0);
                if (yAxis.getLineAttributes().isVisible() && ChartCubeUtil.findReferenceChart((ExtendedItemHandle)eih) == null && ChartCubeUtil.isAxisChart((DesignElementHandle)((DesignElementHandle)(content = ChartCubeUtil.getFirstContent((CrosstabCellHandle)(grandTotalCell = ChartXTabUIUtil.getGrandTotalAggregationCell((AggregationCellHandle)(containerCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)eih)), (boolean)cwa.isTransposed())))))) && !(axisChart = (ExtendedItemHandle)content).getElementProperty("hostChart").equals(eih)) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                axisChart.setProperty("hostChart", (Object)eih);
                            }
                            catch (SemanticException e) {
                                logger.log((Exception)((Object)e));
                            }
                        }
                    });
                }
            } else if (ChartCubeUtil.isAxisChart((DesignElementHandle)eih) && (hostChart = eih.getElementProperty("hostChart")) != null) {
                Listener listener = this.createDeleteChartListener((DesignElementHandle)eih);
                DesignElementHandle cell = hostChart.getContainer();
                cell.addListener(listener);
                if (cell.getContainer() != null) {
                    cell.getContainer().addListener(listener);
                }
            }
            return dr;
        }
        catch (BirtException e) {
            logger.log((Exception)((Object)e));
            return null;
        }
    }

    public final void updateFigure(ExtendedItemHandle eih, IFigure ifg) {
        try {
            IFigure parentFigure;
            DimensionHandle dhWidth;
            DimensionHandle dhHeight;
            Chart cm;
            ExtendedItemHandle hostChart;
            eih.loadExtendedElement();
            ChartReportItemImpl crii = (ChartReportItemImpl)eih.getReportItem();
            crii.setHandle(eih);
            boolean bAxisChart = ChartCubeUtil.isAxisChart((DesignElementHandle)eih);
            if (bAxisChart) {
                hostChart = (ExtendedItemHandle)eih.getElementProperty("hostChart");
                cm = ChartCubeUtil.getChartFromHandle((ExtendedItemHandle)hostChart);
            } else {
                hostChart = null;
                cm = (Chart)crii.getProperty("chart.instance");
            }
            if (cm == null) {
                return;
            }
            Bounds defaultBounds = ChartItemUtil.createDefaultChartBounds((ExtendedItemHandle)eih, (Chart)cm);
            double dHeightInPoints = defaultBounds.getHeight();
            double dWidthInPoints = defaultBounds.getWidth();
            if (bAxisChart) {
                if (ChartXTabUIUtil.isTransposedChartWithAxes(cm)) {
                    dhHeight = eih.getHeight();
                    dhWidth = hostChart.getWidth();
                } else {
                    dhHeight = hostChart.getHeight();
                    dhWidth = eih.getWidth();
                }
            } else {
                dhHeight = eih.getHeight();
                dhWidth = eih.getWidth();
            }
            double dOriginalHeight = dhHeight.getMeasure();
            String sHeightUnits = dhHeight.getUnits();
            double dOriginalWidth = dhWidth.getMeasure();
            String sWidthUnits = dhWidth.getUnits();
            IDisplayServer idsSWT = ChartUIUtil.getDisplayServer();
            if (sHeightUnits != null) {
                if (sHeightUnits == "px") {
                    dOriginalHeight = ChartUtil.convertPixelsToPoints((IDisplayServer)idsSWT, (double)dOriginalHeight);
                    sHeightUnits = "pt";
                }
                if (sHeightUnits == "%" && (parentFigure = ifg.getParent()) != null) {
                    int height = (int)((double)(parentFigure.getSize().height - parentFigure.getInsets().getHeight()) * dOriginalHeight / 100.0);
                    dOriginalHeight = ChartUtil.convertPixelsToPoints((IDisplayServer)idsSWT, (double)height);
                    sHeightUnits = "pt";
                }
                dHeightInPoints = DimensionUtil.convertTo((double)dOriginalHeight, (String)sHeightUnits, (String)"pt").getMeasure();
            }
            if (sWidthUnits != null) {
                if (sWidthUnits == "px") {
                    dOriginalWidth = dOriginalWidth * 72.0 / (double)idsSWT.getDpiResolution();
                    sWidthUnits = "pt";
                }
                if (sWidthUnits == "%" && (parentFigure = ifg.getParent()) != null) {
                    int width = (int)((double)(parentFigure.getSize().width - parentFigure.getInsets().getWidth()) * dOriginalWidth / 100.0);
                    dOriginalWidth = ChartUtil.convertPixelsToPoints((IDisplayServer)idsSWT, (double)width);
                    sWidthUnits = "pt";
                }
                dWidthInPoints = DimensionUtil.convertTo((double)dOriginalWidth, (String)sWidthUnits, (String)"pt").getMeasure();
            }
            double dHeightInPixels = (double)idsSWT.getDpiResolution() * dHeightInPoints / 72.0;
            double dWidthInPixels = (double)idsSWT.getDpiResolution() * dWidthInPoints / 72.0;
            if (cm != null && !bAxisChart) {
                if (dWidthInPoints >= 0.0) {
                    cm.getBlock().getBounds().setWidth(dWidthInPoints);
                }
                if (dHeightInPoints >= 0.0) {
                    cm.getBlock().getBounds().setHeight(dHeightInPoints);
                }
            }
            if (crii.getDesignerRepresentation() != null) {
                ((DesignerRepresentation)((Object)crii.getDesignerRepresentation())).setDirty(true);
            }
            Dimension newSize = ifg.getBounds().getCopy().getSize();
            if (dWidthInPixels >= 0.0) {
                newSize.width = (int)dWidthInPixels;
            }
            if (dHeightInPixels >= 0.0) {
                newSize.height = (int)dHeightInPixels;
            }
            ifg.setSize(newSize);
        }
        catch (BirtException ex) {
            logger.log((Exception)((Object)ex));
        }
    }

    public final void disposeFigure(ExtendedItemHandle eih, IFigure ifg) {
        logger.log(1, Messages.getString("ChartReportItemUIImpl.log.ReceivedNotification"));
        ((DesignerRepresentation)ifg).dispose();
        listenerMap.remove(eih);
    }

    private Listener createDeleteChartListener(final DesignElementHandle handleTarget) {
        if (listenerMap.containsKey(handleTarget)) {
            return listenerMap.get(handleTarget);
        }
        Listener listener = new Listener(){

            public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
                DesignElementHandle handleSource;
                ContentEvent cv;
                if (ev instanceof ContentEvent && (cv = (ContentEvent)ev).getAction() == 2 && ((handleSource = handleTarget.getElementProperty("hostChart")) == null || cv.getContent() == handleSource.getElement())) {
                    try {
                        if (handleTarget.getRoot() != null) {
                            handleTarget.dropAndClear();
                        }
                    }
                    catch (SemanticException e) {
                        logger.log((Exception)((Object)e));
                    }
                }
            }
        };
        listenerMap.put(handleTarget, listener);
        return listener;
    }
}

