/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.ui.QueryUIHelper;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartXTabUIUtil
extends ChartCubeUtil {
    public static boolean checkQueryExpression(String checkType, Object data, Chart cm, ExtendedItemHandle itemHandle, ReportDataServiceProvider provider) {
        Map<String, Query[]> queryDefinitionsMap = QueryUIHelper.getQueryDefinitionsMap(cm);
        return ChartXTabUIUtil.checkQueryExpression(checkType, data, queryDefinitionsMap, itemHandle, provider);
    }

    public static boolean isTransposedChartWithAxes(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return ((ChartWithAxes)cm).isTransposed();
        }
        throw new IllegalArgumentException(Messages.getString("Error.ChartShouldIncludeAxes"));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkQueryExpression(String checkType, Object data, Map<String, Query[]> queryDefinitionsMap, ExtendedItemHandle itemHandle, ReportDataServiceProvider provider) {
        if (data == null || "".equals(data)) {
            return true;
        }
        categoryDimension = null;
        yOptionDimension = null;
        categoryBindName = null;
        yOptionBindName = null;
        expression = (String)data;
        columnBindings = null;
        if (ChartXTabUIUtil.getBindingCube((DesignElementHandle)itemHandle) != null && provider.isInheritanceOnly() || provider.isSharedBinding()) {
            reportItemHandle = provider.getReportItemHandle();
            columnBindings = reportItemHandle.getColumnBindings().iterator();
        } else if (ChartXTabUIUtil.getBindingCube((DesignElementHandle)itemHandle) != null || provider.isInXTabMeasureCell() && !provider.isPartChart()) {
            columnBindings = ChartXTabUIUtil.getAllColumnBindingsIterator((ReportItemHandle)itemHandle);
        }
        if ("optional".equals(checkType)) {
            categoryExpr = null;
            querys = queryDefinitionsMap.get("category");
            if (querys != null && querys.length > 0) {
                categoryExpr = querys[0].getDefinition();
            }
            if (categoryExpr == null || "".equals(categoryExpr)) {
                return true;
            }
            categoryBindName = ChartExpressionUtil.getCubeBindingName((String)categoryExpr, (boolean)true);
            yOptionBindName = ChartExpressionUtil.getCubeBindingName((String)expression, (boolean)true);
        } else if ("category".equals(checkType)) {
            yOptionExpr = null;
            querys = queryDefinitionsMap.get("optional");
            if (querys != null && querys.length > 0) {
                yOptionExpr = querys[0].getDefinition();
            }
            if (yOptionExpr == null || "".equals(yOptionExpr)) {
                return true;
            }
            categoryBindName = ChartExpressionUtil.getCubeBindingName((String)expression, (boolean)true);
            yOptionBindName = ChartExpressionUtil.getCubeBindingName((String)yOptionExpr, (boolean)true);
        }
        if (columnBindings != null) ** GOTO lbl44
        return true;
lbl-1000:
        // 1 sources

        {
            columnHandle = (ComputedColumnHandle)columnBindings.next();
            bindName = columnHandle.getName();
            expr = columnHandle.getExpression();
            if (!ChartExpressionUtil.isDimensionExpresion((String)expr)) continue;
            if (bindName.equals(categoryBindName)) {
                categoryDimension = ChartExpressionUtil.getLevelNameFromDimensionExpression((String)expr)[0];
            }
            if (!bindName.equals(yOptionBindName)) continue;
            yOptionDimension = ChartExpressionUtil.getLevelNameFromDimensionExpression((String)expr)[0];
lbl44:
            // 4 sources

            ** while (columnBindings.hasNext())
        }
lbl45:
        // 1 sources

        return categoryDimension == null || yOptionDimension == null || categoryDimension.equals(yOptionDimension) == false;
    }

    public static List<String> getLevelNamesInDimension(String cubeBinding, CubeHandle cube, boolean includeSelf, boolean useFullName) throws BirtException {
        if (cubeBinding == null || cube == null) {
            return Collections.emptyList();
        }
        List bindings = ExpressionUtil.extractColumnExpressions((String)cubeBinding, (String)"data");
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        String levelFullName = ((IColumnBinding)bindings.get(0)).getResultSetColumnName();
        String[] names = levelFullName.split("/");
        if (names.length < 2) {
            return Collections.emptyList();
        }
        String dimensionName = names[0];
        if (cube.getContentCount("dimensions") <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> levelNames = new ArrayList<String>();
        for (DimensionHandle dimensionHandle : cube.getContents("dimensions")) {
            if (!dimensionName.equals(dimensionHandle.getName())) continue;
            HierarchyHandle hierarchy = (HierarchyHandle)dimensionHandle.getContent("hierarchies", 0);
            int count = hierarchy.getLevelCount();
            int i = 0;
            while (i < count) {
                String fullName = hierarchy.getLevel(i).getFullName();
                if (includeSelf || !fullName.equals(levelFullName)) {
                    if (!useFullName) {
                        levelNames.add(hierarchy.getLevel(i).getName());
                    } else {
                        levelNames.add(fullName);
                    }
                }
                ++i;
            }
            return levelNames;
        }
        return Collections.emptyList();
    }
}

