/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.PluginProjectApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.ApiMarkerResolutionGenerator;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class RemoveFilterProblemResolution
extends WorkbenchMarkerResolution {
    IApiProblemFilter fFilter = null;
    private IMarker fMarker = null;
    boolean plural = false;

    public RemoveFilterProblemResolution(IApiProblemFilter filter, IMarker marker) {
        this.fFilter = filter;
        this.fMarker = marker;
    }

    public String getDescription() {
        return NLS.bind((String)MarkerMessages.RemoveFilterProblemResolution_removes_selected_problem_filter, (Object)MarkerUtilities.getMessage((IMarker)this.fMarker));
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_REMOVE");
    }

    public String getLabel() {
        if (this.plural) {
            return MarkerMessages.RemoveFilterProblemResolution_remove_unused_filters;
        }
        return MarkerMessages.RemoveFilterProblemResolution_remove_unused_filter;
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getLabel(), (int)markers.length);
        try {
            HashSet<IProject> pjs = new HashSet<IProject>(markers.length);
            IApiProblemFilter filter = this.fFilter;
            IApiComponent component = null;
            int i = 0;
            while (i < markers.length) {
                if (!this.fMarker.equals((Object)markers[i])) {
                    filter = ApiMarkerResolutionGenerator.resolveFilter(markers[i]);
                }
                if (filter == null) {
                    localmonitor.worked(1);
                } else {
                    IResource resource = markers[i].getResource();
                    IProject project = resource.getProject();
                    component = ApiBaselineManager.getManager().getWorkspaceBaseline().getApiComponent(project);
                    if (component instanceof PluginProjectApiComponent) {
                        try {
                            IApiFilterStore store = component.getFilterStore();
                            store.removeFilters(new IApiProblemFilter[]{filter});
                            Util.touchCorrespondingResource((IProject)project, (IResource)resource, (String)Util.getTypeNameFromMarker((IMarker)markers[i]));
                            pjs.add(project);
                        }
                        catch (CoreException ce) {
                            ApiPlugin.log((Throwable)ce);
                        }
                    }
                    localmonitor.worked(1);
                }
                ++i;
            }
            if (pjs.size() > 0 && !ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                IProject[] projects = pjs.toArray(new IProject[pjs.size()]);
                Util.getBuildJob((IProject[])projects, (int)10).schedule();
            }
        }
        finally {
            localmonitor.done();
        }
    }

    public void run(IMarker marker) {
        this.run(new IMarker[]{marker}, null);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        int i = 0;
        while (i < markers.length) {
            try {
                if (markers[i].getType() == "org.eclipse.pde.api.tools.unused_filters" && !this.fMarker.equals((Object)markers[i])) {
                    mset.add(markers[i]);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        int size = mset.size();
        this.plural = size > 0;
        return mset.toArray(new IMarker[size]);
    }
}

