/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.wizards;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.wizards.WizardMessages;

public class ProjectUpdateChange
extends Change {
    private IProject fProject = null;

    public ProjectUpdateChange(IProject project) {
        this.fProject = project;
    }

    public Object getModifiedElement() {
        return this.fProject;
    }

    public String getName() {
        return MessageFormat.format((String)WizardMessages.ProjectUpdateChange_add_nature_and_builder, (Object[])new String[0]);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.fProject.isAccessible()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        return RefactoringStatus.createErrorStatus((String)MessageFormat.format((String)WizardMessages.ProjectUpdateChange_project_not_accessible, (Object[])new String[]{this.fProject.getName()}));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 1);
        pm.setTaskName(WizardMessages.ProjectUpdateChange_adding_nature_and_builder);
        IProjectDescription description = this.fProject.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = "org.eclipse.pde.api.tools.apiAnalysisNature";
        description.setNatureIds(newNatures);
        this.fProject.setDescription(description, pm);
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        ApiDescriptionManager.getDefault().clean(javaProject, true, true);
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            Util.getBuildJob((IProject[])new IProject[]{this.fProject}).schedule();
        } else {
            BuildState.setLastBuiltState((IProject)this.fProject, null);
        }
        if (!pm.isCanceled()) {
            pm.worked(1);
        }
        return null;
    }
}

