/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core.history;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import javax.security.auth.login.LoginException;
import javax.swing.text.html.HTML;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.net.HtmlTag;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.history.TaskHistory;
import org.eclipse.mylyn.internal.bugzilla.core.history.TaskRevision;

public class BugzillaTaskHistoryParser {
    private final InputStream inStream;
    private final String characterEncoding;

    public BugzillaTaskHistoryParser(InputStream inStream, String characterEncoding) {
        this.inStream = inStream;
        this.characterEncoding = characterEncoding;
    }

    public TaskHistory retrieveHistory(BugzillaLanguageSettings bugzillaLanguageSettings) throws IOException, ParseException, LoginException {
        TaskHistory activity = new TaskHistory();
        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)new BufferedReader(new InputStreamReader(this.inStream, this.characterEncoding)), null);
        boolean isTitle = false;
        boolean possibleBadLogin = false;
        String title = "";
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            HtmlTag tag;
            if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.TITLE && !((HtmlTag)token.getValue()).isEndTag()) {
                isTitle = true;
            } else if (isTitle) {
                if (token.getType() != HtmlStreamTokenizer.Token.TAG) {
                    title = String.valueOf(title) + ((StringBuffer)token.getValue()).toString().toLowerCase() + " ";
                } else if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.TITLE && ((HtmlTag)token.getValue()).isEndTag()) {
                    boolean found = false;
                    Iterator<String> iterator = bugzillaLanguageSettings.getResponseForCommand("bad_login").iterator();
                    while (iterator.hasNext() && !found) {
                        String value = iterator.next().toLowerCase(Locale.ENGLISH);
                        boolean bl = found = found || title.indexOf(value) != -1;
                    }
                    if (found) {
                        possibleBadLogin = true;
                    }
                    isTitle = false;
                    title = "";
                }
            } else if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.BR && !tag.isEndTag()) {
                while ((token = tokenizer.nextToken()).getType() != HtmlStreamTokenizer.Token.TAG || (!(tag = (HtmlTag)token.getValue()).isEndTag() || tag.getTagType() != HTML.Tag.TR) && tag.getTagType() != HTML.Tag.P) {
                }
                this.parseActivity(tokenizer, activity);
            }
            token = tokenizer.nextToken();
        }
        if (activity.size() == 0 && possibleBadLogin) {
            throw new LoginException("Bugzilla login information incorrect");
        }
        return activity;
    }

    private void parseActivity(HtmlStreamTokenizer tokenizer, TaskHistory activity) throws IOException, ParseException {
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                HtmlTag tag = (HtmlTag)token.getValue();
                if (tag.getTagType() == HTML.Tag.TABLE && tag.isEndTag()) break;
                this.parseEvent(tokenizer, activity);
            }
            token = tokenizer.nextToken();
        }
    }

    private void parseEvent(HtmlStreamTokenizer tokenizer, TaskHistory activity) {
        int numChanges = 0;
        try {
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                HtmlTag tag;
                if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.TD && tag.hasAttribute("rowspan")) {
                    numChanges = tag.getIntAttribute("rowspan");
                    break;
                }
                token = tokenizer.nextToken();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String name = this.getData(tokenizer);
        String date = this.getData(tokenizer);
        int change = 0;
        while (change < numChanges) {
            String what = this.getData(tokenizer);
            String removed = this.getData(tokenizer);
            String added = this.getData(tokenizer);
            TaskRevision event = TaskRevision.createEvent(what, added);
            event.setName(name);
            event.setDate(date);
            event.setRemoved(removed);
            activity.addEvent(event);
            ++change;
        }
    }

    private String getData(HtmlStreamTokenizer tokenizer) {
        StringBuffer sb = new StringBuffer();
        try {
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                HtmlTag tag;
                if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.TD && tag.isEndTag()) {
                    String data = StringEscapeUtils.unescapeHtml((String)sb.toString());
                    if (data.startsWith("\n") && !data.contains("Attachment")) {
                        data = "";
                    }
                    return data;
                }
                if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                    sb.append(token.toString());
                }
                token = tokenizer.nextToken();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

