/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script.function.bre;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.function.bre.Function_temp;
import org.eclipse.birt.core.script.function.i18n.Messages;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionContext;
import org.eclipse.birt.core.script.functionservice.IScriptFunctionExecutor;

public class BirtDateTime
implements IScriptFunctionExecutor {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat abbrMonthFormat = null;
    private static SimpleDateFormat monthFormat = null;
    private static SimpleDateFormat abbrWeekFormat = null;
    private static SimpleDateFormat weekFormat = null;
    private IScriptFunctionExecutor executor;
    private static IScriptFunctionContext scriptContext;
    private static ULocale defaultLocale;
    private static TimeZone timeZone;

    static {
        defaultLocale = null;
        timeZone = null;
    }

    private static SimpleDateFormat getAbbrMonthFormat() {
        if (abbrMonthFormat == null) {
            abbrMonthFormat = new SimpleDateFormat("MMM", defaultLocale);
        }
        return abbrMonthFormat;
    }

    private static SimpleDateFormat getMonthFormat() {
        if (monthFormat == null) {
            monthFormat = new SimpleDateFormat("MMMM", defaultLocale);
        }
        return monthFormat;
    }

    private static SimpleDateFormat getAbbrWeekFormat() {
        if (abbrWeekFormat == null) {
            abbrWeekFormat = new SimpleDateFormat("EEE", defaultLocale);
        }
        return abbrWeekFormat;
    }

    private static SimpleDateFormat getWeekFormat() {
        if (weekFormat == null) {
            weekFormat = new SimpleDateFormat("EEEE", defaultLocale);
        }
        return weekFormat;
    }

    BirtDateTime(String functionName) throws BirtException {
        if ("year".equals(functionName)) {
            this.executor = new Function_Year();
        } else if ("quarter".equals(functionName)) {
            this.executor = new Function_Quarter();
        } else if ("month".equals(functionName)) {
            this.executor = new Function_Month();
        } else if ("week".equals(functionName)) {
            this.executor = new Function_Week();
        } else if ("day".equals(functionName)) {
            this.executor = new Function_Day();
        } else if ("weekDay".equals(functionName)) {
            this.executor = new Function_WeekDay();
        } else if ("today".equals(functionName)) {
            this.executor = new Function_Today();
        } else if ("now".equals(functionName)) {
            this.executor = new Function_Now();
        } else if ("diffYear".equals(functionName)) {
            this.executor = new Function_DiffYear();
        } else if ("diffMonth".equals(functionName)) {
            this.executor = new Function_DiffMonth();
        } else if ("diffQuarter".equals(functionName)) {
            this.executor = new Function_DiffQuarter();
        } else if ("diffWeek".equals(functionName)) {
            this.executor = new Function_DiffWeek();
        } else if ("diffDay".equals(functionName)) {
            this.executor = new Function_DiffDay();
        } else if ("diffHour".equals(functionName)) {
            this.executor = new Function_DiffHour();
        } else if ("diffMinute".equals(functionName)) {
            this.executor = new Function_DiffMinute();
        } else if ("diffSecond".equals(functionName)) {
            this.executor = new Function_DiffSecond();
        } else if ("addYear".equals(functionName)) {
            this.executor = new Function_AddYear();
        } else if ("addMonth".equals(functionName)) {
            this.executor = new Function_AddMonth();
        } else if ("addQuarter".equals(functionName)) {
            this.executor = new Function_AddQuarter();
        } else if ("addWeek".equals(functionName)) {
            this.executor = new Function_AddWeek();
        } else if ("addDay".equals(functionName)) {
            this.executor = new Function_AddDay();
        } else if ("addHour".equals(functionName)) {
            this.executor = new Function_AddHour();
        } else if ("addMinute".equals(functionName)) {
            this.executor = new Function_AddMinute();
        } else if ("addSecond".equals(functionName)) {
            this.executor = new Function_AddSecond();
        } else {
            throw new BirtException("org.eclipse.birt.core.script.function.bre", null, (Object)(String.valueOf(Messages.getString("invalid.function.name")) + "BirtDateTime." + functionName));
        }
    }

    private static int year(Date d) {
        if (d == null) {
            throw new IllegalArgumentException("date value is null!");
        }
        return BirtDateTime.getCalendar(d).get(1);
    }

    private static int quarter(Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int month = BirtDateTime.getCalendar(d).get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: 
            case 5: {
                return 2;
            }
            case 6: 
            case 7: 
            case 8: {
                return 3;
            }
            case 9: 
            case 10: 
            case 11: {
                return 4;
            }
        }
        return -1;
    }

    private static int month(Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(2) + 1;
    }

    private static String month(Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        Calendar c = BirtDateTime.getCalendar(d);
        int month = c.get(2);
        if (option == 1) {
            return String.valueOf(month + 1);
        }
        if (option == 2) {
            return BirtDateTime.getMonthFormat().format(d);
        }
        if (option == 3) {
            return BirtDateTime.getAbbrMonthFormat().format(d);
        }
        return null;
    }

    private static int week(Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(3);
    }

    private static int day(Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return BirtDateTime.getCalendar(d).get(5);
    }

    private static String weekDay(Date d) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        return String.valueOf(BirtDateTime.getCalendar(d).get(7));
    }

    private static String weekDay(Date d, int option) {
        if (d == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        switch (option) {
            case 1: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 1));
            }
            case 2: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2));
            }
            case 3: {
                return String.valueOf(BirtDateTime.getWeekDay(d, 2) - 1);
            }
            case 4: {
                return BirtDateTime.getWeekFormat().format(d);
            }
            case 5: {
                return BirtDateTime.getAbbrWeekFormat().format(d);
            }
        }
        return null;
    }

    private static Date today() {
        Calendar calendar = Calendar.getInstance((TimeZone)timeZone);
        calendar.set(11, 0);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        return calendar.getTime();
    }

    private static Timestamp now() {
        Date now = new Date();
        return new Timestamp(now.getTime());
    }

    private static int diffYear(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int startYear = BirtDateTime.year(d1);
        int endYear = BirtDateTime.year(d2);
        return endYear - startYear;
    }

    private static int diffMonth(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int startMonth = BirtDateTime.year(d1) * 12 + BirtDateTime.month(d1);
        int endMonth = BirtDateTime.year(d2) * 12 + BirtDateTime.month(d2);
        return endMonth - startMonth;
    }

    private static int diffQuarter(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        int startQuter = BirtDateTime.year(d1) * 4 + BirtDateTime.quarter(d1);
        int endQuter = BirtDateTime.year(d2) * 4 + BirtDateTime.quarter(d2);
        return endQuter - startQuter;
    }

    private static long diffWeek(Date d1, Date d2) {
        Date sd1 = BirtDateTime.getWeekStartDay(d1);
        Date sd2 = BirtDateTime.getWeekStartDay(d2);
        return BirtDateTime.diffDay(sd1, sd2) / 7L;
    }

    public static Date getWeekStartDay(Date date) {
        int diffDay = 1 - Integer.valueOf(BirtDateTime.weekDay(date));
        return BirtDateTime.addDay(date, diffDay);
    }

    private static long diffDay(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance((TimeZone)timeZone);
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance((TimeZone)timeZone);
        c2.setTime(d2);
        if (c1.after((Object)c2)) {
            return BirtDateTime.diffDay(c1, c2) * -1L;
        }
        return BirtDateTime.diffDay(c1, c2);
    }

    private static long diffDay(Calendar d1, Calendar d2) {
        if (d1.after((Object)d2)) {
            Calendar swap = d1;
            d1 = d2;
            d2 = swap;
        }
        int days = d2.get(6) - d1.get(6);
        int y2 = d2.get(1);
        if (d1.get(1) != y2) {
            do {
                days += d1.getActualMaximum(6);
                d1.add(1, 1);
            } while (d1.get(1) != y2);
        }
        return days;
    }

    private static long diffHour(Date d1, Date d2) {
        Calendar c = BirtDateTime.getClearedCalendarInstance(0, 0, 1);
        return (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 3600L - (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 3600L;
    }

    private static long diffMinute(Date d1, Date d2) {
        Calendar c = BirtDateTime.getClearedCalendarInstance(0, 0, 1);
        return (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d2) + 1814400000L) / 60L - (BirtDateTime.diffSecond(new Date(c.getTimeInMillis()), d1) + 1814400000L) / 60L;
    }

    private static Calendar getClearedCalendarInstance(int year, int month, int date) {
        Calendar c = Calendar.getInstance((TimeZone)timeZone);
        c.clear();
        c.set(year, month, date);
        return c;
    }

    private static long diffSecond(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException(Messages.getString("error.BirtDateTime.cannotBeNull.DateValue"));
        }
        long diff = d2.getTime() - d1.getTime();
        if (timeZone != null && timeZone.inDaylightTime(d1)) {
            diff -= (long)timeZone.getDSTSavings();
        }
        if (timeZone != null && timeZone.inDaylightTime(d2)) {
            diff += (long)timeZone.getDSTSavings();
        }
        return new Long(diff / 1000L);
    }

    private static Date addYear(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(1, num);
        return startCal.getTime();
    }

    private static Date addMonth(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(2, num);
        return startCal.getTime();
    }

    private static Date addQuarter(Date date, int num) {
        return BirtDateTime.addMonth(date, num * 3);
    }

    private static Date addWeek(Date date, int num) {
        return BirtDateTime.addDay(date, num * 7);
    }

    private static Date addDay(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(5, num);
        return startCal.getTime();
    }

    private static Date addHour(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(11, num);
        return startCal.getTime();
    }

    private static Date addMinute(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(12, num);
        return startCal.getTime();
    }

    private static Date addSecond(Date date, int num) {
        Calendar startCal = BirtDateTime.getCalendar(date);
        startCal.add(13, num);
        return startCal.getTime();
    }

    private static int getWeekDay(Date d, int startDay) {
        int dayOfWeek = BirtDateTime.getCalendar(d).get(7);
        if (dayOfWeek >= startDay) {
            return dayOfWeek - startDay + 1;
        }
        return (dayOfWeek - startDay + 1 + 7) % 8;
    }

    private static Calendar getCalendar(Date d) {
        Calendar c = Calendar.getInstance((TimeZone)timeZone);
        if (d == null) {
            c.clear();
            c.set(1970, 0, 1);
        } else {
            c.setTime(d);
        }
        return c;
    }

    private static boolean existNullValue(Object[] args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i] == null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object execute(Object[] arguments, IScriptFunctionContext context) throws BirtException {
        scriptContext = context;
        if (scriptContext != null) {
            ULocale locale = (ULocale)scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.locale");
            if (defaultLocale != locale) {
                abbrMonthFormat = null;
                monthFormat = null;
                abbrWeekFormat = null;
                weekFormat = null;
                defaultLocale = locale;
            }
            timeZone = (TimeZone)scriptContext.findProperty("org.eclipse.birt.core.script.functionservice.context.timeZone");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return this.executor.execute(arguments, context);
    }

    private class Function_AddDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddDay() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addDay(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddHour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddHour() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addHour(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddMinute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddMinute() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addMinute(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddMonth() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addMonth(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddQuarter() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addQuarter(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddSecond
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddSecond() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addSecond(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddWeek() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addWeek(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_AddYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_AddYear() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.addYear(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_Day
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Day() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.day(DataTypeUtil.toDate((Object)args[0])));
        }
    }

    private class Function_DiffDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffDay() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Long(BirtDateTime.diffDay(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffHour
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffHour() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Long(BirtDateTime.diffHour(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffMinute
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffMinute() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Long(BirtDateTime.diffMinute(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffMonth
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffMonth() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.diffMonth(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffQuarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffQuarter() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.diffQuarter(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffSecond
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffSecond() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Long(BirtDateTime.diffSecond(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffWeek
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffWeek() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Long(BirtDateTime.diffWeek(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_DiffYear
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_DiffYear() {
            this.length = 2;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.diffYear(DataTypeUtil.toDate((Object)args[0]), DataTypeUtil.toDate((Object)args[1])));
        }
    }

    private class Function_Month
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Month() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args.length == 1) {
                return new Integer(BirtDateTime.month(DataTypeUtil.toDate((Object)args[0])));
            }
            return BirtDateTime.month(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_Now
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Now() {
            this.length = 0;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            return BirtDateTime.now();
        }
    }

    private class Function_Quarter
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Quarter() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.quarter(DataTypeUtil.toDate((Object)args[0])));
        }
    }

    private class Function_Today
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Today() {
            this.length = 0;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return BirtDateTime.today();
        }
    }

    private class Function_Week
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Week() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.week(DataTypeUtil.toDate((Object)args[0])));
        }
    }

    private class Function_WeekDay
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_WeekDay() {
            this.length = 2;
            this.isFixed = false;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            if (args.length == 1) {
                return BirtDateTime.weekDay(DataTypeUtil.toDate((Object)args[0]));
            }
            return BirtDateTime.weekDay(DataTypeUtil.toDate((Object)args[0]), ((Number)args[1]).intValue());
        }
    }

    private class Function_Year
    extends Function_temp {
        private static final long serialVersionUID = 1L;

        Function_Year() {
            this.length = 1;
            this.isFixed = true;
        }

        protected Object getValue(Object[] args) throws BirtException {
            if (BirtDateTime.existNullValue(args)) {
                return null;
            }
            return new Integer(BirtDateTime.year(DataTypeUtil.toDate((Object)args[0])));
        }
    }
}

