/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.utilities.SocketUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.jetty.JettyConfigurator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class AppServerWrapper {
    public static final String HOST_KEY = "host";
    public static final String PORT_KEY = "port";
    private static AppServerWrapper wrapper = null;
    private String host = null;
    private Map<String, Integer> ports = new HashMap<String, Integer>();

    public static synchronized AppServerWrapper getInstance() {
        if (wrapper == null) {
            wrapper = new AppServerWrapper();
        }
        return wrapper;
    }

    private void configureServer(String webappName) {
        this.host = ViewerPlugin.getDefault().getPluginPreferences().getString(HOST_KEY);
        int port = ViewerPlugin.getDefault().getPluginPreferences().getInt(PORT_KEY);
        try {
            String hostCommandLineOverride = System.getProperty("server_host");
            if (hostCommandLineOverride != null && hostCommandLineOverride.trim().length() > 0) {
                this.host = hostCommandLineOverride;
            }
        }
        catch (Exception exception) {}
        try {
            String portCommandLineOverride = System.getProperty("server_port");
            if (portCommandLineOverride != null && portCommandLineOverride.trim().length() > 0) {
                port = Integer.parseInt(portCommandLineOverride);
            }
        }
        catch (Exception exception) {}
        if (this.host == null || this.host.trim().length() <= 0) {
            this.host = "127.0.0.1";
        }
        if (port <= 0) {
            port = SocketUtil.findUnusedLocalPort();
        }
        this.ports.put(webappName, port);
    }

    public void start(String webappName) throws Exception {
        this.start(webappName, "org.eclipse.birt.report.viewer");
    }

    public void start(String webappName, String pluginID) throws Exception {
        this.configureServer(webappName);
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("http.port", this.ports.get(webappName));
        ((Dictionary)dict).put("http.host", this.host);
        ((Dictionary)dict).put("context.path", "/" + webappName);
        ((Dictionary)dict).put("other.info", pluginID);
        JettyConfigurator.startServer((String)webappName, dict);
        this.ensureBundleStarted("org.eclipse.equinox.http.registry");
    }

    public void stop(String webappName) throws Exception {
        JettyConfigurator.stopServer((String)webappName);
    }

    private void ensureBundleStarted(String symbolicName) throws BundleException {
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null && bundle.getState() == 4) {
            bundle.start(1);
        }
    }

    String getHost() {
        return this.host;
    }

    int getPort(String webappName) {
        return this.ports.get(webappName);
    }
}

