/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.birt.report.designer.ui.IReportClasspathResolver;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.viewer.utilities.IWorkspaceClasspathFinder;
import org.eclipse.birt.report.viewer.utilities.WorkspaceClasspathManager;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ViewerClassPathHelper {
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    private static final String FINDER_BUNDLE_NAME = "org.eclipse.birt.report.debug.ui";
    private static final String FINDER_CLASSNAME = "org.eclipse.birt.report.debug.internal.ui.launcher.util.WorkspaceClassPathFinder";
    protected static boolean inDevelopmentMode = false;
    protected static String[] devDefaultClasspath;
    protected static Properties devProperties;
    public static final String PROPERTYSEPARATOR;

    static {
        devProperties = null;
        PROPERTYSEPARATOR = File.pathSeparator;
        String osgiDev = System.getProperty("osgi.dev");
        if (osgiDev != null) {
            try {
                inDevelopmentMode = true;
                URL location = new URL(osgiDev);
                devProperties = ViewerClassPathHelper.load(location);
                if (devProperties != null) {
                    devDefaultClasspath = ViewerClassPathHelper.getArrayFromList(devProperties.getProperty("*"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                devDefaultClasspath = ViewerClassPathHelper.getArrayFromList(osgiDev);
            }
        }
    }

    public static String[] getDevClassPath(String id) {
        String entry;
        String[] result = null;
        if (id != null && devProperties != null && (entry = devProperties.getProperty(id)) != null) {
            result = ViewerClassPathHelper.getArrayFromList(entry);
        }
        if (result == null) {
            result = devDefaultClasspath;
        }
        return result;
    }

    public static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.add(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static Properties load(URL url) {
        Properties props = new Properties();
        try {
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException iOException) {}
        return props;
    }

    public static String getWorkspaceClassPath() {
        Bundle bundle;
        block4: {
            try {
                bundle = Platform.getBundle((String)FINDER_BUNDLE_NAME);
                if (bundle != null && bundle.getState() == 4) {
                    bundle.start(1);
                }
                if (bundle != null) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Class clz = bundle.loadClass(FINDER_CLASSNAME);
        IWorkspaceClasspathFinder finder = (IWorkspaceClasspathFinder)clz.newInstance();
        WorkspaceClasspathManager.registerClassPathFinder(finder);
        return WorkspaceClasspathManager.getClassPath();
    }

    public static URL[] getWorkspaceClassPath(String reportFilePath) {
        String[] classpaths;
        ArrayList<URL> urls = new ArrayList<URL>();
        IReportClasspathResolver provider = ReportPlugin.getDefault().getReportClasspathResolverService();
        if (provider != null && (classpaths = provider.resolveClasspath((Object)reportFilePath)) != null && classpaths.length != 0) {
            int j = 0;
            while (j < classpaths.length) {
                File file = new File(classpaths[j]);
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static URL[] parseURLs(String paths) {
        String[] classpaths;
        ArrayList<URL> urls = new ArrayList<URL>();
        if (paths != null && paths.trim().length() > 0 && (classpaths = paths.split(PROPERTYSEPARATOR, -1)) != null && classpaths.length != 0) {
            int j = 0;
            while (j < classpaths.length) {
                File file = new File(classpaths[j]);
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        URL[] oUrls = new URL[urls.size()];
        urls.toArray(oUrls);
        return oUrls;
    }
}

