/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipFileLoadStrategyImpl;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.util.ArtifactEditRegistryReader;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EARComponentLoadStrategyImpl
extends ComponentLoadStrategyImpl {
    private List artifactEditsToDispose = new ArrayList();
    private List<Archive> archivesToClose = new ArrayList<Archive>();
    private Map binaryComponentURIsToDiskFileMap = new HashMap();

    public EARComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
    }

    public EARComponentLoadStrategyImpl(IVirtualComponent vComponent, boolean includeClasspathComponents) {
        super(vComponent, includeClasspathComponents);
    }

    public List getFiles() {
        this.aggregateSourceFiles();
        this.addModulesAndUtilities();
        return this.filesHolder.getFiles();
    }

    protected synchronized ArtifactEdit getArtifactEditForRead() {
        if (this.artifactEdit == null) {
            this.artifactEdit = EARArtifactEdit.getEARArtifactEditForRead(this.vComponent);
        }
        return this.artifactEdit;
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        if (this.binaryComponentURIsToDiskFileMap.containsKey(uri)) {
            File diskFile = (File)this.binaryComponentURIsToDiskFileMap.get(uri);
            return new FileInputStream(diskFile);
        }
        return super.getInputStream(uri);
    }

    public void addModulesAndUtilities() {
        EARArtifactEdit earArtifactEdit = null;
        try {
            earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead(this.vComponent);
            IVirtualReference[] components = earArtifactEdit.getComponentReferences();
            int i = 0;
            while (i < components.length) {
                boolean isModule;
                File diskFile;
                IVirtualComponent referencedComponent;
                IVirtualReference reference;
                block34: {
                    reference = components[i];
                    referencedComponent = reference.getReferencedComponent();
                    diskFile = null;
                    boolean forceUtility = false;
                    if (referencedComponent.isBinary()) {
                        IFile wbFile;
                        JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(referencedComponent);
                        int jeeVersion = qp.getJavaEEVersion();
                        if (jeeVersion == 50) {
                            forceUtility = true;
                        }
                        if (!(diskFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingDiskFile()).exists() && (wbFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingWorkbenchFile()) != null && wbFile.exists()) {
                            diskFile = new File(wbFile.getLocation().toOSString());
                        }
                    }
                    isModule = false;
                    if (!forceUtility) {
                        boolean addClasspathComponentDependencies = false;
                        AppClientArtifactEdit componentArtifactEdit = null;
                        try {
                            try {
                                if (J2EEProjectUtilities.isApplicationClientComponent(referencedComponent)) {
                                    componentArtifactEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead(referencedComponent);
                                } else if (J2EEProjectUtilities.isEJBComponent(referencedComponent)) {
                                    addClasspathComponentDependencies = true;
                                    componentArtifactEdit = ArtifactEditRegistryReader.instance().getArtifactEdit("jst.ejb").createArtifactEditForRead(referencedComponent);
                                } else if (J2EEProjectUtilities.isDynamicWebComponent(referencedComponent)) {
                                    addClasspathComponentDependencies = true;
                                    componentArtifactEdit = ArtifactEditRegistryReader.instance().getArtifactEdit("jst.web").createArtifactEditForRead(referencedComponent);
                                } else if (J2EEProjectUtilities.isJCAComponent(referencedComponent)) {
                                    addClasspathComponentDependencies = true;
                                    componentArtifactEdit = ArtifactEditRegistryReader.instance().getArtifactEdit("jst.connector").createArtifactEditForRead(referencedComponent);
                                }
                                if (componentArtifactEdit != null) {
                                    Archive archive = ((EnterpriseArtifactEdit)componentArtifactEdit).asArchive(this.exportSource, this.includeClasspathComponents);
                                    if (referencedComponent.isBinary()) {
                                        this.artifactEditsToDispose.add(componentArtifactEdit);
                                        archive.setLoadingContainer(this.getContainer());
                                        this.binaryComponentURIsToDiskFileMap.put(archive.getOriginalURI(), diskFile);
                                    }
                                    archive.setURI(earArtifactEdit.getModuleURI(referencedComponent));
                                    this.filesHolder.addFile((org.eclipse.jst.j2ee.commonarchivecore.internal.File)archive);
                                    isModule = true;
                                    if (addClasspathComponentDependencies) {
                                        this.addClasspathComponentDependencies(referencedComponent);
                                    }
                                    this.archivesToClose.add(archive);
                                }
                            }
                            catch (OpenFailureException oe) {
                                Logger.getLogger().logError((Throwable)oe);
                                if (!referencedComponent.isBinary() && componentArtifactEdit != null) {
                                    componentArtifactEdit.dispose();
                                }
                                break block34;
                            }
                        }
                        catch (Throwable throwable) {
                            if (!referencedComponent.isBinary() && componentArtifactEdit != null) {
                                componentArtifactEdit.dispose();
                            }
                            throw throwable;
                        }
                        if (!referencedComponent.isBinary() && componentArtifactEdit != null) {
                            componentArtifactEdit.dispose();
                        }
                    }
                }
                if (!isModule) {
                    if (referencedComponent.isBinary()) {
                        String uri = reference.getArchiveName();
                        this.addExternalFile(uri, diskFile);
                    } else if (J2EEProjectUtilities.isUtilityProject(referencedComponent.getProject())) {
                        try {
                            if (!referencedComponent.isBinary()) {
                                String uri = earArtifactEdit.getModuleURI(referencedComponent);
                                Archive archive = J2EEProjectUtilities.asArchive(uri, referencedComponent.getProject(), this.exportSource, this.includeClasspathComponents);
                                archive.setURI(uri);
                                this.filesHolder.addFile((org.eclipse.jst.j2ee.commonarchivecore.internal.File)archive);
                                this.addClasspathComponentDependencies(referencedComponent);
                            }
                        }
                        catch (OpenFailureException e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (earArtifactEdit != null) {
                earArtifactEdit.dispose();
            }
        }
    }

    private void addClasspathComponentDependencies(IVirtualComponent referencedComponent) {
        if (this.includeClasspathComponents && referencedComponent instanceof J2EEModuleVirtualComponent) {
            IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)referencedComponent).getJavaClasspathReferences();
            int j = 0;
            while (j < cpRefs.length) {
                IVirtualReference ref = cpRefs[j];
                if (ref.getRuntimePath().equals((Object)IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH) && ref.getReferencedComponent() instanceof ClasspathDependencyVirtualComponent) {
                    ClasspathDependencyVirtualComponent comp = (ClasspathDependencyVirtualComponent)ref.getReferencedComponent();
                    File cpEntryFile = comp.getUnderlyingDiskFile();
                    if (!cpEntryFile.exists()) {
                        IFile wbFile = comp.getUnderlyingWorkbenchFile();
                        cpEntryFile = new File(wbFile.getLocation().toOSString());
                    }
                    this.addExternalFile(ref.getArchiveName(), cpEntryFile);
                }
                ++j;
            }
        }
    }

    public void close() {
        super.close();
        for (ArtifactEdit edit : this.artifactEditsToDispose) {
            edit.dispose();
        }
        this.artifactEditsToDispose.clear();
        for (Archive archive : this.archivesToClose) {
            archive.close();
        }
        this.archivesToClose.clear();
    }

    public ZipFileLoadStrategyImpl createLoadStrategy(String uri) throws FileNotFoundException, IOException {
        String filename = uri.replace('/', File.separatorChar);
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString((String)CommonArchiveResourceHandler.file_not_found_EXC_, (Object[])new Object[]{uri, file.getAbsolutePath()}));
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException(CommonArchiveResourceHandler.getString((String)CommonArchiveResourceHandler.file_not_found_EXC_, (Object[])new Object[]{uri, file.getAbsolutePath()}));
        }
        return new ZipFileLoadStrategyImpl(file);
    }
}

