/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectAccessor
extends RelationshipAccessor {
    private Boolean m_isOptional;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();

    protected ObjectAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected ObjectAccessor(Annotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        Object primaryKeyJoinColumn;
        this.m_isOptional = annotation == null ? true : (Boolean)MetadataHelper.invokeMethod("optional", annotation);
        Object primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class);
        if (primaryKeyJoinColumns != null) {
            for (Annotation primaryKeyJoinColumn2 : (Annotation[])MetadataHelper.invokeMethod("value", primaryKeyJoinColumns)) {
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata(primaryKeyJoinColumn2, accessibleObject));
            }
        }
        if ((primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
            this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((Annotation)primaryKeyJoinColumn, accessibleObject));
        }
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    public Boolean getOptional() {
        return this.m_isOptional;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = super.getReferenceClass();
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    protected OneToOneMapping initOneToOneMapping() {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(this.isPrivateOwned());
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        mapping.setIsOptional(this.isOptional());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        this.processIndirection((ObjectReferenceMapping)mapping);
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processCascadeTypes((ForeignReferenceMapping)mapping);
        this.processReturnInsertAndUpdate();
        return mapping;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && !this.m_primaryKeyJoinColumns.isEmpty();
    }

    public boolean isOptional() {
        if (this.m_isOptional == null) {
            return true;
        }
        return this.m_isOptional;
    }

    protected void processIndirection(ObjectReferenceMapping mapping) {
        boolean usesIndirection = this.usesIndirection();
        if (usesIndirection && !this.getProject().isWeavingEnabled() && !ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            usesIndirection = false;
        }
        if (usesIndirection && this.usesPropertyAccess(this.getDescriptor())) {
            mapping.setIndirectionPolicy((IndirectionPolicy)new WeavedObjectBasicIndirectionPolicy(this.getSetMethodName()));
        } else {
            mapping.setUsesIndirection(usesIndirection);
        }
        mapping.setIsLazy(this.isLazy());
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping) {
        String defaultPKFieldName = this.getReferenceDescriptor().getPrimaryKeyFieldName();
        String defaultFKFieldName = this.getUpperCaseAttributeName() + "_" + defaultPKFieldName;
        for (JoinColumnMetadata joinColumn : this.processJoinColumns()) {
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, "metadata_default_pk_column"));
            pkField.setTable(this.getReferenceDescriptor().getPrimaryKeyTable());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, defaultFKFieldName, "metadata_default_fk_column"));
            if (fkField.getTableName().equals("")) {
                fkField.setTable(this.getDescriptor().getPrimaryTable());
            }
            mapping.addForeignKeyField(fkField, pkField);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping mapping) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns()));
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : pkJoinColumns) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, referenceDescriptor.getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            pkField.setTable(referenceDescriptor.getPrimaryTable());
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            fkField.setTable(this.getDescriptor().getPrimaryTable());
            mapping.addForeignKeyField(fkField, pkField);
            mapping.setIsReadOnly(true);
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(mapping);
        } else {
            this.processOneToOneForeignKeyRelationship(mapping);
        }
    }

    public void setOptional(Boolean isOptional) {
        this.m_isOptional = isOptional;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

