/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.osgi.util.NLS;

public abstract class QueryableRepositoryManager
implements IQueryable {
    private ArrayList notFound = new ArrayList();
    private HashMap loaded = new HashMap();
    private MultiStatus accumulatedNotFound = null;
    protected boolean includeDisabledRepos;
    protected IUViewQueryContext queryContext;

    public QueryableRepositoryManager(IUViewQueryContext queryContext, boolean includeDisabledRepos) {
        this.includeDisabledRepos = includeDisabledRepos;
        Assert.isNotNull((Object)queryContext);
        this.queryContext = queryContext;
    }

    public Collector query(Query query, Collector result, IProgressMonitor monitor) {
        IRepositoryManager manager = this.getRepositoryManager();
        if (manager == null) {
            ProvUI.reportStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager), 3);
            return result;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.query(this.getRepoLocations(manager), query, result, monitor);
        this.reportAccumulatedStatus();
        return result;
    }

    public void loadAll(IProgressMonitor monitor) {
        IRepositoryManager manager = this.getRepositoryManager();
        if (manager == null) {
            ProvUI.reportStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager), 3);
            return;
        }
        URI[] repoLocations = this.getRepoLocations(manager);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repoLocations.length * 100));
        if (sub.isCanceled()) {
            return;
        }
        int i = 0;
        while (i < repoLocations.length) {
            if (sub.isCanceled()) {
                return;
            }
            try {
                this.loadRepository(manager, repoLocations[i], (IProgressMonitor)sub.newChild(100));
            }
            catch (ProvisionException e) {
                this.handleLoadFailure(e, repoLocations[i]);
            }
            ++i;
        }
    }

    protected abstract URI[] getRepoLocations(IRepositoryManager var1);

    protected void handleLoadFailure(ProvisionException e, URI problemRepo) {
        IStatus status;
        int code = e.getStatus().getCode();
        if (code == 1000 || code == 1006) {
            this.loaded.remove(problemRepo);
            if (this.notFound.contains(problemRepo)) {
                return;
            }
            if (ProvUI.hasNotFoundStatusBeenReported(problemRepo)) {
                this.notFound.add(problemRepo);
                return;
            }
            this.notFound.add(problemRepo);
            ProvUI.notFoundStatusReported(problemRepo);
        }
        if ((status = e.getStatus()) instanceof MultiStatus && ((MultiStatus)status).getChildren().length == 0) {
            status = new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        }
        if (this.accumulatedNotFound == null) {
            this.accumulatedNotFound = new MultiStatus("org.eclipse.equinox.p2.ui", 1000, new IStatus[]{status}, ProvUIMessages.QueryableMetadataRepositoryManager_MultipleRepositoriesNotFound, null);
        } else {
            this.accumulatedNotFound.add(status);
        }
        ProvUI.handleException(e, NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, (Object)problemRepo), 1);
    }

    public void reportAccumulatedStatus() {
        if (this.accumulatedNotFound != null) {
            if (this.accumulatedNotFound.getChildren().length == 1) {
                ProvUI.reportStatus(this.accumulatedNotFound.getChildren()[0], 2);
            } else {
                ProvUI.reportStatus((IStatus)this.accumulatedNotFound, 2);
            }
        }
        this.accumulatedNotFound = null;
    }

    public boolean areRepositoriesLoaded() {
        IRepositoryManager mgr = this.getRepositoryManager();
        if (mgr == null) {
            return false;
        }
        URI[] repoURIs = this.getRepoLocations(mgr);
        int i = 0;
        while (i < repoURIs.length) {
            IRepository repo = this.getRepository(mgr, repoURIs[i]);
            if (repo == null && !ProvUI.hasNotFoundStatusBeenReported(repoURIs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected IRepository loadRepository(IRepositoryManager manager, URI location, IProgressMonitor monitor) throws ProvisionException {
        monitor.setTaskName(NLS.bind((String)ProvUIMessages.QueryableMetadataRepositoryManager_LoadRepositoryProgress, (Object)URIUtil.toUnencodedString((URI)location)));
        IRepository repo = this.doLoadRepository(manager, location, monitor);
        if (repo != null) {
            this.loaded.put(location, repo);
        }
        return repo;
    }

    protected abstract IRepositoryManager getRepositoryManager();

    protected IRepository getRepository(IRepositoryManager manager, URI location) {
        return (IRepository)this.loaded.get(location);
    }

    protected abstract IRepository doLoadRepository(IRepositoryManager var1, URI var2, IProgressMonitor var3) throws ProvisionException;

    protected abstract Collector query(URI[] var1, Query var2, Collector var3, IProgressMonitor var4);

    public void setQueryContext(IUViewQueryContext queryContext) {
        this.queryContext = queryContext;
    }
}

