/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetComputedColumnsPage;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetOutputColumnsPage;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetSettingsPage;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedOutputColumnDefnPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetDataSourceSelectionPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetFiltersPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetParametersPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.ExternalUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.HistoryToolBar;
import org.eclipse.birt.report.designer.data.ui.dataset.JointDataSetPage;
import org.eclipse.birt.report.designer.data.ui.dataset.OutputParameterPreviewPage;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyPageWrapper;
import org.eclipse.birt.report.designer.data.ui.dataset.ResultSetPreviewPage;
import org.eclipse.birt.report.designer.data.ui.datasource.PropertyBindingPage;
import org.eclipse.birt.report.designer.data.ui.property.AbstractPropertyDialog;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.PageLayoutManager;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSetDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetEditorPage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetEditor
extends AbstractPropertyDialog
implements IPreferencePageContainer {
    protected ItemModelManager itemModelManager;
    private DataSetDesignSession m_designSession = null;
    protected boolean includeInputParameterPage = false;
    protected boolean includeOutputParameterPage = false;
    protected boolean needToFocusOnOutput = false;
    private transient HistoryToolBar historyBar;
    protected static final String DATASET_SETTINGS_PAGE = "org.eclipse.birt.datasource.editor.dataset.settings";
    protected static final String OUTPUT_PARAMETER_PREVIEW_PAGE = "org.eclipse.birt.datasource.editor.dataset.outputparameterpreviewpage";
    protected static final String DATASOURCE_EDITOR_PROPERTY_PAGE = "org.eclipse.birt.datasource.editor.property";
    protected static final String COMPUTED_COLUMNS_PAGE = "org.eclipse.birt.datasource.editor.dataset.computedcolumnspage";
    protected static final String RESULTSET_PREVIEW_PAGE = "org.eclipse.birt.datasource.editor.dataset.resultsetpreviewpage";
    protected static final String FILTERS_PAGE = "org.eclipse.birt.datasource.editor.dataset.filterspage";
    protected static final String PARAMETERS_PAGE = "org.eclipse.birt.datasource.editor.dataset.parameterspage";
    protected static final String OUTPUTCOLUMN_PAGE = "org.eclipse.birt.datasource.editor.dataset.outputcolumnpage";
    protected static final String JOINT_DATA_SET_PAGE = "org.eclipse.birt.datasource.editor.dataset.jointDataSetPage";
    protected static final String DATA_SOURCE_SELECTION_PAGE = "org.eclipse.birt.datasource.editor.dataset.datasourceselectionpage";
    private static Logger logger = Logger.getLogger(DataSetEditor.class.getName());

    static {
        Iterator<String> pageNames = DataSetEditor.getInternalPageNames().iterator();
        while (pageNames.hasNext()) {
            PageLayoutManager.registerPage(pageNames.next());
        }
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.DataSetEditor_ID");
        return super.createDialogArea(parent);
    }

    protected boolean needRememberLastSize() {
        return true;
    }

    public DataSetEditor(Shell parentShell, DataSetHandle ds, boolean needToFocusOnOutput) {
        super(parentShell, (Object)ds);
        String dataSetType;
        String dataSourceType;
        ExternalUIUtil.validateDataSetHandle(ds);
        this.initModelManager();
        this.needToFocusOnOutput = needToFocusOnOutput;
        if (ds instanceof OdaDataSetHandle) {
            OdaDataSourceHandle dataSource = (OdaDataSourceHandle)((OdaDataSetHandle)ds).getDataSource();
            dataSourceType = dataSource.getExtensionID();
            dataSetType = ((OdaDataSetHandle)ds).getExtensionID();
        } else if (ds instanceof ScriptDataSetHandle) {
            dataSourceType = "script";
            dataSetType = "ScriptSelectDataSet";
        } else if (ds instanceof JointDataSetHandle) {
            dataSourceType = "";
            dataSetType = "";
        } else {
            dataSourceType = ExternalUIUtil.getDataSourceType(ds);
            dataSetType = ExternalUIUtil.getDataSetType(ds);
        }
        boolean containsDataSource = ExternalUIUtil.containsDataSource(ds);
        if (containsDataSource) {
            this.addPageTo("/", DATA_SOURCE_SELECTION_PAGE, Messages.getString((String)"dataset.editor.dataSource"), null, (IPropertyPage)new DataSetDataSourceSelectionPage());
            if (DesignSessionUtil.hasValidOdaDesignUIExtension((String)dataSourceType)) {
                this.addCustomPageODAV3((OdaDataSetHandle)ds, dataSourceType, dataSetType);
            } else {
                this.addBirtPage(dataSourceType, dataSetType);
            }
        }
        this.addCommonPages(ds);
        this.setPageFocus();
        this.itemModelManager.start(ds);
    }

    protected void initModelManager() {
        this.itemModelManager = new ItemModelManager();
    }

    private void addCustomPageODAV3(OdaDataSetHandle dataSetHandle, String dataSourceType, String dataSetType) {
        try {
            DesignSessionRequest request = DTPUtil.getInstance().createDesignSessionRequest(dataSetHandle);
            if (request != null && request.getDataSourceDesign() != null) {
                DTPUtil.getInstance().applyResourceIdentifiers(request.getDataSourceDesign());
            }
            this.m_designSession = DataSetDesignSession.startEditDesign((DesignSessionRequest)request);
            this.includeInputParameterPage = UIManifestExplorer.getInstance().getDataSetUIElement(dataSourceType, dataSetType).supportsInParameters();
            this.includeOutputParameterPage = UIManifestExplorer.getInstance().getDataSetUIElement(dataSourceType, dataSetType).supportsOutParameters();
        }
        catch (OdaException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (URISyntaxException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.m_designSession != null) {
            this.populateEditorPage(this.m_designSession);
        }
    }

    private void populateEditorPage(DataSetDesignSession m_designSession) {
        try {
            DataSetEditorPage[] dataSetEditorPages = m_designSession.getEditorPages();
            int i = 0;
            while (i < dataSetEditorPages.length) {
                DataSetEditorPage dataSetEditorPage = dataSetEditorPages[i];
                PropertyPageWrapper propertyPageWrapper = new PropertyPageWrapper((PropertyPage)dataSetEditorPage, m_designSession);
                this.addPageTo(dataSetEditorPage.getPagePath(), dataSetEditorPage.getPageId(), dataSetEditorPage.getTitle(), null, (IPropertyPage)propertyPageWrapper);
                if (dataSetEditorPage.hasInitialFocus()) {
                    this.setDefaultNode(dataSetEditorPage.getPageId());
                }
                ++i;
            }
        }
        catch (OdaException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    protected void addCommonPages(DataSetHandle ds) {
        if (ds instanceof ScriptDataSetHandle) {
            this.addScriptOutputColumnDefnPage();
            this.addParametersPage();
            this.addFiltersPage();
            this.addDataSetSettingPage(ds);
            this.addResultSetPreviewPage();
        } else if (ds instanceof OdaDataSetHandle) {
            this.addOutputColumnsPage();
            this.addComputedColumnsPage();
            if (this.includeInputParameterPage) {
                this.addParametersPage();
            }
            this.addDataSetFilterPage();
            this.addPropertyBindingPage();
            this.addDataSetSettingPage(ds);
            if (this.includeOutputParameterPage) {
                this.addOutputParameterPreviewPage();
            }
            this.addResultSetPreviewPage();
        } else if (ds instanceof JointDataSetHandle) {
            this.addJointDataSetPage();
            this.addOutputColumnsPage();
            this.addComputedColumnsPage();
            this.addParametersPage();
            this.addFiltersPage();
            this.addResultSetPreviewPage();
        } else {
            IPropertyPage[] pages = ExternalUIUtil.getCommonPages(ds);
            if (pages != null && pages.length > 0) {
                int i = 0;
                while (i < pages.length) {
                    this.addPageTo("/", pages[i].getClass().getName(), pages[i].getName(), null, pages[i]);
                    ++i;
                }
                if (!this.needToFocusOnOutput && pages.length > 0) {
                    this.setDefaultNode(pages[0].getClass().getName());
                }
                this.addOutputColumnsPage();
                if (ExternalUIUtil.needUtilityPages(ds)) {
                    this.addComputedColumnsPage();
                    this.addParametersPage();
                    this.addFiltersPage();
                }
                this.addResultSetPreviewPage();
            }
        }
    }

    protected void addDataSetFilterPage() {
        DataSetFiltersPage filterpage = new DataSetFiltersPage();
        try {
            filterpage = (IPropertyPage)Class.forName("org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetFiltersPage").newInstance();
        }
        catch (Throwable throwable) {}
        this.addPageTo("/", FILTERS_PAGE, Messages.getString((String)"dataset.editor.filters"), null, (IPropertyPage)filterpage);
    }

    protected void addOutputParameterPreviewPage() {
        this.addPageTo("/", OUTPUT_PARAMETER_PREVIEW_PAGE, Messages.getString((String)"dataset.editor.outputparameters"), null, (IPropertyPage)new OutputParameterPreviewPage());
    }

    protected void addComputedColumnsPage() {
        this.addPageTo("/", COMPUTED_COLUMNS_PAGE, Messages.getString((String)"dataset.editor.computedColumns"), null, (IPropertyPage)new AdvancedDataSetComputedColumnsPage());
    }

    protected void addResultSetPreviewPage() {
        this.addPageTo("/", RESULTSET_PREVIEW_PAGE, Messages.getString((String)"dataset.editor.preview"), null, (IPropertyPage)new ResultSetPreviewPage());
    }

    protected void addFiltersPage() {
        this.addPageTo("/", FILTERS_PAGE, Messages.getString((String)"dataset.editor.filters"), null, (IPropertyPage)new DataSetFiltersPage());
    }

    protected void addParametersPage() {
        this.addPageTo("/", PARAMETERS_PAGE, Messages.getString((String)"dataset.editor.parameters"), null, (IPropertyPage)new DataSetParametersPage());
    }

    protected void addScriptOutputColumnDefnPage() {
        this.addPageTo("/", OUTPUTCOLUMN_PAGE, Messages.getString((String)"dataset.editor.outputColumns"), null, (IPropertyPage)new AdvancedOutputColumnDefnPage());
    }

    protected void addOutputColumnsPage() {
        this.addPageTo("/", OUTPUTCOLUMN_PAGE, Messages.getString((String)"dataset.editor.outputColumns"), null, (IPropertyPage)new AdvancedDataSetOutputColumnsPage());
    }

    protected void addJointDataSetPage() {
        this.addPageTo("/", JOINT_DATA_SET_PAGE, Messages.getString((String)"JointDataSetPage.query"), null, new JointDataSetPage(Messages.getString((String)"dataset.editor.dataSource")));
    }

    protected void addPropertyBindingPage() {
        this.addPageTo("/", DATASOURCE_EDITOR_PROPERTY_PAGE, Messages.getString((String)"datasource.editor.property"), null, (IPropertyPage)new PropertyBindingPage());
    }

    private void setPageFocus() {
        if (this.needToFocusOnOutput) {
            this.setDefaultNode(OUTPUTCOLUMN_PAGE);
        }
    }

    private void addBirtPage(String dataSourceType, String dataSetType) {
        try {
            IConfigurationElement element = DataSetProvider.findDataSetElement((String)dataSetType, (String)dataSourceType);
            if (element != null) {
                IConfigurationElement[] editorPages;
                String supportParameterPage = element.getAttribute("addsDataSetParametersPage");
                if (supportParameterPage != null) {
                    this.includeInputParameterPage = Boolean.valueOf(supportParameterPage);
                }
                if ((editorPages = element.getChildren("dataSetEditorPage")) != null) {
                    boolean hasFocus = false;
                    int n = 0;
                    while (n < editorPages.length) {
                        IPropertyPage page = (IPropertyPage)editorPages[n].createExecutableExtension("class");
                        this.addPageTo(editorPages[n].getAttribute("path"), editorPages[n].getAttribute("name"), editorPages[n].getAttribute("displayName"), null, page);
                        if (!hasFocus) {
                            String initFocusAttr = editorPages[n].getAttribute("initFocus");
                            if (initFocusAttr != null && initFocusAttr.equalsIgnoreCase("true")) {
                                this.setDefaultNode(editorPages[n].getAttribute("name"));
                                hasFocus = true;
                            } else if (n == editorPages.length - 1) {
                                this.setDefaultNode(editorPages[0].getAttribute("name"));
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        catch (CoreException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    protected void addDataSetSettingPage(DataSetHandle ds) {
        AdvancedDataSetSettingsPage settingPage = new AdvancedDataSetSettingsPage();
        this.addPageTo("/", DATASET_SETTINGS_PAGE, Messages.getString((String)"dataset.editor.settings"), null, (IPropertyPage)settingPage);
    }

    public boolean performOk() {
        try {
            if (this.m_designSession != null) {
                this.m_designSession.finish();
            }
        }
        catch (OdaException odaException) {}
        this.itemModelManager.destory(false);
        return true;
    }

    public void updateDataSetDesign(IPropertyPage page) {
        try {
            if (this.getCurrentNode() != null && this.getCurrentNode().getPage() != page) {
                return;
            }
            if (this.m_designSession != null) {
                boolean hasResetEditorPages;
                DesignSessionRequest request = DTPUtil.getInstance().createDesignSessionRequest((OdaDataSetHandle)this.getHandle());
                if (request != null && request.getDataSourceDesign() != null) {
                    DTPUtil.getInstance().applyResourceIdentifiers(request.getDataSourceDesign());
                }
                if (hasResetEditorPages = this.m_designSession.restartEditDesign(request, false)) {
                    this.populateDataSetEditor();
                }
            }
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public boolean performCancel() {
        if (this.m_designSession != null) {
            this.m_designSession.cancel();
        }
        this.itemModelManager.destory(true);
        return true;
    }

    public DataSetHandle getHandle() {
        return (DataSetHandle)this.getModel();
    }

    protected Control createContents(Composite parent) {
        String title = Messages.getFormattedString((String)"dataset.edit", (Object[])new String[]{this.getHandle().getName()});
        this.getShell().setText(title);
        Control control = super.createContents(parent);
        this.setPageHelpContent(control);
        return control;
    }

    protected void setPageHelpContent(Control control) {
        Utility.setSystemHelp((Control)control, (String)"org.eclipse.birt.cshelp.Dialog_DatasetEdit_ID");
    }

    public DataSetViewData[] getCurrentItemModel() {
        return this.itemModelManager.getCurrentItemModel(true, true);
    }

    public DataSetViewData[] getCurrentItemModel(boolean useColumnHint, boolean suppressErrorMessage) {
        return this.itemModelManager.getCurrentItemModel(useColumnHint, suppressErrorMessage);
    }

    public void enableLinkedParamChanged() {
        this.itemModelManager.enableLinkedParamChanged();
    }

    public boolean modelChanged() {
        return this.itemModelManager.modelChanged();
    }

    public DataSetDesign getCurrentDataSetDesign() throws OdaException {
        if (this.m_designSession != null) {
            DesignSessionResponse response = this.m_designSession.flush().getResponse();
            if (response.getSessionStatus() != SessionStatus.OK_LITERAL) {
                return null;
            }
            DataSetDesign dataSetDesign = response.getDataSetDesign();
            return dataSetDesign;
        }
        return null;
    }

    protected void okPressed() {
        super.okPressed();
        try {
            DataSetUIUtil.updateColumnCache((DataSetHandle)this.getHandle());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            int n = 0;
            while (n < nodes.length) {
                if (nodes[n].getPage() instanceof DataSetParametersPage) {
                    if (this.viewer == null && this.viewer.getTree() == null) {
                        return;
                    }
                    DataSetParametersPage page = (DataSetParametersPage)nodes[n].getPage();
                    if (!page.canFinish() && !this.viewer.getTree().isDisposed()) {
                        TreeItem firstNode = this.viewer.getTree().getItems()[n];
                        StructuredSelection select = new StructuredSelection(firstNode.getData());
                        this.viewer.setSelection((ISelection)select);
                        String name = ((DataSetParametersPage)nodes[n].getPage()).getNoneValuedParameterName();
                        this.setMessage(Messages.getFormattedString((String)"dataset.editor.error.noInputParameterDefaultValue", (Object[])new Object[]{name}), 3);
                        return;
                    }
                }
                ++n;
            }
        }
    }

    private PropertyPage getCurrentPropertyPage() {
        IPropertyPage ipropertyPage;
        if (this.getCurrentNode() != null && (ipropertyPage = this.getCurrentNode().getPage()) instanceof PropertyPageWrapper) {
            return ((PropertyPageWrapper)ipropertyPage).getPropertyPage();
        }
        return null;
    }

    private void populateDataSetEditor() {
        DataSetEditorPage[] dataSetEditorPages;
        if (this.m_designSession == null) {
            return;
        }
        try {
            dataSetEditorPages = this.m_designSession.getEditorPages();
        }
        catch (OdaException odaException) {
            return;
        }
        PropertyPageWrapper currentNode = null;
        int i = 0;
        while (i < dataSetEditorPages.length) {
            DataSetEditorPage dataSetEditorPage = dataSetEditorPages[i];
            PropertyPageWrapper propertyPageWrapper = new PropertyPageWrapper((PropertyPage)dataSetEditorPage, this.m_designSession);
            if (this.rootNode.hasSubNodes()) {
                PropertyNode[] nodes = this.rootNode.getSubNodes();
                int n = 0;
                while (n < nodes.length) {
                    if (nodes[n] != null && nodes[n].getId().equals(dataSetEditorPage.getPageId())) {
                        nodes[n].removePageControl();
                        nodes[n].setPage((IPropertyPage)propertyPageWrapper);
                        nodes[n].setContainer((IPropertyPageContainer)this);
                        if (!this.getCurrentNode().getId().equals(dataSetEditorPage.getPageId())) break;
                        currentNode = propertyPageWrapper;
                        break;
                    }
                    ++n;
                }
            }
            ++i;
        }
        if (currentNode != null) {
            this.rootNode.setPage(currentNode);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
        PropertyPage propertyPage = this.getCurrentPropertyPage();
        if (propertyPage != null && this.getOkButton() != null) {
            this.getOkButton().setEnabled(propertyPage.okToLeave());
        }
    }

    public void updateOKButtonStatus(boolean isEnabled) {
        this.getOkButton().setEnabled(isEnabled);
    }

    public void updateMessage() {
        PropertyPage propertyPage = this.getCurrentPropertyPage();
        if (propertyPage != null) {
            this.setMessage(propertyPage.getMessage(), propertyPage.getMessageType());
        }
    }

    public void updateTitle() {
    }

    public Composite createTitleArea(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.createMessageComposite(parent);
        this.createToolbarComposite(parent);
        return null;
    }

    private void createMessageComposite(Composite parent) {
        super.createTitleArea(parent);
    }

    private void createToolbarComposite(Composite parent) {
        this.historyBar = new HistoryToolBar(parent, this.viewer, 0x800100);
    }

    public void showSelectionPage(PropertyNode selectedNode) {
        super.showSelectionPage(selectedNode);
        if (this.showPage) {
            if (this.historyBar != null) {
                this.historyBar.addHistoryNode(selectedNode);
            }
            if (!PageLayoutManager.isRegisteredPage(selectedNode.getId())) {
                this.getShell().pack();
            }
        }
    }

    public boolean supportsInParameters() {
        return this.includeInputParameterPage;
    }

    public boolean supportsOutputParameters() {
        return this.includeOutputParameterPage;
    }

    protected static Set<String> getInternalPageNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(DATASET_SETTINGS_PAGE);
        result.add(OUTPUT_PARAMETER_PREVIEW_PAGE);
        result.add(DATASOURCE_EDITOR_PROPERTY_PAGE);
        result.add(COMPUTED_COLUMNS_PAGE);
        result.add(RESULTSET_PREVIEW_PAGE);
        result.add(FILTERS_PAGE);
        result.add(PARAMETERS_PAGE);
        result.add(OUTPUTCOLUMN_PAGE);
        result.add(JOINT_DATA_SET_PAGE);
        result.add(DATA_SOURCE_SELECTION_PAGE);
        String extensionName = "org.eclipse.datatools.connectivity.oda.design.ui.dataSource";
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(extensionName);
        if (extPoint == null) {
            return result;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return result;
        }
        int e = 0;
        while (e < exts.length) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems != null) {
                int i = 0;
                while (i < configElems.length) {
                    IConfigurationElement[] elems;
                    if (configElems[i].getName().equals("dataSetUI") && (elems = configElems[i].getChildren("dataSetPage")) != null && elems.length > 0) {
                        int j = 0;
                        while (j < elems.length) {
                            String value = elems[j].getAttribute("id");
                            if (value != null) {
                                result.add(value);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++e;
        }
        return result;
    }

    protected static class ItemModelManager
    implements Listener {
        protected DataSetHandle ds = null;
        protected boolean itemModelChanged = true;
        protected boolean linkedParameterChanged = true;
        protected DataSetViewData[] savedItemModel = null;
        protected String savedQueryText = null;
        protected ClassLoader oldContextLoader = null;

        protected ItemModelManager() {
        }

        public void start(DataSetHandle dataSet) {
            assert (dataSet != null);
            this.ds = dataSet;
            if (this.ds instanceof OdaDataSetHandle) {
                this.savedQueryText = ((OdaDataSetHandle)this.ds).getQueryText();
            }
            this.setContextLoader(dataSet);
            this.savedItemModel = DataSetProvider.getCurrentInstance().getCachedDataSetItemModel(this.ds);
            this.ds.addListener((Listener)this);
        }

        protected void setContextLoader(DataSetHandle dataSet) {
            this.oldContextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader parentLoader = this.oldContextLoader;
            if (parentLoader == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)dataSet.getModuleHandle());
            Thread.currentThread().setContextClassLoader(newContextLoader);
        }

        public void destory(boolean rollback) {
            if (rollback) {
                if (this.ds instanceof OdaDataSetHandle) {
                    try {
                        ((OdaDataSetHandle)this.ds).setQueryText(this.savedQueryText);
                        DataSetProvider.getCurrentInstance().getDataSetDesign(this.ds, true, true);
                    }
                    catch (SemanticException semanticException) {
                    }
                    catch (BirtException birtException) {}
                }
                DataSetProvider.getCurrentInstance().setModelOfDataSetHandle(this.ds, this.savedItemModel);
            }
            Thread.currentThread().setContextClassLoader(this.oldContextLoader);
            if (this.ds != null) {
                this.ds.removeListener((Listener)this);
            }
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.itemModelChanged = true;
        }

        public void enableLinkedParamChanged() {
            this.linkedParameterChanged = true;
        }

        public boolean modelChanged() {
            return this.itemModelChanged || this.linkedParameterChanged;
        }

        public DataSetViewData[] getCurrentItemModel() {
            DataSetViewData[] dataSetItem = DataSetProvider.getCurrentInstance().getColumns(this.ds, this.itemModelChanged);
            this.itemModelChanged = false;
            this.linkedParameterChanged = false;
            return dataSetItem;
        }

        public DataSetViewData[] getCurrentItemModel(boolean useColumnHint, boolean suppressErrorMessage) {
            DataSetViewData[] dataSetItem = DataSetProvider.getCurrentInstance().getColumns(this.ds, this.itemModelChanged, useColumnHint, suppressErrorMessage);
            this.itemModelChanged = false;
            this.linkedParameterChanged = false;
            return dataSetItem;
        }
    }
}

