/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.JointDataSetPage;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

public class JointDataSetWizard
extends Wizard {
    private static final String CREATE_DATA_SET_TRANS_NAME = Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create");
    private transient boolean useTransaction = true;
    private WizardPage dataSetPage;

    public JointDataSetWizard() {
        this((DataSourceHandle)null, true);
    }

    public JointDataSetWizard(WizardPage[] pages, boolean useTransaction) {
        this.useTransaction = useTransaction;
        this.setForcePreviousAndNextButtons(true);
        int i = 0;
        while (i < pages.length) {
            this.addPage((IWizardPage)pages[i]);
            ++i;
        }
    }

    public JointDataSetWizard(DataSourceHandle dataSourceHandle, boolean useTransaction) {
        this.useTransaction = useTransaction;
        this.dataSetPage = new JointDataSetPage(Messages.getString((String)"JointDataSetPage.pageName"));
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.dataSetPage);
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        if (this.dataSetPage != null && this.dataSetPage instanceof JointDataSetPage) {
            if (this.useTransaction) {
                Utility.getCommandStack().startTrans(CREATE_DATA_SET_TRANS_NAME);
            }
            DataSetHandle joinDataSetHandle = ((JointDataSetPage)this.dataSetPage).createSelectedDataSet();
            try {
                if (joinDataSetHandle != null) {
                    DataSetUIUtil.updateColumnCache((DataSetHandle)joinDataSetHandle);
                }
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            if (this.useTransaction) {
                Utility.getCommandStack().commit();
            }
        }
        return true;
    }
}

