/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.metadata.IChoice;

final class ParameterPageUtil {
    static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getStructure("DataSetParam").getMember("dataType").getAllowedChoices().getChoices();
    static String[] directions = new String[]{Messages.getString((String)"label.input"), Messages.getString((String)"label.output"), Messages.getString((String)"label.inputOutput")};
    static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.name"), Messages.getString((String)"dataset.editor.title.dataType"), Messages.getString((String)"dataset.editor.title.direction"), Messages.getString((String)"dataset.editor.title.defaultValue")};
    static String[] dialogLabels = new String[]{Messages.getString((String)"dataset.editor.inputDialog.name"), Messages.getString((String)"dataset.editor.inputDialog.dataType"), Messages.getString((String)"dataset.editor.inputDialog.direction"), Messages.getString((String)"dataset.editor.inputDialog.defaultValue"), Messages.getString((String)"DataSetParameterPage.cell.linkToSalarParameter")};
    static String[] odaCellLabels = new String[]{Messages.getString((String)"dataset.editor.title.name"), Messages.getString((String)"dataset.editor.title.nativeName"), Messages.getString((String)"dataset.editor.title.dataType"), Messages.getString((String)"dataset.editor.title.direction"), Messages.getString((String)"dataset.editor.title.defaultValue"), Messages.getString((String)"DataSetParameterPage.editor.title.linkToSalarParameter")};
    static String[] odaDialogLabels = new String[]{Messages.getString((String)"dataset.editor.inputDialog.name"), Messages.getString((String)"dataset.editor.inputDialog.nativeName"), Messages.getString((String)"dataset.editor.inputDialog.dataType"), Messages.getString((String)"dataset.editor.inputDialog.direction"), Messages.getString((String)"dataset.editor.inputDialog.defaultValue"), Messages.getString((String)"DataSetParameterPage.cell.linkToSalarParameter")};
    private static String UNLINKED_REPORT_PARAM = Messages.getString((String)"DataSetParametersPage.reportParam.None");
    private static List linkedToParamList = null;

    ParameterPageUtil() {
    }

    static boolean isJointDataSetHandle(DataSetHandle handle) {
        return handle instanceof JointDataSetHandle;
    }

    static boolean isJointOrDerivedDataSetHandle(DataSetHandle handle) {
        return handle instanceof JointDataSetHandle || handle instanceof DerivedDataSetHandle;
    }

    static boolean isOdaDataSetHandle(DataSetHandle handle) {
        return handle instanceof OdaDataSetHandle;
    }

    static String getTypeDisplayName(String typeName) {
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i].getName().equals(typeName)) {
                return dataTypes[i].getDisplayName();
            }
            ++i;
        }
        return typeName;
    }

    static String getTypeName(String typeDisplayName) {
        String name = dataTypes[0].getName();
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i].getDisplayName().equals(typeDisplayName)) {
                return dataTypes[i].getName();
            }
            ++i;
        }
        return name;
    }

    static String[] getDataTypeDisplayNames() {
        Object[] dataTypeDisplayNames = new String[dataTypes.length];
        int i = 0;
        while (i < dataTypes.length) {
            dataTypeDisplayNames[i] = dataTypes[i].getDisplayName();
            ++i;
        }
        Arrays.sort(dataTypeDisplayNames);
        return dataTypeDisplayNames;
    }

    static String[] getLinkedReportParameterNames(OdaDataSetParameterHandle structureHandle) {
        linkedToParamList = Utility.getAllParameters();
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(UNLINKED_REPORT_PARAM);
        int i = 0;
        while (i < linkedToParamList.size()) {
            ReportElementHandle handle = (ReportElementHandle)linkedToParamList.get(i);
            if (handle instanceof ScalarParameterHandle && !"multi-value".equals(((ScalarParameterHandle)handle).getParamType())) {
                nameList.add(handle.getQualifiedName());
            }
            ++i;
        }
        String[] paramName = new String[nameList.size()];
        int i2 = 0;
        while (i2 < nameList.size()) {
            paramName[i2] = nameList.get(i2).toString();
            ++i2;
        }
        return paramName;
    }

    static ScalarParameterHandle getScalarParameter(String name, boolean needsRefresh) {
        if (needsRefresh || linkedToParamList == null) {
            linkedToParamList = Utility.getAllParameters();
        }
        Object parameterObject = null;
        int i = 0;
        while (i < linkedToParamList.size()) {
            parameterObject = linkedToParamList.get(i);
            if (parameterObject instanceof ScalarParameterHandle && name.equals(((ScalarParameterHandle)parameterObject).getQualifiedName())) {
                return parameterObject;
            }
            ++i;
        }
        return null;
    }
}

