/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PropertyHandleTableViewer {
    protected TableViewer viewer;
    private Composite mainControl;
    private MenuItem itmRemove;
    private MenuItem itmRemoveAll;
    private Menu menu;
    private Button[] buttonArray;
    private static final int IDX_NEW = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_UP = 4;
    private static final int IDX_DOWN = 5;
    private static final String TEXT_NEW = Messages.getString((String)"PropertyHandleTableViewer.Button.New");
    private static final String TEXT_EDIT = Messages.getString((String)"PropertyHandleTableViewer.Button.Edit");
    private static final String TEXT_REMOVE = Messages.getString((String)"PropertyHandleTableViewer.Button.Remove");
    private static final String TEXT_UP = Messages.getString((String)"PropertyHandleTableViewer.Button.Up");
    private static final String TEXT_DOWN = Messages.getString((String)"PropertyHandleTableViewer.Button.Down");
    private String[] buttonLabels;
    private int defaultButtonWidth;

    public PropertyHandleTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
        this(parent, showMenus, showButtons, enableKeyStrokes, true);
    }

    public PropertyHandleTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes, boolean editable) {
        String[] stringArray = new String[6];
        stringArray[0] = TEXT_NEW;
        stringArray[1] = TEXT_EDIT;
        stringArray[2] = TEXT_REMOVE;
        stringArray[4] = TEXT_UP;
        stringArray[5] = TEXT_DOWN;
        this.buttonLabels = stringArray;
        this.defaultButtonWidth = 70;
        this.mainControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.mainControl.setLayout((Layout)layout);
        this.viewer = new TableViewer(this.mainControl, 67584);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)data);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        if (showButtons) {
            this.localizeButtonWidth();
            this.createButtonComposite(editable);
        }
        if (showMenus) {
            this.createMenuComposite();
        }
        if (enableKeyStrokes) {
            this.enableKeyStrokes();
        }
    }

    private void createButtonComposite(boolean editable) {
        Composite composite = new Composite(this.mainControl, 0);
        GridData gd = new GridData();
        gd.verticalIndent = -5;
        gd.verticalAlignment = 1;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new GridLayout());
        SelectionAdapter listener = null;
        if (editable) {
            listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PropertyHandleTableViewer.this.doButtonSelected(e);
                }
            };
        }
        if (this.buttonLabels != null) {
            this.buttonArray = new Button[this.buttonLabels.length];
            int i = 0;
            while (i < this.buttonLabels.length) {
                String currLabel = this.buttonLabels[i];
                if (currLabel != null) {
                    this.buttonArray[i] = this.createButton(composite, currLabel, (SelectionListener)listener);
                    if (!editable) {
                        this.buttonArray[i].setEnabled(editable);
                    }
                } else {
                    this.buttonArray[i] = null;
                    this.createSeparator(composite);
                }
                ++i;
            }
        }
    }

    private Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(label);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        GridData gd = new GridData();
        gd.widthHint = this.defaultButtonWidth;
        button.setLayoutData((Object)gd);
        return button;
    }

    private void localizeButtonWidth() {
        this.defaultButtonWidth = Math.max(this.getMaxStringWidth(this.buttonLabels), this.defaultButtonWidth);
    }

    private int getMaxStringWidth(String[] strArray) {
        int maxWidth = -1;
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i] != null) {
                maxWidth = Math.max(maxWidth, strArray[i].length());
            }
            ++i;
        }
        return maxWidth * this.getStandardCharWidth();
    }

    private int getStandardCharWidth() {
        GC gc = new GC((Drawable)Display.getCurrent());
        int width = gc.textExtent((String)"X").x;
        gc.dispose();
        return width;
    }

    private void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.verticalIndent = 20;
        separator.setLayoutData((Object)gd);
    }

    protected void doButtonSelected(SelectionEvent e) {
        if (this.buttonArray != null) {
            int i = 0;
            while (i < this.buttonArray.length) {
                if (e.widget == this.buttonArray[i]) {
                    this.doButtonPressed(i);
                }
                ++i;
            }
        }
    }

    protected void doButtonPressed(int index) {
        switch (index) {
            case 2: {
                this.doRemove();
                break;
            }
            case 4: {
                this.doUp();
                break;
            }
            case 5: {
                this.doDown();
            }
        }
    }

    protected void doRemove() {
        int count;
        int index = this.viewer.getTable().getSelectionIndex();
        PropertyHandle handle = (PropertyHandle)this.viewer.getInput();
        int n = count = handle.getListValue() == null ? 0 : handle.getListValue().size();
        if (index > -1 && index < count) {
            try {
                handle.removeItem(index);
            }
            catch (PropertyValueException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            this.viewer.refresh();
            this.viewer.getTable().setFocus();
            this.viewer.getTable().select(index);
            this.updateButtons();
        }
    }

    private void doUp() {
        int index = this.viewer.getTable().getSelectionIndex();
        PropertyHandle handle = (PropertyHandle)this.viewer.getInput();
        if (index > 0 && handle.getListValue() != null && index < handle.getListValue().size()) {
            this.viewer.cancelEditing();
            try {
                handle.moveItem(index, index - 1);
            }
            catch (PropertyValueException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            this.viewer.refresh();
            this.viewer.getTable().setFocus();
            this.viewer.getTable().select(index - 1);
            this.updateButtons();
        }
    }

    private void doDown() {
        int index = this.viewer.getTable().getSelectionIndex();
        PropertyHandle handle = (PropertyHandle)this.viewer.getInput();
        if (index > -1 && handle.getListValue() != null && index < handle.getListValue().size() - 1) {
            this.viewer.cancelEditing();
            try {
                handle.moveItem(index, index + 1);
            }
            catch (PropertyValueException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            this.viewer.refresh();
            this.viewer.getTable().setFocus();
            this.viewer.getTable().select(index + 1);
            this.updateButtons();
        }
    }

    private void createMenuComposite() {
        this.menu = new Menu((Control)this.viewer.getTable());
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                PropertyHandleTableViewer.this.viewer.cancelEditing();
            }
        });
        this.itmRemove = new MenuItem(this.menu, 0);
        this.itmRemove.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Remove"));
        this.itmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyHandleTableViewer.this.doRemove();
            }
        });
        this.itmRemoveAll = new MenuItem(this.menu, 0);
        this.itmRemoveAll.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.RemoveAll"));
        this.itmRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PropertyHandle handle = (PropertyHandle)PropertyHandleTableViewer.this.viewer.getInput();
                    handle.clearValue();
                    PropertyHandleTableViewer.this.viewer.refresh();
                    PropertyHandleTableViewer.this.updateButtons();
                }
                catch (SemanticException e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.viewer.getTable().setMenu(this.menu);
    }

    private void enableKeyStrokes() {
        this.viewer.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    PropertyHandleTableViewer.this.doRemove();
                }
            }
        });
    }

    protected void updateButtons() {
        int[] indices = this.getViewer().getTable().getSelectionIndices();
        this.getUpButton().setEnabled(this.getUpButton().isVisible() && this.viewer.getTable().getItemCount() > 1 && indices.length == 1 && indices[0] != 0);
        this.getDownButton().setEnabled(this.getDownButton().isVisible() && this.viewer.getTable().getItemCount() > 1 && indices.length == 1 && indices[0] != this.viewer.getTable().getItemCount() - 1);
        this.getEditButton().setEnabled(this.getEditButton().isVisible() && indices.length == 1);
        this.getRemoveButton().setEnabled(this.getRemoveButton().isVisible() && indices.length > 0);
        this.getRemoveMenuItem().setEnabled(indices.length > 0);
        this.getRemoveAllMenuItem().setEnabled(this.viewer.getTable().getItemCount() > 0);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public Composite getControl() {
        return this.mainControl;
    }

    public Button getNewButton() {
        return this.buttonArray[0];
    }

    public Button getEditButton() {
        return this.buttonArray[1];
    }

    public Button getRemoveButton() {
        return this.buttonArray[2];
    }

    public Button getUpButton() {
        return this.buttonArray[4];
    }

    public Button getDownButton() {
        return this.buttonArray[5];
    }

    public Menu getMenu() {
        return this.menu;
    }

    public MenuItem getRemoveMenuItem() {
        return this.itmRemove;
    }

    public MenuItem getRemoveAllMenuItem() {
        return this.itmRemoveAll;
    }
}

