/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.engine.adapter.ModelDteApiAdapter;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.ReportContextImpl;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DerivedDataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;

public final class DataSetExecutorHelper {
    public IQueryResults execute(DataSetHandle dataSetHandle, DataRequestSession session) throws BirtException {
        return this.execute(dataSetHandle, true, true, -1, null, session);
    }

    public IQueryResults execute(DataSetHandle dataSetHandle, boolean useColumnHints, boolean useFilters, int rowsToReturn, ExecutionContext context, DataRequestSession session) throws BirtException {
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSetHandle);
        if (!(dataSetHandle instanceof JointDataSetHandle) && !(dataSetHandle instanceof DerivedDataSetHandle)) {
            context.setReportContext((IReportContext)new ReportContextImpl(context));
            dataSetDesign = new ModelDteApiAdapter(context).appendRuntimeInfoToDataSet(dataSetHandle, dataSetDesign);
        }
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        return DataSetProvider.getCurrentInstance().execute(dataSetHandle, (IBaseDataSetDesign)dataSetDesign, rowsToReturn, context, session);
    }

    public IQueryResults execute(DataSetHandle dataSetHandle, QueryDefinition queryDefn, boolean useColumnHints, boolean useFilters, DataRequestSession session) throws BirtException {
        return this.execute(dataSetHandle, (IQueryDefinition)queryDefn, useColumnHints, useFilters, false, null, session);
    }

    public IQueryResults execute(DataSetHandle dataSetHandle, IQueryDefinition queryDefn, boolean useColumnHints, boolean useFilters, boolean clearCache, ExecutionContext context, DataRequestSession session) throws BirtException {
        BaseDataSetDesign dataSetDesign = session.getModelAdaptor().adaptDataSet(dataSetHandle);
        if (!(dataSetHandle instanceof JointDataSetHandle) && !(dataSetHandle instanceof DerivedDataSetHandle) && context != null) {
            context.setReportContext((IReportContext)new ReportContextImpl(context));
            dataSetDesign = new ModelDteApiAdapter(context).appendRuntimeInfoToDataSet(dataSetHandle, dataSetDesign);
        }
        if (clearCache) {
            BaseDataSourceDesign dataSourceDesign = session.getModelAdaptor().adaptDataSource(dataSetHandle.getDataSource());
            session.clearCache((IBaseDataSourceDesign)dataSourceDesign, (IBaseDataSetDesign)dataSetDesign);
        }
        if (!useColumnHints) {
            dataSetDesign.getResultSetHints().clear();
        }
        if (!useFilters) {
            dataSetDesign.getFilters().clear();
        }
        return DataSetProvider.getCurrentInstance().execute(dataSetHandle, (IBaseDataSetDesign)dataSetDesign, queryDefn, context, session);
    }
}

