/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractVendor
implements Vendor {
    AbstractVendor() {
    }

    @Override
    public abstract String getDTPVendorName();

    abstract CatalogStrategy getCatalogStrategy();

    @Override
    public boolean supportsCatalogs(Database database) {
        return this.getCatalogStrategy().supportsCatalogs(database);
    }

    @Override
    public List<Catalog> getCatalogs(Database database) {
        return this.getCatalogStrategy().getCatalogs(database);
    }

    @Override
    public List<Schema> getSchemas(Database database) {
        try {
            return this.getCatalogStrategy().getSchemas(database);
        }
        catch (Exception ex) {
            throw new RuntimeException("vendor: " + this, ex);
        }
    }

    @Override
    public List<String> getDefaultCatalogIdentifiers(Database database, String userName) {
        if (!this.supportsCatalogs(database)) {
            return Collections.emptyList();
        }
        ArrayList<String> identifiers = new ArrayList<String>();
        this.addDefaultCatalogIdentifiersTo(database, userName, identifiers);
        return identifiers;
    }

    void addDefaultCatalogIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(userName);
    }

    @Override
    public List<String> getDefaultSchemaIdentifiers(Database database, String userName) {
        ArrayList<String> identifiers = new ArrayList<String>();
        this.addDefaultSchemaIdentifiersTo(database, userName, identifiers);
        return identifiers;
    }

    void addDefaultSchemaIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(userName);
    }

    abstract FoldingStrategy getFoldingStrategy();

    @Override
    public String convertNameToIdentifier(String name, String defaultName) {
        return this.nameRequiresDelimiters(name) ? this.delimitName(name) : (this.normalNamesMatch(name, defaultName) ? null : name);
    }

    @Override
    public String convertNameToIdentifier(String name) {
        return this.nameRequiresDelimiters(name) ? this.delimitName(name) : name;
    }

    boolean nameRequiresDelimiters(String name) {
        return name.length() == 0 || this.nameContainsAnyNonNormalCharacters(name) || this.nameIsNotFolded(name);
    }

    boolean nameContainsAnyNonNormalCharacters(String name) {
        char[] string = name.toCharArray();
        if (this.characterIsNonNormalNameStart(string[0])) {
            return true;
        }
        int i = string.length;
        while (i-- > 1) {
            if (!this.characterIsNonNormalNamePart(string[i])) continue;
            return true;
        }
        return false;
    }

    boolean characterIsNonNormalNameStart(char c) {
        return !this.characterIsNormalNameStart(c);
    }

    boolean characterIsNormalNameStart(char c) {
        return Character.isLetter(c) || this.characterIsExtendedNormalNameStart(c);
    }

    boolean characterIsExtendedNormalNameStart(char c) {
        return AbstractVendor.arrayContains(this.getExtendedNormalNameStartCharacters(), c);
    }

    char[] getExtendedNormalNameStartCharacters() {
        return null;
    }

    boolean characterIsNonNormalNamePart(char c) {
        return !this.characterIsNormalNamePart(c);
    }

    boolean characterIsNormalNamePart(char c) {
        return Character.isLetterOrDigit(c) || this.characterIsExtendedNormalNameStart(c) || this.characterIsExtendedNormalNamePart(c);
    }

    boolean characterIsExtendedNormalNamePart(char c) {
        return AbstractVendor.arrayContains(this.getExtendedNormalNamePartCharacters(), c);
    }

    char[] getExtendedNormalNamePartCharacters() {
        return null;
    }

    boolean nameIsNotFolded(String name) {
        return !this.getFoldingStrategy().nameIsFolded(name);
    }

    boolean normalNamesMatch(String name1, String name2) {
        return this.normalIdentifiersAreCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    boolean normalIdentifiersAreCaseSensitive() {
        return this.getFoldingStrategy().normalIdentifiersAreCaseSensitive();
    }

    String delimitName(String name) {
        return StringTools.quote((String)name);
    }

    @Override
    public String convertIdentifierToName(String identifier) {
        return identifier == null ? null : (this.identifierIsDelimited(identifier) ? StringTools.undelimit((String)identifier) : this.getFoldingStrategy().fold(identifier));
    }

    boolean identifierIsDelimited(String identifier) {
        return StringTools.stringIsQuoted((String)identifier);
    }

    public String toString() {
        return this.getDTPVendorName();
    }

    static boolean arrayContains(char[] array, char c) {
        return array != null && CollectionTools.contains((char[])array, (char)c);
    }
}

