/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui.wizards;

import java.net.URL;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;
import org.eclipse.mylyn.internal.discovery.core.model.Overview;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.GradientToolTip;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

class OverviewToolTip
extends GradientToolTip {
    private static final String COLOR_BLACK = "black";
    private final Overview overview;
    private final AbstractDiscoverySource source;
    private Color colorBlack;

    public OverviewToolTip(Control control, AbstractDiscoverySource source, Overview overview) {
        super(control, 1, true);
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (overview == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.overview = overview;
        this.setHideOnMouseDown(false);
    }

    protected Composite createToolTipArea(Event event, final Composite parent) {
        if (this.colorBlack == null) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (!colorRegistry.hasValueFor(COLOR_BLACK)) {
                colorRegistry.put(COLOR_BLACK, new RGB(0, 0, 0));
            }
            this.colorBlack = colorRegistry.get(COLOR_BLACK);
        }
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Composite container = new Composite(parent, 0);
        container.setBackground(null);
        Image image = null;
        if (this.overview.getScreenshot() != null && (image = this.computeImage(this.source, this.overview.getScreenshot())) != null) {
            final Image fimage = image;
            container.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    fimage.dispose();
                }
            });
        }
        boolean hasLearnMoreLink = this.overview.getUrl() != null && this.overview.getUrl().length() > 0;
        GridDataFactory.fillDefaults().grab(true, true).hint(image == null ? 500 : 650, -1).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(5, 5).spacing(3, 0).applyTo(container);
        String summary = this.overview.getSummary();
        Composite summaryContainer = new Composite(container, 0);
        summaryContainer.setBackground(null);
        GridLayoutFactory.fillDefaults().applyTo(summaryContainer);
        GridDataFactory gridDataFactory = GridDataFactory.fillDefaults().grab(true, true).span(image == null ? 2 : 1, 1);
        if (image != null) {
            gridDataFactory.hint(320, 242);
        }
        gridDataFactory.applyTo((Control)summaryContainer);
        Label summaryLabel = new Label(summaryContainer, 64);
        summaryLabel.setText(summary);
        summaryLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 1).applyTo((Control)summaryLabel);
        if (image != null) {
            Composite imageContainer = new Composite(container, 2048);
            GridLayoutFactory.fillDefaults().applyTo(imageContainer);
            GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 1).hint(322, 242).applyTo((Control)imageContainer);
            Label imageLabel = new Label(imageContainer, 0);
            GridDataFactory.fillDefaults().hint(320, 240).indent(1, 1).applyTo((Control)imageLabel);
            imageLabel.setImage(image);
            imageLabel.setBackground(null);
            imageLabel.setSize(320, 240);
            imageContainer.setBackground(this.colorBlack);
        }
        if (hasLearnMoreLink) {
            Link link = new Link(summaryContainer, 0);
            GridDataFactory.fillDefaults().grab(false, false).align(1, 0x1000000).applyTo((Control)link);
            link.setText(Messages.ConnectorDescriptorToolTip_detailsLink);
            link.setBackground(null);
            link.setToolTipText(NLS.bind((String)Messages.ConnectorDescriptorToolTip_detailsLink_tooltip, (Object)this.overview.getUrl()));
            link.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WorkbenchUtil.openUrl((String)OverviewToolTip.this.overview.getUrl(), (int)128);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        if (image == null) {
            Point optimalSize = summaryContainer.computeSize(-1, -1, true);
            if (optimalSize.y > 252) {
                ((GridData)summaryContainer.getLayoutData()).heightHint = 242;
                container.layout(true);
            }
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!parent.isDisposed()) {
                    parent.setFocus();
                }
            }
        });
        return container;
    }

    private Image computeImage(AbstractDiscoverySource discoverySource, String imagePath) {
        URL resource = discoverySource.getResource(imagePath);
        if (resource != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)resource);
            Image image = descriptor.createImage();
            return image;
        }
        return null;
    }
}

