/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DateTimeDataSet;
import org.eclipse.birt.chart.model.data.NullDataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.util.CDateTime;

public final class DataSetIterator
implements Iterator {
    private double[] da = null;
    private Double[] dda = null;
    private Calendar[] ca = null;
    private long[] la = null;
    private String[] sa = null;
    private Collection co = null;
    private int iDataType = 0;
    private int iContentType = 0;
    private int iCursor = 0;
    private Iterator it = null;
    private int iRowCount = 0;
    private Calendar cReused = null;
    private Object[] oa = null;
    private boolean isReverse = false;

    public DataSetIterator(Double[] dda) {
        this.dda = dda;
        this.iDataType = 1;
        this.iContentType = 3;
        this.iRowCount = dda.length;
    }

    public DataSetIterator(String[] sa) {
        this.sa = sa;
        this.iDataType = 16;
        this.iContentType = 3;
        this.iRowCount = sa.length;
    }

    public DataSetIterator(Calendar[] ca) throws ChartException {
        this.ca = ca;
        this.iDataType = 8;
        this.iContentType = 3;
        this.iRowCount = ca.length;
        this.updateDateTimeValues();
    }

    public DataSetIterator(Object oContent, int iDataType) throws IllegalArgumentException, ChartException {
        if ((iDataType & 2) == 2 || (iDataType & 4) == 4) {
            iDataType = 1;
        }
        this.iDataType = iDataType;
        if (iDataType == 1) {
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof double[]) {
                this.iContentType = 2;
                this.da = (double[])oContent;
            } else if (oContent instanceof Double[]) {
                this.iContentType = 3;
                this.dda = (Double[])oContent;
            }
        } else if (iDataType == 8) {
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof long[]) {
                this.iContentType = 2;
                this.la = (long[])oContent;
                this.cReused = Calendar.getInstance();
            } else if (oContent instanceof Calendar[]) {
                this.iContentType = 3;
                this.ca = (Calendar[])oContent;
            }
            this.updateDateTimeValues();
        } else if (iDataType == 16) {
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof String[]) {
                this.iContentType = 3;
                this.sa = (String[])oContent;
            }
        } else {
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof Object[]) {
                this.iContentType = 3;
                this.oa = (Object[])oContent;
            }
            iDataType = 0;
        }
        if (this.iContentType == 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle().getString("exception.process.content.type"), oContent, iDataType));
        }
        if (this.co != null) {
            this.it = this.co.iterator();
        }
        this.iRowCount = this.getRowCountInternal();
    }

    public DataSetIterator(DataSet ds) throws IllegalArgumentException, ChartException {
        Object oContent = ds.getValues();
        if (ds instanceof NumberDataSet) {
            this.iDataType = 1;
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof double[]) {
                this.iContentType = 2;
                this.da = (double[])oContent;
            } else if (oContent instanceof Double[]) {
                this.iContentType = 3;
                this.dda = (Double[])oContent;
            } else if (oContent instanceof Number) {
                this.iContentType = 2;
                this.da = new double[]{((Number)oContent).doubleValue()};
            }
        } else if (ds instanceof DateTimeDataSet) {
            this.iDataType = 8;
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof long[]) {
                this.iContentType = 2;
                this.la = (long[])oContent;
                this.cReused = Calendar.getInstance();
            } else if (oContent instanceof Calendar[]) {
                this.iContentType = 3;
                this.ca = (Calendar[])oContent;
            }
            this.updateDateTimeValues();
        } else if (ds instanceof TextDataSet) {
            this.iDataType = 16;
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof String[]) {
                this.iContentType = 3;
                this.sa = (String[])oContent;
            }
        } else if (ds instanceof NullDataSet) {
            this.iDataType = 64;
            this.iContentType = 3;
            this.oa = (Object[])oContent;
        } else {
            this.iDataType = 64;
            if (oContent instanceof Collection) {
                this.iContentType = 1;
                this.co = (Collection)oContent;
            } else if (oContent instanceof Object[]) {
                this.iContentType = 3;
                this.oa = (Object[])oContent;
            }
            this.iDataType = 0;
        }
        if (this.iContentType == 0) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle().getString("exception.process.content.dataset"), oContent, ds));
        }
        if (this.co != null) {
            this.it = this.co.iterator();
        }
        this.iRowCount = this.getRowCountInternal();
    }

    public final boolean isEmpty() {
        return this.iRowCount <= 0;
    }

    private final int getRowCountInternal() {
        if (this.iContentType == 1) {
            return this.co.size();
        }
        if (this.iDataType == 16) {
            return this.sa.length;
        }
        if (this.iDataType == 1) {
            if (this.iContentType == 2) {
                return this.da.length;
            }
            if (this.iContentType == 3) {
                return this.dda.length;
            }
        } else if (this.iDataType == 8) {
            if (this.iContentType == 2) {
                return this.la.length;
            }
            if (this.iContentType == 3) {
                return this.ca.length;
            }
        } else {
            if (this.iDataType == 16) {
                return this.sa.length;
            }
            if (this.oa != null) {
                return this.oa.length;
            }
        }
        return -1;
    }

    public final double nextPrimitiveDouble() {
        return this.da[this.getIndex()];
    }

    public final Double nextDouble() {
        if (this.it != null) {
            ++this.iCursor;
            return (Double)this.it.next();
        }
        return this.dda[this.getIndex()];
    }

    public final Calendar nextDateTime() {
        if (this.it != null) {
            ++this.iCursor;
            return (Calendar)this.it.next();
        }
        return this.ca[this.getIndex()];
    }

    public final String nextText() {
        if (this.it != null) {
            ++this.iCursor;
            return (String)this.it.next();
        }
        return this.sa[this.getIndex()];
    }

    public final Object nextObject() {
        return this.oa[this.getIndex()];
    }

    public final Calendar nextPrimitiveDateTime() {
        this.cReused.setTimeInMillis(this.la[this.getIndex()]);
        return this.cReused;
    }

    public boolean hasNext() {
        if (this.it != null) {
            return this.it.hasNext();
        }
        return this.iCursor < this.iRowCount;
    }

    public final Object next() {
        if (this.iCursor >= this.iRowCount) {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 15, "exception.out.of.bounds", Messages.getResourceBundle())));
        }
        if (this.it != null) {
            ++this.iCursor;
            return this.it.next();
        }
        if (this.iDataType == 1) {
            if (this.iContentType == 3) {
                return this.nextDouble();
            }
            if (this.iContentType == 2) {
                return new Double(this.nextPrimitiveDouble());
            }
        } else if (this.iDataType == 8) {
            if (this.iContentType == 3) {
                return this.nextDateTime();
            }
            if (this.iContentType == 2) {
                return this.nextPrimitiveDateTime();
            }
        } else {
            if (this.iDataType == 16) {
                return this.nextText();
            }
            return this.nextObject();
        }
        return null;
    }

    public void remove() {
    }

    public int size() {
        return this.iRowCount;
    }

    public final void reset() {
        this.iCursor = 0;
        this.resetIterator();
    }

    public final Object first() {
        this.reset();
        return this.next();
    }

    public final Object last() {
        this.reset();
        Object o = null;
        while (this.hasNext()) {
            o = this.next();
        }
        return o;
    }

    public final void clear() {
        this.dda = null;
        this.ca = null;
        this.da = null;
        this.la = null;
        this.oa = null;
        this.sa = null;
        if (this.co != null) {
            this.co = null;
        }
        this.iContentType = 0;
        this.iDataType = 0;
        this.iRowCount = 0;
        this.iCursor = 0;
        this.cReused = null;
        this.it = null;
    }

    public final void notifyDataUpdate() {
        this.reset();
        this.iRowCount = this.getRowCountInternal();
    }

    final void updateDateTimeValues() throws ChartException {
        this.iRowCount = this.getRowCountInternal();
        CDateTime[] cdta = new CDateTime[this.size()];
        this.reset();
        int i = 0;
        while (this.hasNext()) {
            Calendar cValue = (Calendar)this.next();
            CDateTime cDateTime = cdta[i++] = cValue == null ? null : new CDateTime(cValue);
        }
        this.clear();
        this.ca = cdta;
        this.iDataType = 8;
        this.iContentType = 3;
        this.iRowCount = this.ca.length;
    }

    public final int getDataType() {
        return this.iDataType;
    }

    public final int getIndex() {
        int n;
        if (this.isReverse) {
            n = this.iRowCount - 1 - this.iCursor++;
        } else {
            int n2 = this.iCursor;
            n = n2;
            this.iCursor = n2 + 1;
        }
        return n;
    }

    public void reverse(boolean bReverse) {
        this.isReverse = bReverse;
        if (bReverse) {
            this.resetIterator();
        }
    }

    private void resetIterator() {
        if (this.co != null) {
            if (this.isReverse) {
                ArrayList list = new ArrayList(this.co.size());
                list.addAll(this.co);
                Collections.reverse(list);
                this.it = list.iterator();
            } else {
                this.it = this.co.iterator();
            }
        }
    }

    public int skip(int iCount) {
        int iSkipped = 0;
        while (iCount-- > 0 && this.hasNext()) {
            this.next();
            ++iSkipped;
        }
        return iSkipped;
    }
}

