/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.util.ChartUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartVariableHelper {
    public static String parseChartVariables(String script, Series currOrthoSeries, SeriesDefinition baseSD, SeriesDefinition currOrthoSD) {
        try {
            String categoryExpr = ((Query)baseSD.getDesignTimeSeries().getDataDefinition().get(0)).getDefinition();
            String seriesExpr = ChartUtil.createValueSeriesRowFullExpression((Query)currOrthoSeries.getDataDefinition().get(0), currOrthoSD, baseSD);
            String seriesName = currOrthoSeries.getSeriesIdentifier().toString();
            return ChartVariableHelper.parseChartVariables(script, categoryExpr, seriesExpr, seriesName);
        }
        catch (ChartException chartException) {
            return script;
        }
    }

    private static String parseChartVariables(String script, String categoryExpr, String seriesExpr, String seriesName) {
        if (script == null) {
            return null;
        }
        ArrayList<StringBuffer> symbols = new ArrayList<StringBuffer>();
        BufferedReader br = new BufferedReader(new StringReader(script));
        boolean isComments = false;
        boolean isCPlusCommnets = false;
        boolean isInQuotation = false;
        StringBuffer sb = new StringBuffer();
        String operations = " +-*/!=<>&|()\"'";
        try {
            String str;
            int line = -1;
            while ((str = br.readLine()) != null) {
                if (++line > 0) {
                    sb.append('\n');
                    sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                }
                int i = 0;
                while (i < str.length()) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '!': 
                        case '&': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case '-': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '|': {
                            if (isCPlusCommnets || isComments) {
                                sb.append(c);
                                break;
                            }
                            sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                            sb.append(c);
                            break;
                        }
                        case '/': {
                            if (sb.length() == 0) {
                                sb.append(c);
                                break;
                            }
                            if (isComments && sb.charAt(sb.length() - 1) == '*') {
                                isComments = false;
                                sb.append(c);
                                sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                                break;
                            }
                            if (isCPlusCommnets || isComments) {
                                sb.append(c);
                                break;
                            }
                            if (sb.charAt(sb.length() - 1) == '/') {
                                isCPlusCommnets = true;
                                sb.append(c);
                                break;
                            }
                            sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                            sb.append(c);
                            break;
                        }
                        case '*': {
                            if (isCPlusCommnets || isComments) {
                                sb.append(c);
                                break;
                            }
                            if (sb.charAt(sb.length() - 1) == '/') {
                                isComments = true;
                                sb.append(c);
                                break;
                            }
                            sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                            sb.append(c);
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            if (isCPlusCommnets || isComments) {
                                sb.append(c);
                                break;
                            }
                            sb.append(c);
                            if (!isInQuotation) {
                                isInQuotation = true;
                                break;
                            }
                            isInQuotation = false;
                            sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                            break;
                        }
                        default: {
                            if (!(isComments || isCPlusCommnets || isInQuotation || operations.indexOf(c) < 0)) {
                                sb = ChartVariableHelper.addToSymbolList(symbols, sb);
                            }
                            sb.append(c);
                        }
                    }
                    ++i;
                }
                isCPlusCommnets = false;
                isInQuotation = false;
                sb = ChartVariableHelper.addToSymbolList(symbols, sb);
            }
        }
        catch (IOException iOException) {
            return script;
        }
        StringBuffer returnSB = new StringBuffer();
        for (StringBuffer s : symbols) {
            String src = s.toString();
            String expr = src.trim();
            if (expr.equals("categoryData")) {
                returnSB.append(src.replace("categoryData", categoryExpr == null ? "" : categoryExpr));
                continue;
            }
            if (expr.equals("valueData")) {
                returnSB.append(src.replace("valueData", seriesExpr == null ? "" : seriesExpr));
                continue;
            }
            if (expr.equals("valueSeriesName")) {
                StringBuffer ssb = new StringBuffer();
                ssb.append("\"");
                ssb.append(seriesName);
                ssb.append("\"");
                returnSB.append(src.replace("valueSeriesName", seriesName == null ? "" : ssb));
                continue;
            }
            returnSB.append(src);
        }
        return returnSB.toString();
    }

    private static StringBuffer addToSymbolList(List<StringBuffer> symbols, StringBuffer sb) {
        if (sb.length() == 0) {
            return sb;
        }
        symbols.add(sb);
        return new StringBuffer();
    }
}

