/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.builders.PDEBuilderHelper;
import org.eclipse.pde.internal.core.text.build.Build;
import org.eclipse.pde.internal.core.text.build.BuildEntry;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.BuildEntryMarkerResolution;

public class AddSourceBuildEntryResolution
extends BuildEntryMarkerResolution {
    public AddSourceBuildEntryResolution(int type, IMarker marker) {
        super(type, marker);
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.AddSourceBuildEntryResolution_label, (Object)this.fEntry);
    }

    protected void createChange(Build build) {
        try {
            BuildEntry buildEntry = (BuildEntry)build.getEntry(this.fEntry);
            boolean unlistedOnly = true;
            if (buildEntry == null) {
                buildEntry = new BuildEntry(this.fEntry, (IBuildModel)build.getModel());
                unlistedOnly = false;
            }
            String[] unlisted = this.getSourcePaths(build, unlistedOnly);
            int i = 0;
            while (i < unlisted.length) {
                if (unlisted[i] != null) {
                    buildEntry.addToken(unlisted[i]);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (CoreException coreException) {}
    }

    private String[] getSourcePaths(Build build, boolean unlistedOnly) {
        IProject project = build.getModel().getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                ArrayList<IBuildEntry> sourceEntries = new ArrayList<IBuildEntry>();
                IBuildEntry[] entries = build.getBuildEntries();
                if (unlistedOnly) {
                    int i = 0;
                    while (i < entries.length) {
                        if (entries[i].getName().startsWith("source.")) {
                            sourceEntries.add(entries[i]);
                        }
                        ++i;
                    }
                }
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] cpes = jp.getRawClasspath();
                return PDEBuilderHelper.getUnlistedClasspaths(sourceEntries, (IProject)project, (IClasspathEntry[])cpes);
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {}
        return null;
    }
}

