/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class FeatureInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "feature-context";

    public FeatureInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return this.createResourceModel((IFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return this.createStorageModel((IStorageEditorInput)input);
        }
        if (input instanceof IURIEditorInput) {
            return this.createSystemFileModel((IURIEditorInput)input);
        }
        return null;
    }

    private IBaseModel createResourceModel(IFileEditorInput input) throws CoreException {
        IFile file = input.getFile();
        WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
        model.load();
        return model;
    }

    private IBaseModel createStorageModel(IStorageEditorInput input) throws CoreException {
        BufferedInputStream stream = null;
        IStorage storage = input.getStorage();
        try {
            stream = new BufferedInputStream(storage.getContents());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        ExternalFeatureModel model = new ExternalFeatureModel();
        IPath path = input.getStorage().getFullPath();
        model.setInstallLocation(path == null ? "" : path.removeLastSegments(1).toOSString());
        try {
            try {
                model.load((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        return model;
    }

    private IBaseModel createSystemFileModel(IURIEditorInput input) throws CoreException {
        IFileStore store = EFS.getStore((URI)input.getURI());
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(store.getParent().toString());
        model.load(store.openInputStream(4096, (IProgressMonitor)new NullProgressMonitor()), true);
        return model;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
    }

    protected void flushModel(IDocument doc) {
        if (!(this.getModel() instanceof IEditable)) {
            return;
        }
        IEditable editableModel = (IEditable)this.getModel();
        if (!editableModel.isDirty()) {
            return;
        }
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            editableModel.save(writer);
            writer.flush();
            swriter.close();
            doc.set(swriter.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    protected boolean synchronizeModel(IDocument doc) {
        IFeatureModel model = (IFeatureModel)this.getModel();
        boolean cleanModel = true;
        String text = doc.get();
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    protected void reorderInsertEdits(ArrayList ops) {
    }

    protected String getPartitionName() {
        return "___feature_partition";
    }
}

