/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IBundleContentWizard;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IFragmentFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginFieldData;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.osgi.service.prefs.BackingStoreException;

public class NewProjectCreationOperation
extends WorkspaceModifyOperation {
    private IPluginContentWizard fContentWizard;
    private IFieldData fData;
    private PluginClassCodeGenerator fGenerator;
    private WorkspacePluginModelBase fModel;
    private IProjectProvider fProjectProvider;
    private boolean fResult;

    public NewProjectCreationOperation(IFieldData data, IProjectProvider provider, IPluginContentWizard contentWizard) {
        this.fData = data;
        this.fProjectProvider = provider;
        this.fContentWizard = contentWizard;
    }

    protected void adjustManifests(IProgressMonitor monitor, IProject project, IPluginBase bundle) throws CoreException {
        IPluginLibrary[] libs = this.fModel.getPluginBase().getLibraries();
        TreeSet<String> packages = new TreeSet<String>();
        int i = 0;
        while (i < libs.length) {
            String[] filters = libs[i].getContentFilters();
            if (filters.length == 1 && filters[0].equals("**")) {
                this.addAllSourcePackages(project, packages);
                break;
            }
            int j = 0;
            while (j < filters.length) {
                if (filters[j].endsWith(".*")) {
                    packages.add(filters[j].substring(0, filters[j].length() - 2));
                }
                ++j;
            }
            ++i;
        }
        if (!packages.isEmpty()) {
            IBundle iBundle = ((WorkspaceBundlePluginModelBase)this.fModel).getBundleModel().getBundle();
            iBundle.setHeader("Export-Package", this.getCommaValuesFromPackagesSet(packages, this.fData.getVersion()));
        }
    }

    private void createBuildPropertiesFile(IProject project) throws CoreException {
        IFile file = project.getFile("build.properties");
        if (!file.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(file);
            IBuildModelFactory factory = model.getFactory();
            IBuildEntry binEntry = factory.createEntry("bin.includes");
            this.fillBinIncludes(project, binEntry);
            this.createSourceOutputBuildEntries(model, factory);
            model.getBuild().add(binEntry);
            model.save();
        }
    }

    protected void createSourceOutputBuildEntries(WorkspaceBuildModel model, IBuildModelFactory factory) throws CoreException {
        String srcFolder = this.fData.getSourceFolderName();
        if (!this.fData.isSimple() && srcFolder != null) {
            String libraryName = this.fData.getLibraryName();
            if (libraryName == null) {
                libraryName = ".";
            }
            IBuildEntry entry = factory.createEntry("source." + libraryName);
            if (srcFolder.length() > 0) {
                entry.addToken(new Path(srcFolder).addTrailingSeparator().toString());
            } else {
                entry.addToken(".");
            }
            model.getBuild().add(entry);
            entry = factory.createEntry("output." + libraryName);
            String outputFolder = this.fData.getOutputFolderName().trim();
            if (outputFolder.length() > 0) {
                entry.addToken(new Path(outputFolder).addTrailingSeparator().toString());
            } else {
                entry.addToken(".");
            }
            model.getBuild().add(entry);
        }
    }

    protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {
    }

    private void createManifest(IProject project) throws CoreException {
        this.fModel = this.fData.hasBundleStructure() ? (this.fData instanceof IFragmentFieldData ? new WorkspaceBundleFragmentModel(project.getFile("META-INF/MANIFEST.MF"), project.getFile("fragment.xml")) : new WorkspaceBundlePluginModel(project.getFile("META-INF/MANIFEST.MF"), project.getFile("plugin.xml"))) : (this.fData instanceof IFragmentFieldData ? new WorkspaceFragmentModel(project.getFile("fragment.xml"), false) : new WorkspacePluginModel(project.getFile("plugin.xml"), false));
        IPluginBase pluginBase = this.fModel.getPluginBase();
        String targetVersion = ((AbstractFieldData)this.fData).getTargetVersion();
        pluginBase.setSchemaVersion(TargetPlatformHelper.getSchemaVersionForTargetVersion((String)targetVersion));
        pluginBase.setId(this.fData.getId());
        pluginBase.setVersion(this.fData.getVersion());
        pluginBase.setName(this.fData.getName());
        pluginBase.setProviderName(this.fData.getProvider());
        if (this.fModel instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase bmodel = (IBundlePluginModelBase)this.fModel;
            ((IBundlePluginBase)bmodel.getPluginBase()).setTargetVersion(targetVersion);
            bmodel.getBundleModel().getBundle().setHeader("Bundle-ManifestVersion", "2");
        }
        if (pluginBase instanceof IFragment) {
            IFragment fragment = (IFragment)pluginBase;
            IFragmentFieldData data = (IFragmentFieldData)this.fData;
            fragment.setPluginId(data.getPluginId());
            fragment.setPluginVersion(data.getPluginVersion());
            fragment.setRule(data.getMatch());
        } else if (((IPluginFieldData)this.fData).doGenerateClass()) {
            ((IPlugin)pluginBase).setClassName(((IPluginFieldData)this.fData).getClassname());
        }
        if (!this.fData.isSimple()) {
            this.setPluginLibraries(this.fModel);
        }
        IPluginReference[] dependencies = this.getDependencies();
        int i = 0;
        while (i < dependencies.length) {
            IPluginReference ref = dependencies[i];
            IPluginImport iimport = this.fModel.getPluginFactory().createImport();
            iimport.setId(ref.getId());
            iimport.setVersion(ref.getVersion());
            iimport.setMatch(ref.getMatch());
            pluginBase.add(iimport);
            ++i;
        }
        if (pluginBase instanceof BundlePluginBase) {
            String[] newFiles;
            IBundle bundle = ((BundlePluginBase)pluginBase).getBundle();
            if (this.fData instanceof AbstractFieldData) {
                String framework;
                String exeEnvironment = ((AbstractFieldData)this.fData).getExecutionEnvironment();
                if (exeEnvironment != null) {
                    bundle.setHeader("Bundle-RequiredExecutionEnvironment", exeEnvironment);
                }
                if ((framework = ((AbstractFieldData)this.fData).getOSGiFramework()) != null) {
                    String value = this.getCommaValuesFromPackagesSet(this.getImportPackagesSet(), this.fData.getVersion());
                    if (value.length() > 0) {
                        bundle.setHeader("Import-Package", value);
                    }
                    if (!framework.equals("Equinox")) {
                        return;
                    }
                }
            }
            if (this.fData instanceof IPluginFieldData && ((IPluginFieldData)this.fData).doGenerateClass()) {
                if (targetVersion.equals("3.1")) {
                    bundle.setHeader("Eclipse-AutoStart", "true");
                } else {
                    double version = Double.parseDouble(targetVersion);
                    if (version >= 3.4) {
                        bundle.setHeader("Bundle-ActivationPolicy", "lazy");
                    } else {
                        bundle.setHeader("Eclipse-LazyStart", "true");
                    }
                }
            }
            if (this.fContentWizard != null && (newFiles = this.fContentWizard.getNewFiles()) != null) {
                int i2 = 0;
                while (i2 < newFiles.length) {
                    if ("plugin.properties".equals(newFiles[i2])) {
                        bundle.setHeader("Bundle-Localization", "plugin");
                        break;
                    }
                    ++i2;
                }
            }
        }
    }

    private IProject createProject() throws CoreException {
        IFolder folder;
        IProject project = this.fProjectProvider.getProject();
        if (!project.exists()) {
            CoreUtility.createProject((IProject)project, (IPath)this.fProjectProvider.getLocationPath(), null);
            project.open(null);
        }
        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (!this.fData.isSimple() && !project.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
        if (!this.fData.isSimple() && this.fData.getSourceFolderName() != null && this.fData.getSourceFolderName().trim().length() > 0 && !(folder = project.getFolder(this.fData.getSourceFolderName())).exists()) {
            CoreUtility.createFolder((IFolder)folder);
        }
        return project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IEclipsePreferences pref;
        String framework;
        monitor.beginTask(PDEUIMessages.NewProjectCreationOperation_creating, this.getNumberOfWorkUnits());
        monitor.subTask(PDEUIMessages.NewProjectCreationOperation_project);
        IProject project = this.createProject();
        monitor.worked(1);
        this.createContents(monitor, project);
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            monitor.subTask(PDEUIMessages.NewProjectCreationOperation_setClasspath);
            this.setClasspath(project, this.fData);
            monitor.worked(1);
        }
        if (this.fData instanceof PluginFieldData) {
            PluginFieldData data = (PluginFieldData)this.fData;
            if (data.doGenerateClass()) {
                this.generateTopLevelPluginClass(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (data.doEnableAPITooling()) {
                this.addApiAnalysisNature();
            }
        }
        monitor.subTask(PDEUIMessages.NewProjectCreationOperation_manifestFile);
        this.createManifest(project);
        monitor.worked(1);
        monitor.subTask(PDEUIMessages.NewProjectCreationOperation_buildPropertiesFile);
        this.createBuildPropertiesFile(project);
        monitor.worked(1);
        boolean contentWizardResult = true;
        if (this.fContentWizard != null) {
            contentWizardResult = this.fContentWizard.performFinish(project, (IPluginModelBase)this.fModel, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (this.fData instanceof AbstractFieldData && (framework = ((AbstractFieldData)this.fData).getOSGiFramework()) != null && (pref = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            pref.putBoolean("resolve.requirebundle", false);
            pref.putBoolean("pluginProject.extensions", false);
            if (!"Equinox".equals(framework)) {
                pref.putBoolean("pluginProject.equinox", false);
            }
            try {
                pref.flush();
            }
            catch (BackingStoreException e) {
                PDEPlugin.logException(e);
            }
        }
        if (this.fData.hasBundleStructure() && this.fModel instanceof WorkspaceBundlePluginModelBase) {
            this.adjustManifests((IProgressMonitor)new SubProgressMonitor(monitor, 1), project, this.fModel.getPluginBase());
        }
        this.fModel.save();
        this.openFile((IFile)this.fModel.getUnderlyingResource());
        monitor.worked(1);
        this.fResult = contentWizardResult;
    }

    private Set getImportPackagesSet() {
        int i;
        String[] packages;
        TreeSet<String> set = new TreeSet<String>();
        if (this.fGenerator != null) {
            packages = this.fGenerator.getImportPackages();
            i = 0;
            while (i < packages.length) {
                set.add(packages[i]);
                ++i;
            }
        }
        if (this.fContentWizard instanceof IBundleContentWizard) {
            packages = ((IBundleContentWizard)this.fContentWizard).getImportPackages();
            i = 0;
            while (i < packages.length) {
                set.add(packages[i]);
                ++i;
            }
        }
        return set;
    }

    protected void fillBinIncludes(IProject project, IBuildEntry binEntry) throws CoreException {
        if (!(this.fData.hasBundleStructure() && this.fContentWizard == null || ((AbstractFieldData)this.fData).getOSGiFramework() != null)) {
            binEntry.addToken(this.fData instanceof IFragmentFieldData ? "fragment.xml" : "plugin.xml");
        }
        if (this.fData.hasBundleStructure()) {
            binEntry.addToken("META-INF/");
        }
        if (!this.fData.isSimple()) {
            String libraryName = this.fData.getLibraryName();
            binEntry.addToken(libraryName == null ? "." : libraryName);
        }
        if (this.fContentWizard != null) {
            String[] files = this.fContentWizard.getNewFiles();
            int j = 0;
            while (j < files.length) {
                if (!binEntry.contains(files[j])) {
                    binEntry.addToken(files[j]);
                }
                ++j;
            }
        }
    }

    private void generateTopLevelPluginClass(IProject project, IProgressMonitor monitor) throws CoreException {
        PluginFieldData data = (PluginFieldData)this.fData;
        this.fGenerator = new PluginClassCodeGenerator(project, data.getClassname(), data, this.fContentWizard != null);
        this.fGenerator.generate(monitor);
        monitor.done();
    }

    private IClasspathEntry[] getClassPathEntries(IJavaProject project, IFieldData data) {
        IClasspathEntry[] internalClassPathEntries = this.getInternalClassPathEntries(project, data);
        IClasspathEntry[] entries = new IClasspathEntry[internalClassPathEntries.length + 2];
        System.arraycopy(internalClassPathEntries, 0, entries, 2, internalClassPathEntries.length);
        String executionEnvironment = null;
        if (data instanceof AbstractFieldData) {
            executionEnvironment = ((AbstractFieldData)data).getExecutionEnvironment();
        }
        ClasspathComputer.setComplianceOptions((IJavaProject)project, executionEnvironment);
        entries[0] = ClasspathComputer.createJREEntry((String)executionEnvironment);
        entries[1] = ClasspathComputer.createContainerEntry();
        return entries;
    }

    private IPluginReference[] getDependencies() {
        IPluginReference[] refs;
        ArrayList<IPluginReference> result = new ArrayList<IPluginReference>();
        if (this.fGenerator != null) {
            refs = this.fGenerator.getDependencies();
            int i = 0;
            while (i < refs.length) {
                result.add(refs[i]);
                ++i;
            }
        }
        if (this.fContentWizard != null) {
            refs = this.fContentWizard.getDependencies(this.fData.isLegacy() ? null : "3.0");
            int j = 0;
            while (j < refs.length) {
                if (!result.contains(refs[j])) {
                    result.add(refs[j]);
                }
                ++j;
            }
        }
        return result.toArray(new IPluginReference[result.size()]);
    }

    protected IClasspathEntry[] getInternalClassPathEntries(IJavaProject project, IFieldData data) {
        if (data.getSourceFolderName() == null) {
            return new IClasspathEntry[0];
        }
        IClasspathEntry[] entries = new IClasspathEntry[1];
        IPath path = project.getProject().getFullPath().append(data.getSourceFolderName());
        entries[0] = JavaCore.newSourceEntry((IPath)path);
        return entries;
    }

    protected int getNumberOfWorkUnits() {
        int numUnits = 4;
        if (this.fData.hasBundleStructure()) {
            ++numUnits;
        }
        if (this.fData instanceof IPluginFieldData) {
            IPluginFieldData data = (IPluginFieldData)this.fData;
            if (data.doGenerateClass()) {
                ++numUnits;
            }
            if (this.fContentWizard != null) {
                ++numUnits;
            }
        }
        return numUnits;
    }

    public boolean getResult() {
        return this.fResult;
    }

    private void openFile(final IFile file) {
        IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        final IWorkbenchPage page = ww.getActivePage();
        if (page == null) {
            return;
        }
        final IWorkbenchPart focusPart = page.getActivePart();
        ww.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)file);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    private void setClasspath(IProject project, IFieldData data) throws JavaModelException, CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (data.getOutputFolderName() != null) {
            IPath path = project.getFullPath().append(data.getOutputFolderName());
            javaProject.setOutputLocation(path, null);
        }
        IClasspathEntry[] entries = this.getClassPathEntries(javaProject, data);
        javaProject.setRawClasspath(entries, null);
    }

    protected void setPluginLibraries(WorkspacePluginModelBase model) throws CoreException {
        String libraryName = this.fData.getLibraryName();
        if (libraryName == null && !this.fData.hasBundleStructure()) {
            libraryName = ".";
        }
        if (libraryName != null) {
            IPluginLibrary library = model.getPluginFactory().createLibrary();
            library.setName(libraryName);
            library.setExported(!this.fData.hasBundleStructure());
            this.fModel.getPluginBase().add(library);
        }
    }

    protected String getCommaValuesFromPackagesSet(Set values, String version) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(",\n ");
            }
            String value = iter.next().toString();
            buffer.append(value);
            if (value.indexOf(";version=") != -1 || version == null || values.size() != 1) continue;
            buffer.append(";version=\"").append(version).append("\"");
        }
        return buffer.toString();
    }

    private void addAllSourcePackages(IProject project, Set list) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            int i = 0;
            while (i < classpath.length) {
                IPath path;
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 3 && (path = entry.getPath().removeFirstSegments(1)).segmentCount() > 0) {
                    IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)project.getFolder(path));
                    IJavaElement[] children = root.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IPackageFragment frag = (IPackageFragment)children[j];
                        if (frag.getChildren().length > 0 || frag.getNonJavaResources().length > 0) {
                            list.add(children[j].getElementName());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void addApiAnalysisNature() {
        try {
            IProject project = this.fProjectProvider.getProject();
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.pde.api.tools.apiAnalysisNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }
}

