/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.AbstractModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.NameVersionDescriptor;

public class ExternalModelManager
extends AbstractModelManager {
    private IPluginModelBase[] fModels = new IPluginModelBase[0];

    protected IPluginModelBase[] getAllModels() {
        return this.fModels;
    }

    protected void initializeModels(IPluginModelBase[] models) {
        block14: {
            this.fModels = models;
            PDEPreferencesManager pref = PDECore.getDefault().getPreferencesManager();
            String saved = pref.getString("checkedPlugins");
            if (saved.equals("[savedAll]")) {
                int i = 0;
                while (i < this.fModels.length) {
                    this.fModels[i].setEnabled(true);
                    ++i;
                }
            } else if (!saved.equals("[savedNone]")) {
                Vector<String> result = new Vector<String>();
                StringTokenizer stok = new StringTokenizer(saved);
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                int i = 0;
                while (i < this.fModels.length) {
                    this.fModels[i].setEnabled(!result.contains(this.fModels[i].getPluginBase().getId()));
                    ++i;
                }
            }
            String pooled = pref.getString("pooled_bundles");
            if (pooled == null || pooled.trim().length() <= 0) break block14;
            if ("[savedNone]".equals(pooled)) {
                int i = 0;
                while (i < this.fModels.length) {
                    if (AbstractTargetHandle.BUNDLE_POOL.isPrefixOf((IPath)new Path(this.fModels[i].getInstallLocation()))) {
                        this.fModels[i].setEnabled(false);
                    }
                    ++i;
                }
            } else {
                StringTokenizer tokenizer = new StringTokenizer(pooled, ",");
                HashSet<NameVersionDescriptor> enabled = new HashSet<NameVersionDescriptor>();
                while (tokenizer.hasMoreTokens()) {
                    String id = tokenizer.nextToken();
                    if (!tokenizer.hasMoreTokens()) continue;
                    String ver = tokenizer.nextToken();
                    if ("[savedNone]".equals(ver)) {
                        ver = null;
                    }
                    enabled.add(new NameVersionDescriptor(id, ver));
                }
                int i = 0;
                while (i < this.fModels.length) {
                    if (AbstractTargetHandle.BUNDLE_POOL.isPrefixOf((IPath)new Path(this.fModels[i].getInstallLocation()))) {
                        IPluginBase base = this.fModels[i].getPluginBase();
                        NameVersionDescriptor desc = new NameVersionDescriptor(base.getId(), base.getVersion());
                        this.fModels[i].setEnabled(enabled.contains(desc));
                    }
                    ++i;
                }
            }
        }
    }

    public void setModels(IPluginModelBase[] models) {
        this.fModels = models;
    }

    protected URL[] getPluginPaths() {
        PDEPreferencesManager pref = PDECore.getDefault().getPreferencesManager();
        URL[] base = PluginPathFinder.getPluginPaths(pref.getString("platform_path"));
        String value = pref.getString("additional_locations");
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() == 0) {
            return base;
        }
        File[] extraLocations = new File[tokenizer.countTokens()];
        int i = 0;
        while (i < extraLocations.length) {
            String location = tokenizer.nextToken();
            File dir = new File(location, "plugins");
            if (!dir.exists() || !dir.isDirectory()) {
                dir = new File(location);
            }
            extraLocations[i] = dir;
            ++i;
        }
        URL[] additional = PluginPathFinder.scanLocations(extraLocations);
        if (additional.length == 0) {
            return base;
        }
        URL[] result = new URL[base.length + additional.length];
        System.arraycopy(base, 0, result, 0, base.length);
        System.arraycopy(additional, 0, result, base.length, additional.length);
        return result;
    }
}

