/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.internal.AbstractJpaNode;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaFile
extends AbstractJpaNode
implements JpaFile {
    protected final IFile file;
    protected final IContentType contentType;
    protected final JpaResourceModel resourceModel;
    protected final Hashtable<Object, JpaStructureNode> rootStructureNodes;

    public GenericJpaFile(JpaProject jpaProject, IFile file, IContentType contentType, JpaResourceModel resourceModel) {
        super(jpaProject);
        this.file = file;
        this.contentType = contentType;
        this.resourceModel = resourceModel;
        this.rootStructureNodes = new Hashtable();
    }

    @Override
    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add("rootStructureNodes");
    }

    @Override
    public IFile getFile() {
        return this.file;
    }

    @Override
    public IContentType getContentType() {
        return this.contentType;
    }

    @Override
    public JpaResourceModel getResourceModel() {
        return this.resourceModel;
    }

    @Override
    public JpaResourceModel getResourceModel(IContentType ct) {
        return this.contentType.isKindOf(ct) ? this.resourceModel : null;
    }

    @Override
    public Iterator<JpaStructureNode> rootStructureNodes() {
        return new CloneIterator(this.rootStructureNodes.values());
    }

    protected Iterable<JpaStructureNode> getRootStructureNodes() {
        return new CloneIterable(this.rootStructureNodes.values());
    }

    @Override
    public int rootStructureNodesSize() {
        return this.rootStructureNodes.size();
    }

    @Override
    public void addRootStructureNode(Object key, JpaStructureNode rootStructureNode) {
        JpaStructureNode old = this.rootStructureNodes.put(key, rootStructureNode);
        if (rootStructureNode != old) {
            if (old != null) {
                this.fireItemRemoved("rootStructureNodes", old);
            }
            this.fireItemAdded("rootStructureNodes", rootStructureNode);
        }
    }

    @Override
    public void removeRootStructureNode(Object key) {
        this.fireItemRemoved("rootStructureNodes", this.rootStructureNodes.remove(key));
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JpaStructureNode rootNode : this.getRootStructureNodes()) {
            JpaStructureNode node = rootNode.getStructureNode(textOffset);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.file);
        sb.append('[');
        sb.append(this.contentType.getName());
        sb.append(']');
    }
}

