/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlMappedByMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmMappedByJoiningStrategy
extends AbstractXmlContextNode
implements OrmMappedByJoiningStrategy {
    protected XmlMappedByMapping resource;
    protected String mappedByAttribute;

    public GenericOrmMappedByJoiningStrategy(OrmOwnableRelationshipReference parent, XmlMappedByMapping resource) {
        super(parent);
        this.resource = resource;
        this.mappedByAttribute = this.resource.getMappedBy();
    }

    @Override
    public OrmOwnableRelationshipReference getParent() {
        return (OrmOwnableRelationshipReference)super.getParent();
    }

    @Override
    public OrmOwnableRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getParent().getRelationshipMapping();
    }

    @Override
    public boolean relationshipIsOwnedBy(RelationshipMapping otherMapping) {
        String targetEntity;
        String thisEntity = this.getRelationshipMapping().getEntity() == null ? null : this.getRelationshipMapping().getEntity().getName();
        String string = targetEntity = this.getRelationshipMapping().getResolvedTargetEntity() == null ? null : this.getRelationshipMapping().getResolvedTargetEntity().getName();
        return StringTools.stringsAreEqual((String)thisEntity, (String)targetEntity) && StringTools.stringsAreEqual((String)this.getMappedByAttribute(), (String)otherMapping.getName());
    }

    @Override
    public String getMappedByAttribute() {
        return this.mappedByAttribute;
    }

    @Override
    public void setMappedByAttribute(String newMappedByAttribute) {
        String oldMappedByAttribute = this.mappedByAttribute;
        this.mappedByAttribute = newMappedByAttribute;
        this.resource.setMappedBy(newMappedByAttribute);
        this.firePropertyChanged("mappedByAttribute", oldMappedByAttribute, newMappedByAttribute);
    }

    protected void setMappedByAttribute_(String newMappedByAttribute) {
        String oldMappedByAttribute = this.mappedByAttribute;
        this.mappedByAttribute = newMappedByAttribute;
        this.firePropertyChanged("mappedByAttribute", oldMappedByAttribute, newMappedByAttribute);
    }

    @Override
    public void addStrategy() {
        if (this.mappedByAttribute == null) {
            this.setMappedByAttribute("");
        }
    }

    @Override
    public void removeStrategy() {
        if (this.mappedByAttribute != null) {
            this.setMappedByAttribute(null);
        }
    }

    @Override
    public void update() {
        this.setMappedByAttribute_(this.resource.getMappedBy());
    }

    @Override
    public Iterator<String> candidateMappedByAttributeNames() {
        return this.getRelationshipMapping().allTargetEntityAttributeNames();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.getMappedByAttribute() == null) {
            return;
        }
        Entity targetEntity = this.getRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(this.mappedByAttribute);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedByAttribute}, this, this.getValidationTextRange()));
            return;
        }
        AttributeMapping mappedByMapping = attribute.getMapping();
        if (!this.getRelationshipReference().mayBeMappedBy(mappedByMapping)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedByAttribute}, this, this.getValidationTextRange()));
            return;
        }
        if (!((RelationshipMapping)mappedByMapping).isRelationshipOwner()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getValidationTextRange()));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange mappedByTextRange = this.resource.getMappedByTextRange();
        return mappedByTextRange != null ? mappedByTextRange : this.getRelationshipReference().getValidationTextRange();
    }
}

