/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.BaseNamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHintAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Type;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceBaseNamedQueryAnnotation
extends SourceAnnotation<Type>
implements BaseNamedQueryAnnotation {
    final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    final AnnotationElementAdapter<String> nameAdapter;
    String name;
    final DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    final AnnotationElementAdapter<String> queryAdapter;
    String query;
    final Vector<NestableQueryHintAnnotation> hints = new Vector();
    final HintsAnnotationContainer hintsContainer = new HintsAnnotationContainer();

    SourceBaseNamedQueryAnnotation(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, type, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.queryDeclarationAdapter = this.buildQueryAdapter(daa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.queryAdapter = this.buildAdapter(this.queryDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.query = this.buildQuery(astRoot);
        AnnotationContainerTools.initialize(this.hintsContainer, astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setName(this.buildName(astRoot));
        this.setQuery(this.buildQuery(astRoot));
        AnnotationContainerTools.update(this.hintsContainer, astRoot);
    }

    AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasNotChanged(this.name, name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.nameAdapter.setValue(name);
        this.firePropertyChanged("name", old, name);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daAdapter, this.getNameElementName());
    }

    abstract String getNameElementName();

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        if (this.attributeValueHasNotChanged(this.query, query)) {
            return;
        }
        String old = this.query;
        this.query = query;
        this.queryAdapter.setValue(query);
        this.firePropertyChanged("query", old, query);
    }

    private String buildQuery(CompilationUnit astRoot) {
        return this.queryAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getQueryTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.queryDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildQueryAdapter(DeclarationAnnotationAdapter daAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daAdapter, this.getQueryElementName());
    }

    abstract String getQueryElementName();

    @Override
    public ListIterator<QueryHintAnnotation> hints() {
        return new CloneListIterator(this.hints);
    }

    ListIterator<NestableQueryHintAnnotation> nestableHints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public NestableQueryHintAnnotation hintAt(int index) {
        return this.hints.get(index);
    }

    @Override
    public int indexOfHint(QueryHintAnnotation queryHint) {
        return this.hints.indexOf(queryHint);
    }

    @Override
    public NestableQueryHintAnnotation addHint(int index) {
        return (NestableQueryHintAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.hintsContainer);
    }

    NestableQueryHintAnnotation addHintInternal() {
        NestableQueryHintAnnotation hint = this.buildQueryHint(this.hints.size());
        this.hints.add(hint);
        return hint;
    }

    abstract NestableQueryHintAnnotation buildQueryHint(int var1);

    void hintAdded(int index, NestableQueryHintAnnotation hint) {
        this.fireItemAdded("hints", index, hint);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.hintsContainer);
    }

    NestableQueryHintAnnotation moveHintInternal(int targetIndex, int sourceIndex) {
        return (NestableQueryHintAnnotation)CollectionTools.move(this.hints, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void hintMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("hints", targetIndex, sourceIndex);
    }

    @Override
    public void removeHint(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.hintsContainer);
    }

    NestableQueryHintAnnotation removeHintInternal(int index) {
        return this.hints.remove(index);
    }

    void hintRemoved(int index, NestableQueryHintAnnotation hint) {
        this.fireItemRemoved("hints", index, hint);
    }

    abstract String getHintsElementName();

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        BaseNamedQueryAnnotation oldQuery = (BaseNamedQueryAnnotation)((Object)oldAnnotation);
        this.setName(oldQuery.getName());
        this.setQuery(oldQuery.getQuery());
        for (QueryHintAnnotation oldQueryHint : CollectionTools.iterable(oldQuery.hints())) {
            NestableQueryHintAnnotation newQueryHint = this.addHint(oldQuery.indexOfHint(oldQueryHint));
            newQueryHint.initializeFrom((NestableQueryHintAnnotation)oldQueryHint);
        }
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HintsAnnotationContainer
    implements AnnotationContainer<NestableQueryHintAnnotation> {
        HintsAnnotationContainer() {
        }

        @Override
        public String getContainerAnnotationName() {
            return SourceBaseNamedQueryAnnotation.this.getAnnotationName();
        }

        @Override
        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceBaseNamedQueryAnnotation.this.getJdtAnnotation(astRoot);
        }

        @Override
        public String getElementName() {
            return SourceBaseNamedQueryAnnotation.this.getHintsElementName();
        }

        @Override
        public String getNestableAnnotationName() {
            return "javax.persistence.QueryHint";
        }

        @Override
        public ListIterator<NestableQueryHintAnnotation> nestedAnnotations() {
            return SourceBaseNamedQueryAnnotation.this.nestableHints();
        }

        @Override
        public int nestedAnnotationsSize() {
            return SourceBaseNamedQueryAnnotation.this.hintsSize();
        }

        @Override
        public NestableQueryHintAnnotation addNestedAnnotationInternal() {
            return SourceBaseNamedQueryAnnotation.this.addHintInternal();
        }

        @Override
        public void nestedAnnotationAdded(int index, NestableQueryHintAnnotation nestedAnnotation) {
            SourceBaseNamedQueryAnnotation.this.hintAdded(index, nestedAnnotation);
        }

        @Override
        public NestableQueryHintAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceBaseNamedQueryAnnotation.this.moveHintInternal(targetIndex, sourceIndex);
        }

        @Override
        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceBaseNamedQueryAnnotation.this.hintMoved(targetIndex, sourceIndex);
        }

        @Override
        public NestableQueryHintAnnotation removeNestedAnnotationInternal(int index) {
            return SourceBaseNamedQueryAnnotation.this.removeHintInternal(index);
        }

        @Override
        public void nestedAnnotationRemoved(int index, NestableQueryHintAnnotation nestedAnnotation) {
            SourceBaseNamedQueryAnnotation.this.hintRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

