/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionUtil;
import org.eclipse.datatools.connectivity.oda.spec.manifest.VariableRestrictions;
import org.eclipse.datatools.connectivity.oda.spec.valueexpr.CustomFunction;

public class FunctionExpressionDefinition {
    public static final String ELEMENT_NAME = "functionExpressionType";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DISPLAY_NAME = "displayName";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_MIN_ARGS = "minArguments";
    public static final String ATTR_MAX_ARGS = "maxArguments";
    public static final String ATTR_CAN_IGNORE_DUPLS = "canIgnoreDuplicates";
    static final Integer ATTR_ARGS_DEFAULT_VALUE = 1;
    private IConfigurationElement m_exprElement;
    private ExtensionContributor m_contributorInfo;
    private String m_id;
    private String m_name;
    private String m_displayName;
    private String m_desc;
    private Integer m_minArgs;
    private Integer m_maxArgs;
    private boolean m_canIgnoreDupls;
    private VariableRestrictions m_varRestrictions;

    FunctionExpressionDefinition(IConfigurationElement exprElement, ExtensionContributor providerInfo) throws OdaException {
        this.init(exprElement, providerInfo);
    }

    private void init(IConfigurationElement exprElement, ExtensionContributor contributorInfo) throws OdaException {
        ResultExtensionUtil.validateConfigurationElement(exprElement);
        this.m_exprElement = exprElement;
        this.m_contributorInfo = contributorInfo;
        this.m_id = FunctionExpressionDefinition.getIdAttributeValue(exprElement);
        this.m_name = exprElement.getAttribute(ATTR_NAME);
        this.m_displayName = exprElement.getAttribute(ATTR_DISPLAY_NAME);
        this.m_desc = exprElement.getAttribute(ATTR_DESC);
        this.m_minArgs = ResultExtensionUtil.getMinAttributeValue(exprElement, ATTR_MIN_ARGS, ATTR_ARGS_DEFAULT_VALUE);
        this.m_maxArgs = ResultExtensionUtil.getMaxAttributeValue(exprElement, ATTR_MAX_ARGS, ATTR_ARGS_DEFAULT_VALUE, this.m_minArgs);
        this.m_canIgnoreDupls = ResultExtensionUtil.getBooleanAttributeValue(exprElement, ATTR_CAN_IGNORE_DUPLS, false);
        this.m_varRestrictions = new VariableRestrictions(exprElement);
    }

    public static String getIdAttributeValue(IConfigurationElement exprElement) throws OdaException {
        return ResultExtensionUtil.getRequiredAttributeValue(exprElement, ATTR_ID, ELEMENT_NAME);
    }

    public CustomFunction createExpression() throws OdaException {
        String className = this.m_exprElement.getAttribute(ATTR_CLASS);
        if (className != null && className.length() > 0) {
            try {
                Object clazz = this.m_exprElement.createExecutableExtension(ATTR_CLASS);
                if (clazz instanceof CustomFunction) {
                    return (CustomFunction)clazz;
                }
                throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_CLASS_TYPE_ATTRIBUTE, (Object[])new Object[]{className, ATTR_CLASS, CustomFunction.class.getName()}));
            }
            catch (CoreException ex) {
                throw new OdaException(ex);
            }
        }
        return new CustomFunction(this.getDeclaringExtensionId(), this.getId());
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        return this.m_contributorInfo.supportsDataSetType(odaDataSourceId, odaDataSetId);
    }

    public String getDeclaringExtensionId() {
        return this.m_contributorInfo.getDeclaringExtensionId();
    }

    public String getId() {
        return this.m_id;
    }

    public String getName() {
        if (this.m_name != null && this.m_name.trim().length() > 0) {
            return this.m_name;
        }
        return this.m_id;
    }

    public String getDisplayName() {
        if (this.m_displayName != null && this.m_displayName.trim().length() > 0) {
            return this.m_displayName;
        }
        return this.getName();
    }

    public String getDescription() {
        return this.m_desc;
    }

    public ExtensionContributor getContributor() {
        return this.m_contributorInfo;
    }

    public IValidator getValidator() throws OdaException {
        return this.m_contributorInfo.getValidator();
    }

    public Integer getMinArguments() {
        return this.m_minArgs;
    }

    public boolean supportsUnboundedMaxArguments() {
        return this.getMaxArguments() == null;
    }

    public Integer getMaxArguments() {
        return this.m_maxArgs;
    }

    public boolean canIgnoreDuplicateValues() {
        return this.m_canIgnoreDupls;
    }

    public VariableRestrictions getVariableRestrictions() {
        return this.m_varRestrictions;
    }
}

