/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading;

import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.ILoadingService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.loading.LoadingNodeDoubleKeyCollection;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class LoadingNode
implements ILabelProvider {
    private static final String LOADING = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.LOADING");
    private static final LoadingNodeDoubleKeyCollection loadingFiles = new LoadingNodeDoubleKeyCollection();
    private static final LoadingNodeDoubleKeyCollection placeHolders = new LoadingNodeDoubleKeyCollection();
    public static final LoadingNode LOADING_FAMILY = new LoadingNode();
    private String text;
    private String text1;
    private String text2;
    private String text3;
    private int count = 0;
    private boolean disposed = false;

    public static synchronized LoadingNode createPlaceHolder(Object parent, ILoadingService loadingService) {
        LoadingNode node = null;
        if (!placeHolders.containsKey(parent, loadingService)) {
            node = new LoadingNode(loadingService);
            placeHolders.put(parent, loadingService, node);
        }
        return node;
    }

    private LoadingNode() {
    }

    public LoadingNode(ILoadingService loadingService) {
        this.text = NLS.bind((String)LOADING, (Object)loadingService.getLoadingDescription());
        this.text1 = String.valueOf(this.text) + ".";
        this.text2 = String.valueOf(this.text) + "..";
        this.text3 = String.valueOf(this.text) + "...";
    }

    public String getText(Object element) {
        switch (this.count % 4) {
            case 0: {
                return this.text;
            }
            case 1: {
                return this.text1;
            }
            case 2: {
                return this.text2;
            }
        }
        return this.text3;
    }

    public Image getImage(Object element) {
        ++this.count;
        switch (this.count %= 4) {
            case 0: {
                return ResourceLoader.INSTANCE.queryImageFromRegistry("loading1.gif");
            }
            case 1: {
                return ResourceLoader.INSTANCE.queryImageFromRegistry("loading2.gif");
            }
            case 2: {
                return ResourceLoader.INSTANCE.queryImageFromRegistry("loading3.gif");
            }
        }
        return ResourceLoader.INSTANCE.queryImageFromRegistry("loading4.gif");
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose(Object parent, LoadingNode placeHolder) {
        this.disposed = true;
        ILoadingService loadingService = placeHolders.queryLoadingService(parent, placeHolder);
        loadingFiles.remove(parent, loadingService);
        placeHolders.remove(parent, loadingService);
    }

    public static synchronized boolean canBeginLoading(Object parent, ILoadingService loadingService) {
        if (!loadingFiles.containsKey(parent, loadingService)) {
            loadingFiles.put(parent, loadingService, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading() {
        LoadingNodeDoubleKeyCollection loadingNodeDoubleKeyCollection = loadingFiles;
        synchronized (loadingNodeDoubleKeyCollection) {
            return !loadingFiles.isEmpty();
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

