/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.builder.AbstractTypeLeakDetector;
import org.eclipse.pde.api.tools.internal.model.MethodKey;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class LeakExtendsProblemDetector
extends AbstractTypeLeakDetector {
    public LeakExtendsProblemDetector(Set nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    public int getReferenceKinds() {
        return 1;
    }

    protected String getSeverityKey() {
        return "LEAK_EXTEND";
    }

    protected int getProblemFlags(IReference reference) {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isProblem(IReference reference) {
        if (!super.isProblem(reference)) return false;
        IApiType type = (IApiType)reference.getMember();
        IApiComponent component = type.getApiComponent();
        try {
            if (!type.isClass()) return true;
            int modifiers = 0;
            IApiAnnotations annotations = component.getApiDescription().resolveAnnotations(type.getHandle());
            if (annotations == null) return false;
            modifiers = RestrictionModifiers.isExtendRestriction(annotations.getRestrictions()) ? 1 : (Flags.isFinal((int)type.getModifiers()) ? 1 : 5);
            IApiType nonApiSuper = type.getSuperclass();
            HashSet methods = new HashSet();
            while (!this.isAPIType(nonApiSuper)) {
                if (this.hasVisibleField(nonApiSuper, modifiers)) {
                    return true;
                }
                this.gatherVisibleMethods(nonApiSuper, methods, modifiers);
                nonApiSuper = nonApiSuper.getSuperclass();
            }
            if (methods.size() <= 0) return false;
            LinkedList<IApiType> apiTypes = new LinkedList<IApiType>();
            apiTypes.add(type);
            this.gatherAPISuperTypes(apiTypes, type);
            Iterator iterator2 = apiTypes.iterator();
            while (iterator2.hasNext()) {
                IApiType t2 = (IApiType)iterator2.next();
                HashSet apiMembers = new HashSet();
                this.gatherVisibleMethods(t2, apiMembers, modifiers);
                methods.removeAll(apiMembers);
                if (methods.size() != 0) continue;
                return false;
            }
            if (methods.size() <= 0) return false;
            return true;
        }
        catch (CoreException ce) {
            if (!DEBUG) return true;
            ApiPlugin.log(ce);
            return true;
        }
    }

    private void gatherVisibleMethods(IApiType type, Set members, int modifiers) {
        IApiMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            IApiMethod method = methods[i];
            if ((method.getModifiers() & modifiers) > 0 && !method.isConstructor() && !method.isSynthetic()) {
                members.add(new MethodKey(method.getName(), method.getSignature()));
            }
            ++i;
        }
    }

    private boolean hasVisibleField(IApiType type, int modifiers) {
        IApiField[] fields = type.getFields();
        int i = 0;
        while (i < fields.length) {
            IApiField field = fields[i];
            if ((field.getModifiers() & modifiers) > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void gatherAPISuperTypes(List superTypes, IApiType type) throws CoreException {
        if (type != null) {
            if (this.isAPIType(type)) {
                superTypes.add(0, type);
            }
            this.gatherAPISuperTypes(superTypes, type.getSuperclass());
            IApiType[] interfaces = type.getSuperInterfaces();
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    if (this.isAPIType(interfaces[i])) {
                        superTypes.add(interfaces[i]);
                        this.gatherAPISuperTypes(superTypes, interfaces[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean isAPIType(IApiType type) throws CoreException {
        IApiDescription description = type.getApiComponent().getApiDescription();
        IApiAnnotations annotations = description.resolveAnnotations(type.getHandle());
        if (annotations == null) {
            return false;
        }
        return VisibilityModifiers.isAPI(annotations.getVisibility());
    }
}

