/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagValidator
extends ASTVisitor {
    private ArrayList fTagProblems = null;
    private ICompilationUnit fCompilationUnit = null;
    private static final IApiJavadocTag[] NO_TAGS = new IApiJavadocTag[0];

    public TagValidator(ICompilationUnit parent) {
        this.fCompilationUnit = parent;
    }

    public boolean visit(Javadoc node) {
        ASTNode parent = node.getParent();
        if (parent != null) {
            List tags = node.tags();
            this.validateTags(parent, tags);
        }
        return false;
    }

    private void validateTags(ASTNode node, List tags) {
        if (tags.size() == 0) {
            return;
        }
        JavadocTagManager jtm = ApiPlugin.getJavadocTagManager();
        switch (node.getNodeType()) {
            case 55: {
                TypeDeclaration type = (TypeDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(type.isInterface() ? 2 : 1, 16);
                HashSet<String> invalidtags = new HashSet<String>(validtags.length);
                String context = BuilderMessages.TagValidator_an_interface;
                if (!type.isInterface()) {
                    context = BuilderMessages.TagValidator_a_class;
                    if (Flags.isAbstract((int)type.getModifiers())) {
                        context = BuilderMessages.TagValidator_an_abstract_class;
                        invalidtags.add("@noinstantiate");
                    }
                    if (Flags.isFinal((int)type.getModifiers())) {
                        context = BuilderMessages.TagValidator_a_final_class;
                        invalidtags.add("@noextend");
                    }
                }
                if (invalidtags.size() > 0) {
                    ArrayList<IApiJavadocTag> vtags = new ArrayList<IApiJavadocTag>(validtags.length);
                    int i = 0;
                    while (i < validtags.length) {
                        if (!invalidtags.contains(validtags[i].getTagName())) {
                            vtags.add(validtags[i]);
                        }
                        ++i;
                    }
                    validtags = vtags.toArray(new IApiJavadocTag[vtags.size()]);
                }
                this.processTags(this.getTypeName((ASTNode)type), tags, validtags, 2, context);
                break;
            }
            case 71: {
                EnumDeclaration enumm = (EnumDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(64, 16);
                this.processTags(this.getTypeName((ASTNode)enumm), tags, validtags, 2, BuilderMessages.TagValidator_an_enum);
                break;
            }
            case 72: {
                EnumConstantDeclaration decl = (EnumConstantDeclaration)node;
                this.processTags(this.getTypeName((ASTNode)decl), tags, new IApiJavadocTag[0], 5, BuilderMessages.TagValidator_an_enum_constant);
                break;
            }
            case 81: {
                AnnotationTypeDeclaration annot = (AnnotationTypeDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(128, 16);
                this.processTags(this.getTypeName((ASTNode)annot), tags, validtags, 2, BuilderMessages.TagValidator_an_annotation);
                break;
            }
            case 31: {
                MethodDeclaration method = (MethodDeclaration)node;
                int pkind = this.getParentKind(node);
                String context = null;
                int mods = method.getModifiers();
                boolean isprivate = Flags.isPrivate((int)mods);
                boolean isconstructor = method.isConstructor();
                boolean isfinal = Flags.isFinal((int)mods);
                boolean isstatic = Flags.isStatic((int)mods);
                boolean pfinal = false;
                switch (pkind) {
                    case 64: {
                        context = isprivate ? BuilderMessages.TagValidator_private_enum_method : BuilderMessages.TagValidator_an_enum_method;
                        break;
                    }
                    case 2: {
                        context = BuilderMessages.TagValidator_an_interface_method;
                        break;
                    }
                    default: {
                        pfinal = Flags.isFinal((int)this.getParentModifiers((ASTNode)method));
                        context = isprivate ? (isconstructor ? BuilderMessages.TagValidator_private_constructor : BuilderMessages.TagValidator_private_method) : (isstatic && isfinal ? BuilderMessages.TagValidator_a_static_final_method : (isfinal ? BuilderMessages.TagValidator_a_final_method : (isstatic ? BuilderMessages.TagValidator_a_static_method : (pfinal ? BuilderMessages.TagValidator_a_method_in_a_final_class : (isconstructor ? BuilderMessages.TagValidator_a_constructor : BuilderMessages.TagValidator_a_method)))));
                    }
                }
                IApiJavadocTag[] validtags = NO_TAGS;
                if (!isprivate) {
                    validtags = jtm.getTagsForType(pkind, isconstructor ? 32 : 4);
                }
                if (isfinal || isstatic || pfinal) {
                    ArrayList<IApiJavadocTag> ttags = new ArrayList<IApiJavadocTag>(validtags.length);
                    int i = 0;
                    while (i < validtags.length) {
                        if (!validtags[i].getTagName().equals("@nooverride")) {
                            ttags.add(validtags[i]);
                        }
                        ++i;
                    }
                    validtags = ttags.toArray(new IApiJavadocTag[ttags.size()]);
                }
                this.processTags(this.getTypeName((ASTNode)method), tags, validtags, 6, context);
                break;
            }
            case 82: {
                AnnotationTypeMemberDeclaration decl = (AnnotationTypeMemberDeclaration)node;
                IApiJavadocTag[] validtags = jtm.getTagsForType(128, 4);
                this.processTags(this.getTypeName((ASTNode)decl), tags, validtags, 6, BuilderMessages.TagValidator_an_annotation_method);
                break;
            }
            case 23: {
                FieldDeclaration field = (FieldDeclaration)node;
                int pkind = this.getParentKind(node);
                String context = null;
                boolean isfinal = Flags.isFinal((int)field.getModifiers());
                boolean isprivate = Flags.isPrivate((int)field.getModifiers());
                switch (pkind) {
                    case 128: {
                        context = BuilderMessages.TagValidator_annotation_field;
                        if (!isfinal) break;
                        context = BuilderMessages.TagValidator_a_final_annotation_field;
                        break;
                    }
                    case 64: {
                        context = isprivate ? BuilderMessages.TagValidator_private_enum_field : BuilderMessages.TagValidator_enum_field;
                        break;
                    }
                    default: {
                        context = isprivate ? BuilderMessages.TagValidator_private_field : (isfinal ? BuilderMessages.TagValidator_a_final_field : BuilderMessages.TagValidator_a_field);
                    }
                }
                IApiJavadocTag[] validtags = NO_TAGS;
                if (!isprivate && !isfinal) {
                    validtags = jtm.getTagsForType(pkind, 8);
                }
                this.processTags(this.getTypeName((ASTNode)field), tags, validtags, 5, context);
            }
        }
    }

    private int getParentModifiers(ASTNode node) {
        if (node == null) {
            return 0;
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
            return type.getModifiers();
        }
        return this.getParentModifiers(node.getParent());
    }

    private String getTypeName(ASTNode node) {
        return this.getTypeName(node, new StringBuffer());
    }

    private String getTypeName(ASTNode node, StringBuffer buffer) {
        switch (node.getNodeType()) {
            case 15: {
                CompilationUnit unit = (CompilationUnit)node;
                PackageDeclaration packageDeclaration = unit.getPackage();
                if (packageDeclaration != null) {
                    buffer.insert(0, '.');
                    buffer.insert(0, packageDeclaration.getName().getFullyQualifiedName());
                }
                return String.valueOf(buffer);
            }
        }
        if (node instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
            if (typeDeclaration.isPackageMemberTypeDeclaration()) {
                buffer.insert(0, typeDeclaration.getName().getIdentifier());
            } else {
                buffer.insert(0, typeDeclaration.getName().getFullyQualifiedName());
                buffer.insert(0, '$');
            }
        }
        return this.getTypeName(node.getParent(), buffer);
    }

    private void processTags(String typeName, List tags, IApiJavadocTag[] validtags, int element, String context) {
        IApiJavadocTag[] alltags = ApiPlugin.getJavadocTagManager().getAllTags();
        Set tagnames = ApiPlugin.getJavadocTagManager().getAllTagNames();
        HashSet<String> invalidtags = new HashSet<String>(alltags.length);
        int i = 0;
        while (i < alltags.length) {
            invalidtags.add(alltags[i].getTagName());
            ++i;
        }
        i = 0;
        while (i < validtags.length) {
            invalidtags.remove(validtags[i]);
            ++i;
        }
        if (invalidtags.size() == 0) {
            return;
        }
        TagElement tag = null;
        HashSet<String> tagz = new HashSet<String>(tags.size());
        String tagname = null;
        Iterator iter = tags.iterator();
        while (iter.hasNext()) {
            tag = (TagElement)iter.next();
            tagname = tag.getTagName();
            if (invalidtags.contains(tag.getTagName())) {
                this.processTagProblem(typeName, tag, element, 7, 6, context);
            }
            if (!tagnames.contains(tag.getTagName()) || tagz.add(tagname)) continue;
            this.processTagProblem(typeName, tag, element, 8, 7, null);
        }
    }

    private void processTagProblem(String typeName, TagElement tag, int element, int kind, int markerid, String context) {
        if (this.fTagProblems == null) {
            this.fTagProblems = new ArrayList(10);
        }
        int charstart = tag.getStartPosition();
        int charend = charstart + tag.getTagName().length();
        int linenumber = -1;
        try {
            IDocument document = Util.getDocument(this.fCompilationUnit);
            linenumber = document.getLineOfOffset(charstart);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        try {
            IApiProblem problem = ApiProblemFactory.newApiProblem(this.fCompilationUnit.getCorrespondingResource().getProjectRelativePath().toPortableString(), typeName, new String[]{tag.getTagName(), context}, new String[]{"apiMarkerID", "org.eclipse.jdt.internal.core.JavaModelManager.handleId"}, new Object[]{new Integer(markerid), this.fCompilationUnit.getHandleIdentifier()}, linenumber, charstart, charend, 0x20000000, element, kind, 0);
            this.fTagProblems.add(problem);
        }
        catch (JavaModelException javaModelException) {}
    }

    private int getParentKind(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node instanceof TypeDeclaration) {
            return ((TypeDeclaration)node).isInterface() ? 2 : 1;
        }
        if (node instanceof AnnotationTypeDeclaration) {
            return 128;
        }
        if (node instanceof EnumDeclaration) {
            return 64;
        }
        return this.getParentKind(node.getParent());
    }

    public IApiProblem[] getTagProblems() {
        if (this.fTagProblems == null) {
            return new IApiProblem[0];
        }
        return this.fTagProblems.toArray(new IApiProblem[this.fTagProblems.size()]);
    }
}

