/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ResourceApiTypeRoot;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public class FolderApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private IContainer fRoot;

    public FolderApiTypeContainer(IApiElement parent, IContainer container) {
        super(parent, 3, container.getName());
        this.fRoot = container;
    }

    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        this.doVisit(this.fRoot, "", visitor);
    }

    public void close() throws CoreException {
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Folder Class File Container: " + this.getName());
        return buff.toString();
    }

    private void doVisit(IContainer container, String pkgName, ApiTypeContainerVisitor visitor) throws CoreException {
        IResource[] members = container.members();
        ArrayList<IResource> dirs = new ArrayList<IResource>();
        boolean visitPkg = visitor.visitPackage(pkgName);
        int i = 0;
        while (i < members.length) {
            IResource file = members[i];
            switch (file.getType()) {
                case 2: {
                    dirs.add(file);
                    break;
                }
                case 1: {
                    if (!visitPkg || !file.getName().endsWith(".class")) break;
                    String name = file.getName();
                    String typeName = name.substring(0, name.length() - 6);
                    if (pkgName.length() > 0) {
                        StringBuffer buf = new StringBuffer(pkgName);
                        buf.append('.');
                        buf.append(typeName);
                        typeName = buf.toString();
                    }
                    ResourceApiTypeRoot cf = new ResourceApiTypeRoot((IApiElement)this, (IFile)file, typeName);
                    visitor.visit(pkgName, cf);
                    visitor.end(pkgName, cf);
                }
            }
            ++i;
        }
        visitor.endVisitPackage(pkgName);
        Iterator iterator = dirs.iterator();
        while (iterator.hasNext()) {
            IContainer child = (IContainer)iterator.next();
            String nextName = null;
            if (pkgName.length() == 0) {
                nextName = child.getName();
            } else {
                StringBuffer buffer = new StringBuffer(pkgName);
                buffer.append('.');
                buffer.append(child.getName());
                nextName = buffer.toString();
            }
            this.doVisit(child, nextName, visitor);
        }
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IFile file;
        IFolder folder;
        int index = qualifiedName.lastIndexOf(46);
        String cfName = qualifiedName;
        String pkg = "";
        if (index > 0) {
            pkg = qualifiedName.substring(0, index);
            cfName = qualifiedName.substring(index + 1);
        }
        if ((folder = this.fRoot.getFolder((IPath)new Path(pkg.replace('.', '/')))).exists() && (file = folder.getFile(String.valueOf(cfName) + ".class")).exists()) {
            return new ResourceApiTypeRoot((IApiElement)this, file, qualifiedName);
        }
        return null;
    }

    public String[] getPackageNames() throws CoreException {
        ArrayList names = new ArrayList();
        this.collectPackageNames(names, "", this.fRoot);
        Object[] result = new String[names.size()];
        names.toArray(result);
        Arrays.sort(result);
        return result;
    }

    private void collectPackageNames(List names, String packageName, IContainer dir) throws CoreException {
        IResource[] members = dir.members();
        boolean hasClassFiles = false;
        ArrayList<IResource> dirs = new ArrayList<IResource>();
        int i = 0;
        while (i < members.length) {
            IResource file = members[i];
            switch (file.getType()) {
                case 2: {
                    dirs.add(file);
                    break;
                }
                case 1: {
                    if (hasClassFiles || !file.getName().endsWith(".class")) break;
                    names.add(packageName);
                    hasClassFiles = true;
                }
            }
            ++i;
        }
        Iterator iterator = dirs.iterator();
        while (iterator.hasNext()) {
            IContainer child = (IContainer)iterator.next();
            String nextName = null;
            if (packageName.length() == 0) {
                nextName = child.getName();
            } else {
                StringBuffer buffer = new StringBuffer(packageName);
                buffer.append('.');
                buffer.append(child.getName());
                nextName = buffer.toString();
            }
            this.collectPackageNames(names, nextName, child);
        }
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }
}

