/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.ApiFilterStore;
import org.eclipse.pde.api.tools.internal.CompositeApiDescription;
import org.eclipse.pde.api.tools.internal.ProjectApiDescription;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.BundleApiComponent;
import org.eclipse.pde.api.tools.internal.model.CompositeApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.FolderApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class PluginProjectApiComponent
extends BundleApiComponent {
    private static boolean DEBUG = Util.DEBUG;
    private IJavaProject fProject = null;
    private IPluginModelBase fModel = null;
    private Map fPathToOutputContainers = null;
    private Map fOutputLocationToContainer = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public PluginProjectApiComponent(IApiBaseline profile, String location, IPluginModelBase model) throws CoreException {
        super(profile, location);
        Path path = new Path(location);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        this.fProject = JavaCore.create((IProject)project);
        this.fModel = model;
        this.setName(this.fModel.getResourceString(super.getName()));
    }

    protected boolean isBinaryBundle() {
        return false;
    }

    protected boolean isApiEnabled() {
        return Util.isApiProject(this.fProject);
    }

    public void dispose() {
        try {
            try {
                if (this.isApiDescriptionInitialized()) {
                    try {
                        IApiDescription description = this.getApiDescription();
                        if (description instanceof ProjectApiDescription) {
                            ((ProjectApiDescription)description).disconnect(this.getBundleDescription());
                        } else if (description instanceof CompositeApiDescription) {
                            ((CompositeApiDescription)description).disconnect(this.getBundleDescription());
                        }
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e.getStatus());
                    }
                }
                if (this.hasApiFilterStore()) {
                    this.getFilterStore().dispose();
                }
                this.fModel = null;
                if (this.fOutputLocationToContainer != null) {
                    this.fOutputLocationToContainer.clear();
                    this.fOutputLocationToContainer = null;
                }
                if (this.fPathToOutputContainers != null) {
                    this.fPathToOutputContainers.clear();
                    this.fPathToOutputContainers = null;
                }
            }
            catch (CoreException ce) {
                ApiPlugin.log(ce);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    protected IApiDescription createLocalApiDescription() throws CoreException {
        long time = System.currentTimeMillis();
        if (Util.isApiProject(this.getJavaProject())) {
            this.setHasApiDescription(true);
        }
        IApiDescription apiDesc = ApiDescriptionManager.getDefault().getApiDescription(this, this.getBundleDescription());
        if (DEBUG) {
            System.out.println("Time to create api description for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return apiDesc;
    }

    protected IApiFilterStore createApiFilterStore() throws CoreException {
        long time = System.currentTimeMillis();
        ApiFilterStore store = new ApiFilterStore(this.getJavaProject());
        if (DEBUG) {
            System.out.println("Time to create api filter store for: [" + this.fProject.getElementName() + "] " + (System.currentTimeMillis() - time) + "ms");
        }
        return store;
    }

    protected synchronized List createApiTypeContainers() throws CoreException {
        block15: {
            block16: {
                IBuild build;
                block17: {
                    this.fPathToOutputContainers = new HashMap(4);
                    this.fOutputLocationToContainer = new HashMap(4);
                    if (!this.fProject.exists() || !this.fProject.getProject().isOpen()) break block15;
                    IFile prop = this.fProject.getProject().getFile("build.properties");
                    if (!prop.exists()) break block16;
                    WorkspaceBuildModel properties = new WorkspaceBuildModel(prop);
                    build = properties.getBuild();
                    IBuildEntry entry = build.getEntry("custom");
                    if (entry == null) break block17;
                    String[] tokens = entry.getTokens();
                    if (tokens.length != 1 || !tokens[0].equals("true")) break block16;
                    IClasspathEntry[] classpathEntries = this.fProject.getRawClasspath();
                    ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
                    int i = 0;
                    while (i < classpathEntries.length) {
                        IClasspathEntry classpathEntry = classpathEntries[i];
                        switch (classpathEntry.getEntryKind()) {
                            case 3: {
                                String containerPath = classpathEntry.getPath().removeFirstSegments(1).toString();
                                IApiTypeContainer container = this.getApiTypeContainer(containerPath, this);
                                if (container == null || containers.contains(container)) break;
                                containers.add(container);
                                break;
                            }
                            case 4: {
                                classpathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry);
                            }
                            case 1: {
                                IPath path = classpathEntry.getPath();
                                if (!Util.isArchive(path.lastSegment())) break;
                                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                                if (resource != null) {
                                    containers.add(new ArchiveApiTypeContainer(this, resource.getLocation().toOSString()));
                                    break;
                                }
                                containers.add(new ArchiveApiTypeContainer(this, path.toOSString()));
                            }
                        }
                        ++i;
                    }
                    if (containers.isEmpty()) break block16;
                    IApiTypeContainer cfc = null;
                    cfc = containers.size() == 1 ? (IApiTypeContainer)containers.get(0) : new CompositeApiTypeContainer(this, containers);
                    this.fPathToOutputContainers.put(".", cfc);
                    break block16;
                }
                IBuildEntry[] entries = build.getBuildEntries();
                int length = entries.length;
                int i = 0;
                while (i < length) {
                    IBuildEntry buildEntry = entries[i];
                    if (buildEntry.getName().startsWith("source.")) {
                        String jar = buildEntry.getName().substring("source.".length());
                        String[] tokens = buildEntry.getTokens();
                        if (tokens.length == 1) {
                            IApiTypeContainer container = this.getApiTypeContainer(tokens[0], this);
                            if (container != null) {
                                this.fPathToOutputContainers.put(jar, container);
                            }
                        } else {
                            ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
                            int j = 0;
                            while (j < tokens.length) {
                                String currentToken = tokens[j];
                                IApiTypeContainer container = this.getApiTypeContainer(currentToken, this);
                                if (container != null && !containers.contains(container)) {
                                    containers.add(container);
                                }
                                ++j;
                            }
                            if (!containers.isEmpty()) {
                                IApiTypeContainer cfc = null;
                                cfc = containers.size() == 1 ? (IApiTypeContainer)containers.get(0) : new CompositeApiTypeContainer(this, containers);
                                this.fPathToOutputContainers.put(jar, cfc);
                            }
                        }
                    }
                    ++i;
                }
            }
            return super.createApiTypeContainers();
        }
        return Collections.EMPTY_LIST;
    }

    protected IApiTypeContainer createApiTypeContainer(String path) throws IOException, CoreException {
        IApiTypeContainer container;
        if (this.fPathToOutputContainers == null) {
            this.baselineDisposed();
        }
        if ((container = (IApiTypeContainer)this.fPathToOutputContainers.get(path)) == null) {
            container = this.findApiTypeContainer(path);
        }
        return container;
    }

    private IApiTypeContainer findApiTypeContainer(String location) {
        IResource res = this.fProject.getProject().findMember((IPath)new Path(location));
        if (res != null) {
            if (res.getType() == 1) {
                return new ArchiveApiTypeContainer(this, res.getLocation().toOSString());
            }
            return new DirectoryApiTypeContainer(this, res.getLocation().toOSString());
        }
        return null;
    }

    private IApiTypeContainer getApiTypeContainer(String location, IApiComponent component) throws CoreException {
        IPackageFragmentRoot root;
        IResource res;
        if (this.fOutputLocationToContainer == null) {
            this.baselineDisposed();
        }
        if ((res = this.fProject.getProject().findMember((IPath)new Path(location))) != null && (root = this.fProject.getPackageFragmentRoot(res)).exists()) {
            if (root.getKind() == 2) {
                if (res.getType() == 2) {
                    IPath location2 = res.getLocation();
                    IApiTypeContainer cfc = (IApiTypeContainer)this.fOutputLocationToContainer.get(location2);
                    if (cfc == null) {
                        cfc = new FolderApiTypeContainer(component, (IContainer)res);
                        this.fOutputLocationToContainer.put(location2, cfc);
                    }
                    return cfc;
                }
            } else {
                IApiTypeContainer cfc;
                IClasspathEntry entry = root.getRawClasspathEntry();
                IPath outputLocation = entry.getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = this.fProject.getOutputLocation();
                }
                if ((cfc = (IApiTypeContainer)this.fOutputLocationToContainer.get(outputLocation)) == null) {
                    IPath projectFullPath = this.fProject.getProject().getFullPath();
                    Object container = null;
                    container = projectFullPath.equals((Object)outputLocation) ? this.fProject.getProject() : this.fProject.getProject().getWorkspace().getRoot().getFolder(outputLocation);
                    if (container.exists()) {
                        cfc = new FolderApiTypeContainer(component, (IContainer)container);
                        this.fOutputLocationToContainer.put(outputLocation, cfc);
                    }
                }
                return cfc;
            }
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }
}

