/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.sections;

import java.util.HashMap;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StyleComboDialogField;
import org.eclipse.jst.pagedesigner.commands.single.ChangeAttributeCommand;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.jsf.ui.sections.SectionResources;
import org.eclipse.jst.pagedesigner.meta.EditorCreator;
import org.eclipse.jst.pagedesigner.properties.internal.AttributeGroup;
import org.eclipse.jst.pagedesigner.ui.dialogfields.DialogFieldWrapper;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class JSFCoreConvertNumberGroup
extends AttributeGroup {
    private StyleComboDialogField _typeField;
    private StyleComboDialogField _patternField;
    private StyleComboDialogField _currencyCodeField;
    private StringDialogField _currencySymbolField;
    private static final String[] TYPES = new String[]{"number", "currency", "percentage", "custom"};

    public JSFCoreConvertNumberGroup() {
        super("http://java.sun.com/jsf/core", "convertNumber", new String[]{"type", "currencyCode", "currencySymbol", "pattern"});
    }

    protected DialogField createDialogField(IPropertyPageDescriptor ppd) {
        EditorCreator creator = EditorCreator.getInstance();
        if (ppd.getAttributeName().equals("type")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(this.getURI(), this.getTagName(), ppd, null);
            this._typeField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            this._typeField.setItems(TYPES);
            return wrapper;
        }
        if (ppd.getAttributeName().equals("currencyCode")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(this.getURI(), this.getTagName(), ppd, null);
            this._currencyCodeField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            return wrapper;
        }
        if (ppd.getAttributeName().equals("currencySymbol")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(this.getURI(), this.getTagName(), ppd, null);
            this._currencySymbolField = (StringDialogField)wrapper.getWrappedDialogField();
            return wrapper;
        }
        if (ppd.getAttributeName().equals("pattern")) {
            DialogFieldWrapper wrapper = (DialogFieldWrapper)creator.createDialogFieldWithWrapper(this.getURI(), this.getTagName(), ppd, null);
            this._patternField = (StyleComboDialogField)wrapper.getWrappedDialogField();
            return wrapper;
        }
        return null;
    }

    public IDialogFieldApplyListener getDialogFieldApplyListener(IPropertyPageDescriptor ppd) {
        String attribute = ppd.getAttributeName();
        if (attribute.equals("currencyCode") || attribute.equals("currencySymbol") || attribute.equals("pattern")) {
            IDialogFieldApplyListener listener = new IDialogFieldApplyListener(){

                public void dialogFieldApplied(DialogField field) {
                    JSFCoreConvertNumberGroup.this.updateFieldData();
                }
            };
            return listener;
        }
        if (attribute.equals("type")) {
            IDialogFieldApplyListener listener = new IDialogFieldApplyListener(){

                public void dialogFieldApplied(DialogField field) {
                    JSFCoreConvertNumberGroup.this.updateFieldStatus();
                    JSFCoreConvertNumberGroup.this.updateFieldData();
                }
            };
            return listener;
        }
        return null;
    }

    public void refreshData() {
        IDOMElement element = this.getElement();
        String type = element.getAttribute("type");
        if (!this._typeField.getText().equalsIgnoreCase(TYPES[3])) {
            this._typeField.setTextWithoutUpdate(type);
        }
        String currencyCode = element.getAttribute("currencyCode");
        this._currencyCodeField.setTextWithoutUpdate(currencyCode);
        String currencySymbol = element.getAttribute("currencySymbol");
        this._currencySymbolField.setTextWithoutUpdate(currencySymbol);
        String pattern = element.getAttribute("pattern");
        this._patternField.setTextWithoutUpdate(pattern);
        this.updateFieldStatus();
    }

    private void updateFieldStatus() {
        String type = this._typeField.getText();
        if (type.equalsIgnoreCase(TYPES[0])) {
            this._currencyCodeField.setEnabled(false);
            this._currencySymbolField.setEnabled(false);
            this._patternField.setEnabled(false);
        } else if (type.equalsIgnoreCase(TYPES[1])) {
            this._currencyCodeField.setEnabled(true);
            this._currencySymbolField.setEnabled(true);
            this._patternField.setEnabled(false);
        } else if (type.equalsIgnoreCase(TYPES[2])) {
            this._currencyCodeField.setEnabled(false);
            this._currencySymbolField.setEnabled(false);
            this._patternField.setEnabled(false);
        } else if (type.equalsIgnoreCase(TYPES[3])) {
            this._currencyCodeField.setEnabled(false);
            this._currencySymbolField.setEnabled(false);
            this._patternField.setEnabled(true);
        }
    }

    private void updateFieldData() {
        String type = this._typeField.getText();
        String currencyCode = this._currencyCodeField.getText();
        String currencySymbol = this._currencySymbolField.getText();
        String pattern = this._patternField.getText();
        if (type.equalsIgnoreCase(TYPES[3])) {
            type = "";
        }
        if (!this._currencyCodeField.isEnabled()) {
            currencyCode = "";
        }
        if (!this._currencySymbolField.isEnabled()) {
            currencySymbol = "";
        }
        if (!this._patternField.isEnabled()) {
            pattern = "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("currencyCode", currencyCode);
        map.put("currencySymbol", currencySymbol);
        map.put("pattern", pattern);
        ChangeAttributeCommand c = new ChangeAttributeCommand(SectionResources.getString("JSFCoreConvertNumberSection.CommandLabel.ChangeAttribute"), this.getElement(), map);
        c.execute();
    }
}

