/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTemplateManager {
    private Map<String, Set<RepositoryTemplate>> templateByConnectorKind;

    public synchronized void addTemplate(String connectorKind, RepositoryTemplate template) {
        this.getTemplates(connectorKind).add(template);
    }

    public synchronized Set<RepositoryTemplate> getTemplates(String connectorKind) {
        Set<RepositoryTemplate> templates;
        if (this.templateByConnectorKind == null) {
            this.templateByConnectorKind = new HashMap<String, Set<RepositoryTemplate>>();
        }
        if ((templates = this.templateByConnectorKind.get(connectorKind)) == null) {
            templates = new LinkedHashSet<RepositoryTemplate>();
            this.templateByConnectorKind.put(connectorKind, templates);
        }
        return templates;
    }

    public synchronized void removeTemplate(String connectorKind, RepositoryTemplate template) {
        this.getTemplates(connectorKind).remove(template);
    }

    public synchronized RepositoryTemplate getTemplate(String connectorKind, String label) {
        for (RepositoryTemplate template : this.getTemplates(connectorKind)) {
            if (!template.label.equals(label)) continue;
            return template;
        }
        return null;
    }
}

