/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.core.collection.Messages;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryCollector
implements IUsageCollector {
    protected int numSelections = 0;
    protected int numEdits = 0;
    protected int numUserEvents = 0;
    protected Date leastRecentDate = new Date();
    protected Date mostRecentDate = new Date(0L);
    protected int numCommands = 0;
    protected int numPreference = 0;

    @Override
    public void consumeEvent(InteractionEvent event, int userId) {
        if (this.mostRecentDate.compareTo(event.getDate()) == -1) {
            this.mostRecentDate = event.getDate();
        }
        if (this.leastRecentDate.compareTo(event.getDate()) == 1) {
            this.leastRecentDate = event.getDate();
        }
        if (event.getKind().equals((Object)InteractionEvent.Kind.SELECTION)) {
            ++this.numSelections;
        } else if (event.getKind().equals((Object)InteractionEvent.Kind.EDIT)) {
            ++this.numEdits;
        } else if (event.getKind().equals((Object)InteractionEvent.Kind.COMMAND)) {
            ++this.numCommands;
        } else if (event.getKind().equals((Object)InteractionEvent.Kind.PREFERENCE)) {
            ++this.numPreference;
        }
        ++this.numUserEvents;
    }

    @Override
    public List<String> getReport() {
        ArrayList<String> summaries = new ArrayList<String>();
        summaries.add(String.valueOf(Messages.SummaryCollector_Start_date_) + this.leastRecentDate + Messages.SummaryCollector_END_DATE + this.mostRecentDate + "<br>");
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_events_) + this.numUserEvents + "<br>");
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_commands_) + this.numCommands + "<br>");
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_preference_changes) + this.numPreference + "<br>");
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_selections_) + this.numSelections + "<br>");
        return summaries;
    }

    @Override
    public String getReportTitle() {
        return Messages.SummaryCollector_Summary;
    }

    @Override
    public void exportAsCSVFile(String directory) {
    }

    @Override
    public List<String> getPlainTextReport() {
        ArrayList<String> summaries = new ArrayList<String>();
        summaries.add(String.valueOf(Messages.SummaryCollector_Start_date_) + this.leastRecentDate + Messages.SummaryCollector_END_DATE + this.mostRecentDate);
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_events_) + this.numUserEvents);
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_commands_) + this.numCommands);
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_preference_changes) + this.numPreference);
        summaries.add(String.valueOf(Messages.SummaryCollector_Number_of_selections_) + this.numSelections);
        return summaries;
    }
}

