/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityResultMetadata
extends ORMetadata {
    private Class m_entityClass;
    private List<FieldResultMetadata> m_fieldResults = new ArrayList<FieldResultMetadata>();
    private String m_discriminatorColumn;
    private String m_entityClassName;

    public EntityResultMetadata() {
        super("<entity-result>");
    }

    public EntityResultMetadata(Annotation entityResult, MetadataAccessibleObject accessibleObject) {
        super(entityResult, accessibleObject);
        this.m_entityClass = (Class)MetadataHelper.invokeMethod("entityClass", entityResult);
        this.m_discriminatorColumn = (String)MetadataHelper.invokeMethod("discriminatorColumn", entityResult);
        for (Annotation fieldResult : (Annotation[])MetadataHelper.invokeMethod("fields", entityResult)) {
            this.m_fieldResults.add(new FieldResultMetadata(fieldResult, accessibleObject));
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof EntityResultMetadata) {
            EntityResultMetadata entityResult = (EntityResultMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_entityClass, entityResult.getEntityClass())) {
                return false;
            }
            if (!this.valuesMatch(this.m_fieldResults, entityResult.getFieldResults())) {
                return false;
            }
            return this.valuesMatch(this.m_discriminatorColumn, entityResult.getDiscriminatorColumn());
        }
        return false;
    }

    public String getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    public String getEntityClassName() {
        return this.m_entityClassName;
    }

    public List<FieldResultMetadata> getFieldResults() {
        return this.m_fieldResults;
    }

    public boolean hasFieldResults() {
        return this.m_fieldResults != null && !this.m_fieldResults.isEmpty();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObjects(this.m_fieldResults, accessibleObject);
        this.m_entityClass = this.initXMLClassName(this.m_entityClassName);
    }

    public void setDiscriminatorColumn(String discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }

    public void setEntityClass(Class entityClass) {
        this.m_entityClass = entityClass;
    }

    public void setEntityClassName(String entityClassName) {
        this.m_entityClassName = entityClassName;
    }

    public void setFieldResults(List<FieldResultMetadata> fieldResults) {
        this.m_fieldResults = fieldResults;
    }
}

