/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.jsch.core.IPasswordStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Messages;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Plugin;

class JSchSession {
    private static final int SSH_DEFAULT_PORT = 22;
    private static Hashtable pool = new Hashtable();
    private final Session session;
    private final ICVSRepositoryLocation location;

    protected static int getCVSTimeoutInMillis() {
        return 60000;
    }

    public static boolean isAuthenticationFailure(JSchException ee) {
        return ee.getMessage().equals("Auth fail");
    }

    static JSchSession getSession(final ICVSRepositoryLocation location, String username, String password, String hostname, int port, IProgressMonitor monitor) throws JSchException {
        int actualPort = port;
        if (actualPort == 0) {
            actualPort = JSchSession.getPort(location);
        }
        String key = JSchSession.getPoolKey(username, hostname, actualPort);
        try {
            JSchSession jschSession = (JSchSession)pool.get(key);
            if (jschSession != null && !jschSession.getSession().isConnected()) {
                pool.remove(key);
                jschSession = null;
            }
            if (jschSession == null) {
                IJSchService service = JSchSession.getJSchService();
                IJSchLocation jlocation = service.getLocation(username, hostname, actualPort);
                if (!location.getMethod().getName().equals("pserverssh2")) {
                    IPasswordStore pstore = new IPasswordStore(){

                        public void clear(IJSchLocation l) {
                            location.flushUserInfo();
                        }

                        public boolean isCached(IJSchLocation l) {
                            return location.getUserInfoCached();
                        }

                        public void update(IJSchLocation l) {
                            location.setPassword(l.getPassword());
                            location.setAllowCaching(true);
                        }
                    };
                    jlocation.setPasswordStore(pstore);
                }
                jlocation.setComment(NLS.bind((String)CVSSSH2Messages.JSchSession_3, (Object[])new String[]{location.toString()}));
                Session session = null;
                session = JSchSession.createSession(service, jlocation, password, monitor);
                if (session == null) {
                    throw new JSchException(CVSSSH2Messages.JSchSession_4);
                }
                if (session.getTimeout() != location.getTimeout() * 1000) {
                    session.setTimeout(location.getTimeout() * 1000);
                }
                JSchSession schSession = new JSchSession(session, location);
                pool.put(key, schSession);
                return schSession;
            }
            return jschSession;
        }
        catch (JSchException e) {
            pool.remove(key);
            if (e.toString().indexOf("Auth cancel") != -1) {
                throw new OperationCanceledException();
            }
            throw e;
        }
    }

    private static Session createSession(IJSchService service, IJSchLocation location, String password, IProgressMonitor monitor) throws JSchException {
        Session session = service.createSession(location, null);
        session.setTimeout(JSchSession.getCVSTimeoutInMillis());
        if (password != null) {
            session.setPassword(password);
        }
        service.connect(session, JSchSession.getCVSTimeoutInMillis(), monitor);
        return session;
    }

    private static IJSchService getJSchService() {
        return CVSSSH2Plugin.getDefault().getJSchService();
    }

    private static String getPoolKey(String username, String hostname, int port) {
        return String.valueOf(username) + "@" + hostname + ":" + port;
    }

    private static String getPoolKey(ICVSRepositoryLocation location) {
        return String.valueOf(location.getUsername()) + "@" + location.getHost() + ":" + JSchSession.getPort(location);
    }

    private static int getPort(ICVSRepositoryLocation location) {
        int port = location.getPort();
        if (port == 0) {
            port = 22;
        }
        return port;
    }

    static void shutdown() {
        if (JSchSession.getJSch() != null && pool.size() > 0) {
            Enumeration e = pool.elements();
            while (e.hasMoreElements()) {
                JSchSession session = (JSchSession)e.nextElement();
                try {
                    session.getSession().disconnect();
                }
                catch (Exception exception) {}
            }
            pool.clear();
        }
    }

    static JSch getJSch() {
        return JSchSession.getJSchService().getJSch();
    }

    private JSchSession(Session session, ICVSRepositoryLocation location) {
        this.session = session;
        this.location = location;
    }

    public Session getSession() {
        return this.session;
    }

    public void dispose() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
        pool.remove(JSchSession.getPoolKey(this.location));
    }
}

