/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.ITransferList;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TransferList;
import org.eclipse.mylyn.internal.tasks.core.externalization.TaskListExternalizer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.PlatformUtil;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;

public class ImportExportUtil {
    public static void configureFilter(FileDialog dialog) {
        dialog.setFilterExtensions(PlatformUtil.getFilterExtensions("*.xml.zip"));
        dialog.setFilterNames(new String[]{NLS.bind((String)Messages.ImportExportUtil_Tasks_and_queries_Filter0, (Object)".xml.zip")});
    }

    public static void export(File file, IStructuredSelection selection) throws CoreException {
        TransferList list = new TransferList();
        for (Object element : selection) {
            if (element instanceof AbstractTaskCategory) {
                list.addCategory((TaskCategory)element);
                continue;
            }
            if (element instanceof RepositoryQuery) {
                list.addQuery((RepositoryQuery)element);
                continue;
            }
            if (!(element instanceof ITask)) continue;
            list.addTask((ITask)((AbstractTask)element));
        }
        TaskListExternalizer externalizer = TasksUiPlugin.getDefault().createTaskListExternalizer();
        externalizer.writeTaskList((ITransferList)list, file);
    }
}

